package fr.ifremer.tutti.ui.swing.content.referential;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.util.ActionListCellRenderer;
import static org.nuiton.i18n.I18n.t;

public class ManageTemporaryReferentialUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<ManageTemporaryReferentialUIModel, ManageTemporaryReferentialUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EXPORT_EXISTING_GEAR_BUTTON_ENABLED = "exportExistingGearButton.enabled";
    public static final String BINDING_EXPORT_EXISTING_PERSON_BUTTON_ENABLED = "exportExistingPersonButton.enabled";
    public static final String BINDING_EXPORT_EXISTING_SPECIES_BUTTON_ENABLED = "exportExistingSpeciesButton.enabled";
    public static final String BINDING_EXPORT_EXISTING_VESSEL_BUTTON_ENABLED = "exportExistingVesselButton.enabled";
    public static final String BINDING_GEAR_LABEL_TEXT = "gearLabel.text";
    public static final String BINDING_GEAR_LABEL_TOOL_TIP_TEXT = "gearLabel.toolTipText";
    public static final String BINDING_PERSON_LABEL_TEXT = "personLabel.text";
    public static final String BINDING_PERSON_LABEL_TOOL_TIP_TEXT = "personLabel.toolTipText";
    public static final String BINDING_REPLACE_GEAR_BUTTON_ENABLED = "replaceGearButton.enabled";
    public static final String BINDING_REPLACE_PERSON_BUTTON_ENABLED = "replacePersonButton.enabled";
    public static final String BINDING_REPLACE_SPECIES_BUTTON_ENABLED = "replaceSpeciesButton.enabled";
    public static final String BINDING_REPLACE_VESSEL_BUTTON_ENABLED = "replaceVesselButton.enabled";
    public static final String BINDING_SPECIES_LABEL_TEXT = "speciesLabel.text";
    public static final String BINDING_SPECIES_LABEL_TOOL_TIP_TEXT = "speciesLabel.toolTipText";
    public static final String BINDING_VESSEL_LABEL_TEXT = "vesselLabel.text";
    public static final String BINDING_VESSEL_LABEL_TOOL_TIP_TEXT = "vesselLabel.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(ManageTemporaryReferentialUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton exportExistingGearButton;
    protected JButton exportExistingPersonButton;
    protected JButton exportExistingSpeciesButton;
    protected JButton exportExistingVesselButton;
    protected JButton exportGearExampleButton;
    protected JButton exportPersonExampleButton;
    protected JButton exportSpeciesExampleButton;
    protected JButton exportVesselExampleButton;
    protected JComboBox gearActionComboBox;
    protected JLabel gearLabel;
    protected final ManageTemporaryReferentialUIHandler handler = createHandler();
    protected JButton importGearButton;
    protected JButton importPersonButton;
    protected JButton importSpeciesButton;
    protected JButton importVesselButton;
    protected ManageTemporaryReferentialUI manageTemporaryReferentialTopPanel = this;
    protected ManageTemporaryReferentialUIModel model;
    protected JComboBox personActionComboBox;
    protected JLabel personLabel;
    protected JButton replaceGearButton;
    protected JButton replacePersonButton;
    protected JButton replaceSpeciesButton;
    protected JButton replaceVesselButton;
    protected JComboBox speciesActionComboBox;
    protected JLabel speciesLabel;
    protected JComboBox vesselActionComboBox;
    protected JLabel vesselLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSeparator $JSeparator2;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ManageTemporaryReferentialUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public ManageTemporaryReferentialUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI() {
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__gearActionComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExportGearsAction(event);
    }

    public void doActionPerformed__on__personActionComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExportPersonsAction(event);
    }

    public void doActionPerformed__on__speciesActionComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExportSpeciesAction(event);
    }

    public void doActionPerformed__on__vesselActionComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExportVesselsAction(event);
    }

    public void doMouseClicked__on__gearActionComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExportGearsAction(event);
    }

    public void doMouseClicked__on__personActionComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExportPersonsAction(event);
    }

    public void doMouseClicked__on__speciesActionComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExportSpeciesAction(event);
    }

    public void doMouseClicked__on__vesselActionComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExportVesselsAction(event);
    }

    public void doMouseEntered__on__gearActionComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        gearActionComboBox.showPopup();
    }

    public void doMouseEntered__on__personActionComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        personActionComboBox.showPopup();
    }

    public void doMouseEntered__on__speciesActionComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        speciesActionComboBox.showPopup();
    }

    public void doMouseEntered__on__vesselActionComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        vesselActionComboBox.showPopup();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getExportExistingGearButton() {
        return exportExistingGearButton;
    }

    public JButton getExportExistingPersonButton() {
        return exportExistingPersonButton;
    }

    public JButton getExportExistingSpeciesButton() {
        return exportExistingSpeciesButton;
    }

    public JButton getExportExistingVesselButton() {
        return exportExistingVesselButton;
    }

    public JButton getExportGearExampleButton() {
        return exportGearExampleButton;
    }

    public JButton getExportPersonExampleButton() {
        return exportPersonExampleButton;
    }

    public JButton getExportSpeciesExampleButton() {
        return exportSpeciesExampleButton;
    }

    public JButton getExportVesselExampleButton() {
        return exportVesselExampleButton;
    }

    public JComboBox getGearActionComboBox() {
        return gearActionComboBox;
    }

    public JLabel getGearLabel() {
        return gearLabel;
    }

    public ManageTemporaryReferentialUIHandler getHandler() {
        return handler;
    }

    public JButton getImportGearButton() {
        return importGearButton;
    }

    public JButton getImportPersonButton() {
        return importPersonButton;
    }

    public JButton getImportSpeciesButton() {
        return importSpeciesButton;
    }

    public JButton getImportVesselButton() {
        return importVesselButton;
    }

    public ManageTemporaryReferentialUIModel getModel() {
        return model;
    }

    public JComboBox getPersonActionComboBox() {
        return personActionComboBox;
    }

    public JLabel getPersonLabel() {
        return personLabel;
    }

    public JButton getReplaceGearButton() {
        return replaceGearButton;
    }

    public JButton getReplacePersonButton() {
        return replacePersonButton;
    }

    public JButton getReplaceSpeciesButton() {
        return replaceSpeciesButton;
    }

    public JButton getReplaceVesselButton() {
        return replaceVesselButton;
    }

    public JComboBox getSpeciesActionComboBox() {
        return speciesActionComboBox;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JComboBox getVesselActionComboBox() {
        return vesselActionComboBox;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToManageTemporaryReferentialTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(exportSpeciesExampleButton);
        add(exportExistingSpeciesButton);
        add(importSpeciesButton);
        add(replaceSpeciesButton);
        add(exportVesselExampleButton);
        add(exportExistingVesselButton);
        add(importVesselButton);
        add(replaceVesselButton);
        add(exportGearExampleButton);
        add(exportExistingGearButton);
        add(importGearButton);
        add(replaceGearButton);
        add(exportPersonExampleButton);
        add(exportExistingPersonButton);
        add(importPersonButton);
        add(replacePersonButton);
        add($Table0, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.manageTemporaryReferential.help"));
    }

    protected void createExportExistingGearButton() {
        $objectMap.put("exportExistingGearButton", exportExistingGearButton = new JButton());
        
        exportExistingGearButton.setName("exportExistingGearButton");
        exportExistingGearButton.setText(t("tutti.manageTemporaryReferential.action.exportExistingTemporaryGear"));
        exportExistingGearButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportExistingTemporaryGear.tip"));
        exportExistingGearButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ExportExistingTemporaryGearAction.class);
        exportExistingGearButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportExistingTemporaryGear.help");
    }

    protected void createExportExistingPersonButton() {
        $objectMap.put("exportExistingPersonButton", exportExistingPersonButton = new JButton());
        
        exportExistingPersonButton.setName("exportExistingPersonButton");
        exportExistingPersonButton.setText(t("tutti.manageTemporaryReferential.action.exportExistingTemporaryPerson"));
        exportExistingPersonButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportExistingTemporaryPerson.tip"));
        exportExistingPersonButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ExportExistingTemporaryPersonAction.class);
        exportExistingPersonButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportExistingTemporaryPerson.help");
    }

    protected void createExportExistingSpeciesButton() {
        $objectMap.put("exportExistingSpeciesButton", exportExistingSpeciesButton = new JButton());
        
        exportExistingSpeciesButton.setName("exportExistingSpeciesButton");
        exportExistingSpeciesButton.setText(t("tutti.manageTemporaryReferential.action.exportExistingTemporarySpecies"));
        exportExistingSpeciesButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportExistingTemporarySpecies.tip"));
        exportExistingSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ExportExistingTemporarySpeciesAction.class);
        exportExistingSpeciesButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportExistingTemporarySpecies.help");
    }

    protected void createExportExistingVesselButton() {
        $objectMap.put("exportExistingVesselButton", exportExistingVesselButton = new JButton());
        
        exportExistingVesselButton.setName("exportExistingVesselButton");
        exportExistingVesselButton.setText(t("tutti.manageTemporaryReferential.action.exportExistingTemporaryVessel"));
        exportExistingVesselButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportExistingTemporaryVessel.tip"));
        exportExistingVesselButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ExportExistingTemporaryVesselAction.class);
        exportExistingVesselButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportExistingTemporaryVessel.help");
    }

    protected void createExportGearExampleButton() {
        $objectMap.put("exportGearExampleButton", exportGearExampleButton = new JButton());
        
        exportGearExampleButton.setName("exportGearExampleButton");
        exportGearExampleButton.setText(t("tutti.manageTemporaryReferential.action.exportTemporaryGearExample"));
        exportGearExampleButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportTemporaryGearExample.tip"));
        exportGearExampleButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ExportTemporaryGearExampleAction.class);
        exportGearExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporaryGearExample.help");
    }

    protected void createExportPersonExampleButton() {
        $objectMap.put("exportPersonExampleButton", exportPersonExampleButton = new JButton());
        
        exportPersonExampleButton.setName("exportPersonExampleButton");
        exportPersonExampleButton.setText(t("tutti.manageTemporaryReferential.action.exportTemporaryPersonExample"));
        exportPersonExampleButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportTemporaryPersonExample.tip"));
        exportPersonExampleButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ExportTemporaryPersonExampleAction.class);
        exportPersonExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporaryPersonExample.help");
    }

    protected void createExportSpeciesExampleButton() {
        $objectMap.put("exportSpeciesExampleButton", exportSpeciesExampleButton = new JButton());
        
        exportSpeciesExampleButton.setName("exportSpeciesExampleButton");
        exportSpeciesExampleButton.setText(t("tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample"));
        exportSpeciesExampleButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample.tip"));
        exportSpeciesExampleButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ExportTemporarySpeciesExampleAction.class);
        exportSpeciesExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample.help");
    }

    protected void createExportVesselExampleButton() {
        $objectMap.put("exportVesselExampleButton", exportVesselExampleButton = new JButton());
        
        exportVesselExampleButton.setName("exportVesselExampleButton");
        exportVesselExampleButton.setText(t("tutti.manageTemporaryReferential.action.exportTemporaryVesselExample"));
        exportVesselExampleButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportTemporaryVesselExample.tip"));
        exportVesselExampleButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ExportTemporaryVesselExampleAction.class);
        exportVesselExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporaryVesselExample.help");
    }

    protected void createGearActionComboBox() {
        $objectMap.put("gearActionComboBox", gearActionComboBox = new JComboBox());
        
        gearActionComboBox.setName("gearActionComboBox");
        gearActionComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearActionComboBox"));
        gearActionComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__gearActionComboBox"));
        gearActionComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__gearActionComboBox"));
    }

    protected void createGearLabel() {
        $objectMap.put("gearLabel", gearLabel = new JLabel());
        
        gearLabel.setName("gearLabel");
    }

    protected ManageTemporaryReferentialUIHandler createHandler() {
        return new ManageTemporaryReferentialUIHandler();
    }

    protected void createImportGearButton() {
        $objectMap.put("importGearButton", importGearButton = new JButton());
        
        importGearButton.setName("importGearButton");
        importGearButton.setText(t("tutti.manageTemporaryReferential.action.importTemporaryGear"));
        importGearButton.setToolTipText(t("tutti.manageTemporaryReferential.action.importTemporaryGear.tip"));
        importGearButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ImportTemporaryGearAction.class);
        importGearButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporaryGear.help");
    }

    protected void createImportPersonButton() {
        $objectMap.put("importPersonButton", importPersonButton = new JButton());
        
        importPersonButton.setName("importPersonButton");
        importPersonButton.setText(t("tutti.manageTemporaryReferential.action.importTemporaryPerson"));
        importPersonButton.setToolTipText(t("tutti.manageTemporaryReferential.action.importTemporaryPerson.tip"));
        importPersonButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ImportTemporaryPersonAction.class);
        importPersonButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporaryPerson.help");
    }

    protected void createImportSpeciesButton() {
        $objectMap.put("importSpeciesButton", importSpeciesButton = new JButton());
        
        importSpeciesButton.setName("importSpeciesButton");
        importSpeciesButton.setText(t("tutti.manageTemporaryReferential.action.importTemporarySpecies"));
        importSpeciesButton.setToolTipText(t("tutti.manageTemporaryReferential.action.importTemporarySpecies.tip"));
        importSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ImportTemporarySpeciesAction.class);
        importSpeciesButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporarySpecies.help");
    }

    protected void createImportVesselButton() {
        $objectMap.put("importVesselButton", importVesselButton = new JButton());
        
        importVesselButton.setName("importVesselButton");
        importVesselButton.setText(t("tutti.manageTemporaryReferential.action.importTemporaryVessel"));
        importVesselButton.setToolTipText(t("tutti.manageTemporaryReferential.action.importTemporaryVessel.tip"));
        importVesselButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.ImportTemporaryVesselAction.class);
        importVesselButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporaryVessel.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ManageTemporaryReferentialUIModel.class));
    }

    protected void createPersonActionComboBox() {
        $objectMap.put("personActionComboBox", personActionComboBox = new JComboBox());
        
        personActionComboBox.setName("personActionComboBox");
        personActionComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__personActionComboBox"));
        personActionComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__personActionComboBox"));
        personActionComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__personActionComboBox"));
    }

    protected void createPersonLabel() {
        $objectMap.put("personLabel", personLabel = new JLabel());
        
        personLabel.setName("personLabel");
    }

    protected void createReplaceGearButton() {
        $objectMap.put("replaceGearButton", replaceGearButton = new JButton());
        
        replaceGearButton.setName("replaceGearButton");
        replaceGearButton.setText(t("tutti.manageTemporaryReferential.action.replaceTemporaryGear"));
        replaceGearButton.setToolTipText(t("tutti.manageTemporaryReferential.action.replaceTemporaryGear.tip"));
        replaceGearButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.OpenReplaceTemporaryGearUIAction.class);
        replaceGearButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.replaceTemporaryGear.help");
    }

    protected void createReplacePersonButton() {
        $objectMap.put("replacePersonButton", replacePersonButton = new JButton());
        
        replacePersonButton.setName("replacePersonButton");
        replacePersonButton.setText(t("tutti.manageTemporaryReferential.action.replaceTemporaryPerson"));
        replacePersonButton.setToolTipText(t("tutti.manageTemporaryReferential.action.replaceTemporaryPerson.tip"));
        replacePersonButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.OpenReplaceTemporaryPersonUIAction.class);
        replacePersonButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.replaceTemporaryPerson.help");
    }

    protected void createReplaceSpeciesButton() {
        $objectMap.put("replaceSpeciesButton", replaceSpeciesButton = new JButton());
        
        replaceSpeciesButton.setName("replaceSpeciesButton");
        replaceSpeciesButton.setText(t("tutti.manageTemporaryReferential.action.replaceTemporarySpecies"));
        replaceSpeciesButton.setToolTipText(t("tutti.manageTemporaryReferential.action.replaceTemporarySpecies.tip"));
        replaceSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.OpenReplaceTemporarySpeciesUIAction.class);
        replaceSpeciesButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.replaceTemporarySpecies.help");
    }

    protected void createReplaceVesselButton() {
        $objectMap.put("replaceVesselButton", replaceVesselButton = new JButton());
        
        replaceVesselButton.setName("replaceVesselButton");
        replaceVesselButton.setText(t("tutti.manageTemporaryReferential.action.replaceTemporaryVessel"));
        replaceVesselButton.setToolTipText(t("tutti.manageTemporaryReferential.action.replaceTemporaryVessel.tip"));
        replaceVesselButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.referential.actions.OpenReplaceTemporaryVesselUIAction.class);
        replaceVesselButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.replaceTemporaryVessel.help");
    }

    protected void createSpeciesActionComboBox() {
        $objectMap.put("speciesActionComboBox", speciesActionComboBox = new JComboBox());
        
        speciesActionComboBox.setName("speciesActionComboBox");
        speciesActionComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesActionComboBox"));
        speciesActionComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__speciesActionComboBox"));
        speciesActionComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__speciesActionComboBox"));
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
    }

    protected void createVesselActionComboBox() {
        $objectMap.put("vesselActionComboBox", vesselActionComboBox = new JComboBox());
        
        vesselActionComboBox.setName("vesselActionComboBox");
        vesselActionComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__vesselActionComboBox"));
        vesselActionComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__vesselActionComboBox"));
        vesselActionComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__vesselActionComboBox"));
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToManageTemporaryReferentialTopPanel();
        // inline complete setup of $Table0
        $Table0.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(speciesActionComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselActionComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator1, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gearLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gearActionComboBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator2, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(personLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(personActionComboBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 16 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 29 property setters
        exportSpeciesExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        exportExistingSpeciesButton.setIcon(SwingUtil.createActionIcon("export"));
        importSpeciesButton.setIcon(SwingUtil.createActionIcon("import"));
        replaceSpeciesButton.setIcon(SwingUtil.createActionIcon("replace"));
        exportVesselExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        exportExistingVesselButton.setIcon(SwingUtil.createActionIcon("export"));
        importVesselButton.setIcon(SwingUtil.createActionIcon("import"));
        replaceVesselButton.setIcon(SwingUtil.createActionIcon("replace"));
        exportGearExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        exportExistingGearButton.setIcon(SwingUtil.createActionIcon("export"));
        importGearButton.setIcon(SwingUtil.createActionIcon("import"));
        replaceGearButton.setIcon(SwingUtil.createActionIcon("replace"));
        exportPersonExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        exportExistingPersonButton.setIcon(SwingUtil.createActionIcon("export"));
        importPersonButton.setIcon(SwingUtil.createActionIcon("import"));
        replacePersonButton.setIcon(SwingUtil.createActionIcon("replace"));
        speciesLabel.setIcon(SwingUtil.createImageIcon("action-species.gif"));
        speciesActionComboBox.setModel(SwingUtil.newComboModel(exportSpeciesExampleButton, exportExistingSpeciesButton, importSpeciesButton, replaceSpeciesButton));
        speciesActionComboBox.setRenderer(new ActionListCellRenderer());
        vesselLabel.setIcon(SwingUtil.createActionIcon("vessel"));
        vesselActionComboBox.setModel(SwingUtil.newComboModel(exportVesselExampleButton, exportExistingVesselButton, importVesselButton, replaceVesselButton));
        vesselActionComboBox.setRenderer(new ActionListCellRenderer());
        gearLabel.setIcon(SwingUtil.createActionIcon("gear"));
        gearActionComboBox.setModel(SwingUtil.newComboModel(exportGearExampleButton, exportExistingGearButton, importGearButton, replaceGearButton));
        gearActionComboBox.setRenderer(new ActionListCellRenderer());
        personLabel.setIcon(SwingUtil.createActionIcon("person"));
        personActionComboBox.setModel(SwingUtil.newComboModel(exportPersonExampleButton, exportExistingPersonButton, importPersonButton, replacePersonButton));
        personActionComboBox.setRenderer(new ActionListCellRenderer());
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, manageTemporaryReferentialTopPanel, "tutti.manageTemporaryReferential.help");
        registerHelpId(_broker, exportSpeciesExampleButton, "tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample.help");
        registerHelpId(_broker, exportExistingSpeciesButton, "tutti.manageTemporaryReferential.action.exportExistingTemporarySpecies.help");
        registerHelpId(_broker, importSpeciesButton, "tutti.manageTemporaryReferential.action.importTemporarySpecies.help");
        registerHelpId(_broker, replaceSpeciesButton, "tutti.manageTemporaryReferential.action.replaceTemporarySpecies.help");
        registerHelpId(_broker, exportVesselExampleButton, "tutti.manageTemporaryReferential.action.exportTemporaryVesselExample.help");
        registerHelpId(_broker, exportExistingVesselButton, "tutti.manageTemporaryReferential.action.exportExistingTemporaryVessel.help");
        registerHelpId(_broker, importVesselButton, "tutti.manageTemporaryReferential.action.importTemporaryVessel.help");
        registerHelpId(_broker, replaceVesselButton, "tutti.manageTemporaryReferential.action.replaceTemporaryVessel.help");
        registerHelpId(_broker, exportGearExampleButton, "tutti.manageTemporaryReferential.action.exportTemporaryGearExample.help");
        registerHelpId(_broker, exportExistingGearButton, "tutti.manageTemporaryReferential.action.exportExistingTemporaryGear.help");
        registerHelpId(_broker, importGearButton, "tutti.manageTemporaryReferential.action.importTemporaryGear.help");
        registerHelpId(_broker, replaceGearButton, "tutti.manageTemporaryReferential.action.replaceTemporaryGear.help");
        registerHelpId(_broker, exportPersonExampleButton, "tutti.manageTemporaryReferential.action.exportTemporaryPersonExample.help");
        registerHelpId(_broker, exportExistingPersonButton, "tutti.manageTemporaryReferential.action.exportExistingTemporaryPerson.help");
        registerHelpId(_broker, importPersonButton, "tutti.manageTemporaryReferential.action.importTemporaryPerson.help");
        registerHelpId(_broker, replacePersonButton, "tutti.manageTemporaryReferential.action.replaceTemporaryPerson.help");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("manageTemporaryReferentialTopPanel", manageTemporaryReferentialTopPanel);
        createModel();
        createBroker();
        createExportSpeciesExampleButton();
        createExportExistingSpeciesButton();
        createImportSpeciesButton();
        createReplaceSpeciesButton();
        createExportVesselExampleButton();
        createExportExistingVesselButton();
        createImportVesselButton();
        createReplaceVesselButton();
        createExportGearExampleButton();
        createExportExistingGearButton();
        createImportGearButton();
        createReplaceGearButton();
        createExportPersonExampleButton();
        createExportExistingPersonButton();
        createImportPersonButton();
        createReplacePersonButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSpeciesLabel();
        createSpeciesActionComboBox();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createVesselLabel();
        createVesselActionComboBox();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createGearLabel();
        createGearActionComboBox();
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        createPersonLabel();
        createPersonActionComboBox();
        // inline creation of manageTemporaryReferentialTopPanel
        setName("manageTemporaryReferentialTopPanel");
        setLayout(new BorderLayout());
        manageTemporaryReferentialTopPanel.putClientProperty("help", "tutti.manageTemporaryReferential.help");
        
        // registers 16 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 16 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_EXISTING_SPECIES_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporarySpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportExistingSpeciesButton.setEnabled( model.getNbTemporarySpecies() > 0 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporarySpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLACE_SPECIES_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporarySpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    replaceSpeciesButton.setEnabled( model.getNbTemporarySpecies() > 0 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporarySpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_EXISTING_VESSEL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryVessels", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportExistingVesselButton.setEnabled( model.getNbTemporaryVessels() > 0 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryVessels", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLACE_VESSEL_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryVessels", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    replaceVesselButton.setEnabled( model.getNbTemporaryVessels() > 0 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryVessels", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_EXISTING_GEAR_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryGears", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportExistingGearButton.setEnabled( model.getNbTemporaryGears() > 0 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryGears", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLACE_GEAR_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryGears", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    replaceGearButton.setEnabled( model.getNbTemporaryGears() > 0 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryGears", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EXPORT_EXISTING_PERSON_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryPersons", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    exportExistingPersonButton.setEnabled( model.getNbTemporaryPersons() > 0 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryPersons", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLACE_PERSON_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryPersons", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    replacePersonButton.setEnabled( model.getNbTemporaryPersons() > 0 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryPersons", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporarySpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesLabel.setText(t( t("tutti.manageTemporaryReferential.field.species", model.getNbTemporarySpecies()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporarySpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_LABEL_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporarySpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesLabel.setToolTipText(t( t("tutti.manageTemporaryReferential.field.species.tip", model.getNbTemporarySpecies()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporarySpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VESSEL_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryVessels", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    vesselLabel.setText(t( t("tutti.manageTemporaryReferential.field.vessel", model.getNbTemporaryVessels()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryVessels", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VESSEL_LABEL_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryVessels", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    vesselLabel.setToolTipText(t( t("tutti.manageTemporaryReferential.field.vessel.tip", model.getNbTemporaryVessels()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryVessels", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryGears", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearLabel.setText(t( t("tutti.manageTemporaryReferential.field.gear", model.getNbTemporaryGears()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryGears", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_LABEL_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryGears", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearLabel.setToolTipText(t( t("tutti.manageTemporaryReferential.field.gear.tip", model.getNbTemporaryGears()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryGears", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PERSON_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryPersons", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    personLabel.setText(t( t("tutti.manageTemporaryReferential.field.person", model.getNbTemporaryPersons()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryPersons", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PERSON_LABEL_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("nbTemporaryPersons", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    personLabel.setToolTipText(t( t("tutti.manageTemporaryReferential.field.person.tip", model.getNbTemporaryPersons()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("nbTemporaryPersons", this);
                }
            }
        });
    }

}