/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.hibernate;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.config.AdagioConfigurationOption;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaDao;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaUpdateException;
import fr.ifremer.adagio.core.dao.technical.VersionNotFoundException;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateConnectionProvider;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import fr.ifremer.adagio.core.dao.technical.liquibase.Liquibase;
import fr.ifremer.adagio.core.service.technical.SpringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.nuiton.i18n.I18n;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.Versions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.ResourceUtils;

@Repository(value="databaseSchemaDao")
@Lazy
public class DatabaseSchemaDaoImpl
extends HibernateDaoSupport
implements DatabaseSchemaDao {
    private static final Log log = LogFactory.getLog(DatabaseSchemaDaoImpl.class);
    @Autowired
    private ApplicationContext appContext;
    @Autowired
    private Liquibase liquibase;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private AdagioConfiguration config;
    private Dialect localDialect = null;

    @Autowired
    public DatabaseSchemaDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    public DatabaseSchemaDaoImpl(AdagioConfiguration config) {
        this.config = config;
        this.liquibase = new Liquibase(config);
    }

    public DatabaseSchemaDaoImpl(AdagioConfiguration config, Liquibase liquibase) {
        this.config = config;
        this.liquibase = liquibase;
    }

    @Override
    public void generateCreateSchemaFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("filename could not be null or empty.");
        }
        this.generateCreateSchemaFile(filename, false, false, true);
    }

    @Override
    public void generateCreateSchemaFile(String filename, boolean doExecute, boolean withDrop, boolean withCreate) {
        Configuration cfg = this.getHibernateConfiguration();
        SchemaExport se = new SchemaExport(cfg);
        se.setDelimiter(";");
        se.setOutputFile(filename);
        se.execute(false, doExecute, !withCreate, !withDrop);
    }

    @Override
    public void generateUpdateSchemaFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("filename could not be null or empty.");
        }
        this.generateUpdateSchemaFile(filename, false);
    }

    @Override
    public void generateUpdateSchemaFile(String filename, boolean doUpdate) {
        Configuration cfg = this.getHibernateConfiguration();
        SchemaUpdate su = new SchemaUpdate(cfg);
        su.setDelimiter(";");
        su.setOutputFile(filename);
        su.execute(false, false);
    }

    private Configuration getHibernateConfiguration() {
        Configuration cfg = new Configuration();
        try {
            this.addRessourceToHibernateConfiguration(cfg, Package.getPackage("fr.ifremer.adagio.core.dao"), "**/*.hbm.xml");
            this.addRessourceToHibernateConfiguration(cfg, "", "queries.hbm.xml");
            this.addRessourceToHibernateConfiguration(cfg, "", AdagioConfiguration.getInstance().getHibernateClientQueriesFile());
        }
        catch (IOException e) {
            log.error((Object)"exportExtractorSchemaToFile failed", (Throwable)e);
            throw new DataAccessResourceFailureException(e.getMessage(), (Throwable)e);
        }
        cfg.setProperty("hibernate.dialect", AdagioConfiguration.getInstance().getHibernateDialect());
        HibernateConnectionProvider.setDataSource(this.dataSource);
        cfg.setProperty("hibernate.connection.provider_class", HibernateConnectionProvider.class.getName());
        return cfg;
    }

    private void addRessourceToHibernateConfiguration(Configuration cfg, Package aPackage, String filePattern) throws IOException {
        String packageName = aPackage.getName().replace(".", "/");
        this.addRessourceToHibernateConfiguration(cfg, packageName, "**/*.hbm.xml");
    }

    private void addRessourceToHibernateConfiguration(Configuration cfg, String classPathFolder, String filePattern) throws IOException {
        Resource[] resources;
        Preconditions.checkNotNull((Object)this.appContext, (Object)"No ApplicationContext found. Make bean initialization has been done by Spring.");
        String fullName = null;
        fullName = classPathFolder != null && !classPathFolder.isEmpty() ? classPathFolder + "/" + filePattern : filePattern;
        for (Resource resource : resources = this.appContext.getResources("classpath*:" + fullName)) {
            int index;
            String path = resource.getURL().toString();
            if (classPathFolder != null && !classPathFolder.isEmpty()) {
                index = path.lastIndexOf(classPathFolder);
                if (index != -1) {
                    path = path.substring(index);
                }
            } else {
                index = path.lastIndexOf("/");
                if (index != -1) {
                    path = path.substring(index + 1);
                }
            }
            cfg.addResource(path);
        }
    }

    public Dialect getLocalDialect() {
        if (this.localDialect == null) {
            this.localDialect = ((SessionFactoryImplementor)this.getSessionFactory()).getDialect();
        }
        return this.localDialect;
    }

    @Override
    public void updateSchema() throws DatabaseSchemaUpdateException {
        this.updateSchema(null);
    }

    @Override
    public void updateSchema(Properties connectionProperties) throws DatabaseSchemaUpdateException {
        try {
            this.liquibase.executeUpdate(connectionProperties);
        }
        catch (LiquibaseException le) {
            if (log.isErrorEnabled()) {
                log.error((Object)le.getMessage(), (Throwable)le);
            }
            throw new DatabaseSchemaUpdateException("Could not update schema", le);
        }
    }

    @Override
    public void generateStatusReport(File outputFile) throws IOException {
        FileWriter fw = new FileWriter(outputFile);
        try {
            this.liquibase.reportStatus(fw);
        }
        catch (LiquibaseException le) {
            if (log.isErrorEnabled()) {
                log.error((Object)le.getMessage(), (Throwable)le);
            }
            throw new AdagioTechnicalException("Could not report database status", le);
        }
    }

    @Override
    public void generateDiffReport(File outputFile, String typesToControl) throws IOException {
        try {
            this.liquibase.reportDiff(outputFile, typesToControl);
        }
        catch (LiquibaseException le) {
            if (log.isErrorEnabled()) {
                log.error((Object)le.getMessage(), (Throwable)le);
            }
            throw new AdagioTechnicalException("Could not report database diff", le);
        }
    }

    @Override
    public void generateDiffChangeLog(File outputChangeLogFile, String typesToControl) throws IOException {
        try {
            this.liquibase.generateDiffChangelog(outputChangeLogFile, typesToControl);
        }
        catch (LiquibaseException le) {
            if (log.isErrorEnabled()) {
                log.error((Object)le.getMessage(), (Throwable)le);
            }
            throw new AdagioTechnicalException("Could not create database diff changelog", le);
        }
    }

    @Override
    public Version getSchemaVersion() throws VersionNotFoundException {
        String systemVersion;
        try {
            systemVersion = (String)this.queryUniqueTyped("lastSystemVersion", new Object[0]);
            if (StringUtils.isBlank((CharSequence)systemVersion)) {
                throw new VersionNotFoundException(String.format("Could not get the schema version. No version found in SYSTEM_VERSION table.", new Object[0]));
            }
        }
        catch (HibernateException he) {
            throw new VersionNotFoundException(String.format("Could not get the schema version: %s", he.getMessage()));
        }
        try {
            return Versions.valueOf((String)systemVersion);
        }
        catch (IllegalArgumentException iae) {
            throw new VersionNotFoundException(String.format("Could not get the schema version. Bad schema version found table SYSTEM_VERSION: %s", systemVersion));
        }
    }

    @Override
    public Version getSchemaVersionIfUpdate() {
        return this.liquibase.getMaxChangeLogFileVersion();
    }

    @Override
    public boolean shouldUpdateSchema() throws VersionNotFoundException {
        return this.getSchemaVersion().compareTo(this.getSchemaVersionIfUpdate()) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDbLoaded() {
        if (!this.isDbExists()) {
            log.warn((Object)"Database directory not found. Could not load database.");
            return false;
        }
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        }
        catch (CannotGetJdbcConnectionException ex) {
            log.error((Object)ex);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
            return false;
        }
        String dbValidatioNQuery = this.config.getDbValidationQuery();
        if (StringUtils.isNotBlank((CharSequence)dbValidatioNQuery)) {
            log.debug((Object)String.format("Check if the database is loaded, using validation query: %s", dbValidatioNQuery));
            Statement stmt = null;
            try {
                stmt = connection.createStatement();
                stmt.execute(dbValidatioNQuery);
            }
            catch (SQLException ex) {
                log.error((Object)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                DaoUtils.closeSilently(stmt);
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
            }
        } else {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
        return true;
    }

    @Override
    public boolean isDbExists() {
        String jdbcUrl = this.config.getJdbcURL();
        if (!DaoUtils.isFileDatabase(jdbcUrl)) {
            return true;
        }
        File f = new File(this.config.getDbDirectory(), this.config.getDbName() + ".data");
        return f.exists();
    }

    @Override
    public void generateNewDb(File dbDirectory, boolean replaceIfExists, File scriptFile, Properties connectionProperties) {
        Properties targetConnectionProperties;
        Preconditions.checkNotNull((Object)dbDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)I18n.t((String)"adagio.persistence.newEmptyDatabase.directory", (Object[])new Object[]{dbDirectory}));
        }
        if (dbDirectory.exists() && !dbDirectory.isDirectory()) {
            throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.newEmptyDatabase.notValidDirectory.error", (Object[])new Object[]{dbDirectory}));
        }
        try {
            FileUtils.forceMkdir((File)dbDirectory);
        }
        catch (IOException e) {
            throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.newEmptyDatabase.mkdir.error", (Object[])new Object[]{dbDirectory}), e);
        }
        if (ArrayUtils.isNotEmpty((Object[])dbDirectory.listFiles())) {
            if (replaceIfExists) {
                log.info((Object)I18n.t((String)"adagio.persistence.newEmptyDatabase.deleteDirectory", (Object[])new Object[]{dbDirectory}));
                try {
                    FileUtils.deleteDirectory((File)dbDirectory);
                }
                catch (IOException e) {
                    throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.newEmptyDatabase.deleteDirectory.error", (Object[])new Object[]{dbDirectory}), e);
                }
            } else {
                throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.newEmptyDatabase.notEmptyDirectory.error", (Object[])new Object[]{dbDirectory}));
            }
        }
        Properties properties = targetConnectionProperties = connectionProperties != null ? connectionProperties : this.config.getConnectionProperties();
        if (!this.checkConnection(this.config, targetConnectionProperties)) {
            return;
        }
        try {
            this.createEmptyDb(this.config, targetConnectionProperties, scriptFile);
        }
        catch (SQLException e) {
            throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.newEmptyDatabase.create.error", (Object[])new Object[0]), e);
        }
        catch (IOException e) {
            throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.newEmptyDatabase.create.error", (Object[])new Object[0]), e);
        }
        try {
            DaoUtils.shutdownDatabase(targetConnectionProperties);
        }
        catch (SQLException e) {
            throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.newEmptyDatabase.shutdown.error", (Object[])new Object[0]), e);
        }
    }

    @Override
    public void generateNewDb(File dbDirectory, boolean replaceIfExists) {
        this.generateNewDb(dbDirectory, replaceIfExists, null, null);
    }

    protected boolean checkConnection(AdagioConfiguration config, Properties targetConnectionProperties) {
        boolean isValidConnection;
        if (log.isInfoEnabled()) {
            log.info((Object)"Connecting to target database...");
            log.info((Object)String.format(" Database directory: %s", config.getDbDirectory()));
            log.info((Object)String.format(" JDBC Driver: %s", config.getJdbcDriver()));
            log.info((Object)String.format(" JDBC URL: %s", config.getJdbcURL()));
            log.info((Object)String.format(" JDBC Username: %s", config.getJdbcUsername()));
        }
        if (!(isValidConnection = DaoUtils.isValidConnectionProperties(targetConnectionProperties))) {
            log.error((Object)"Connection error: could not connect to target database.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEmptyDb(AdagioConfiguration config, Properties targetConnectionProperties, File scriptFile) throws SQLException, IOException {
        Resource scriptResource;
        String scriptPath = scriptFile == null ? config.getDbCreateScriptPath() : scriptFile.getAbsolutePath();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)scriptPath), (Object)String.format("No path for the DB script has been set in the configuration. This is need to create a new database. Please set the option [%s] in configuration file.", new Object[]{AdagioConfigurationOption.DB_CREATE_SCRIPT_PATH}));
        scriptPath = scriptPath.replaceAll("\\\\", "/");
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use create script: " + scriptPath));
        }
        String scriptPathWithPrefix = scriptPath;
        if (!ResourceUtils.isUrl((String)scriptPath)) {
            scriptPathWithPrefix = "file:" + scriptPath;
        }
        if (!(scriptResource = SpringUtils.getResource(scriptPathWithPrefix)).exists()) {
            throw new AdagioTechnicalException(String.format("Could not find DB script file, at %s", scriptPath));
        }
        Connection connection = DaoUtils.createConnection(targetConnectionProperties);
        try {
            List<String> importScriptSql = this.getImportScriptSql(scriptResource);
            for (String sql : importScriptSql) {
                PreparedStatement statement = null;
                try {
                    statement = connection.prepareStatement(sql);
                    statement.execute();
                }
                catch (SQLException sqle) {
                    log.warn((Object)("SQL command failed : " + sql), (Throwable)sqle);
                    throw sqle;
                }
                finally {
                    DaoUtils.closeSilently(statement);
                }
            }
            connection.commit();
        }
        finally {
            DaoUtils.closeSilently(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getImportScriptSql(Resource scriptResource) throws IOException {
        ArrayList result = Lists.newArrayList();
        Predicate<String> predicate = new Predicate<String>(){
            Set<String> forbiddenStarts = Sets.newHashSet((Object[])new String[]{"SET ", "CREATE USER ", "CREATE SCHEMA ", "GRANT DBA TO "});

            public boolean apply(String input) {
                boolean accept = true;
                for (String forbiddenStart : this.forbiddenStarts) {
                    if (!input.startsWith(forbiddenStart) || input.startsWith("SET WRITE_DELAY")) continue;
                    accept = false;
                    break;
                }
                return accept;
            }
        };
        InputStream is = scriptResource.getInputStream();
        try {
            LineIterator lines = IOUtils.lineIterator((InputStream)is, (Charset)Charsets.UTF_8);
            while (lines.hasNext()) {
                String line = ((String)lines.next()).trim().toUpperCase();
                if (!predicate.apply((Object)line)) continue;
                if (line.contains("\\U000A")) {
                    line = line.replaceAll("\\\\U000A", "\n");
                }
                if (line.startsWith("CREATE SEQUENCE")) {
                    line = line.replaceAll("START WITH [0-9]+", "START WITH 0");
                }
                result.add(line);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return result;
    }
}

