/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.action.UpdateApplicationAction;
import fr.ifremer.tutti.ui.swing.action.UpdateDbAction;
import fr.ifremer.tutti.ui.swing.action.UpdateReportAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.updater.UpdateModule;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jaxx.runtime.swing.AboutPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdater;

public class ShowAboutAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ShowAboutAction.class);
    protected AboutPanel about;
    protected boolean canUpdateApplication;
    protected boolean canUpdateData;

    public ShowAboutAction(MainUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            TuttiUIContext context = this.getContext();
            this.canUpdateApplication = context.checkUpdateApplicationReachable(false);
            this.canUpdateData = context.checkUpdateDataReachable(false);
        }
        return doAction;
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.about.showInDialog((Frame)this.getUI(), true);
        this.getContext().addInSwingSession((Component)this.about, true);
    }

    @Override
    public void doAction() throws Exception {
        this.about = null;
        String iconPath = "/icons/allegro_about.png";
        String name = "tutti";
        String licensePath = "META-INF/" + name + "-LICENSE.txt";
        String thirdPartyPath = "META-INF/" + name + "-THIRD-PARTY.txt";
        TuttiConfiguration config = this.getConfig();
        this.about = new AboutPanel();
        this.about.setTitle(I18n.t((String)"tutti.about.title", (Object[])new Object[0]));
        this.about.setAboutText(I18n.t((String)"tutti.about.message", (Object[])new Object[0]));
        int currentYear = Calendar.getInstance().get(1);
        int inceptionYear = config.getInceptionYear();
        String years = currentYear != inceptionYear ? inceptionYear + "-" + currentYear : inceptionYear + "";
        this.about.setBottomText(I18n.t((String)"tutti.about.bottomText", (Object[])new Object[]{config.getOrganizationName(), years, config.getVersion()}));
        this.about.setIconPath(iconPath);
        this.about.setLicenseFile(licensePath);
        this.about.setThirdpartyFile(thirdPartyPath);
        this.about.buildTopPanel();
        this.addTranslatePane(config);
        if (this.canUpdateApplication || this.canUpdateData) {
            this.addUpdateTab(config);
        }
        this.about.init();
    }

    protected void addTranslatePane(TuttiConfiguration config) throws MalformedURLException {
        JScrollPane translatePane = new JScrollPane();
        JEditorPane translateArea = new JEditorPane();
        translateArea.setContentType("text/html");
        translateArea.setEditable(false);
        if (translateArea.getFont() != null) {
            translateArea.setFont(translateArea.getFont().deriveFont(11.0f));
        }
        translateArea.setBorder(null);
        File csvFile = new File(config.getI18nDirectory(), "tutti-i18n.csv");
        String translateText = I18n.t((String)"tutti.about.translate.content", (Object[])new Object[]{csvFile.toURI().toURL()});
        translateArea.setText(translateText);
        translatePane.getViewport().add(translateArea);
        translateArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    URL url = e.getURL();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("edit url: " + url));
                    }
                    TuttiUIUtil.openLink((URL)url);
                }
            }
        });
        this.about.getTabs().add(I18n.t((String)"tutti.about.translate.title", (Object[])new Object[0]), translatePane);
    }

    protected void addUpdate(String url, UpdateModule type, Map<String, ApplicationInfo> source, Map<UpdateModule, ApplicationInfo> target) {
        ApplicationInfo info = source.get(type.name().toLowerCase());
        if (info == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Can not find information about module " + type + " by update provider " + url));
            }
        } else {
            target.put(type, info);
        }
    }

    protected void addUpdateTab(TuttiConfiguration config) {
        Map<UpdateModule, ApplicationInfo> versions = this.getModules(config);
        JScrollPane updatePane = new JScrollPane();
        JEditorPane updateArea = new JEditorPane();
        updateArea.setContentType("text/html");
        updateArea.setEditable(false);
        if (updateArea.getFont() != null) {
            updateArea.setFont(updateArea.getFont().deriveFont(11.0f));
        }
        updateArea.setBorder(null);
        ArrayList params = Lists.newArrayList();
        for (Map.Entry<UpdateModule, ApplicationInfo> entry : versions.entrySet()) {
            String message;
            UpdateModule appName = entry.getKey();
            ApplicationInfo info = entry.getValue();
            String oldVersion = info.oldVersion;
            String newVersion = info.newVersion;
            String appLabel = this.getModuleLabel(appName);
            if (newVersion == null) {
                message = I18n.t((String)"tutti.about.update.app.noup.detail", (Object[])new Object[]{appLabel, oldVersion});
                params.add(message);
            } else {
                message = I18n.t((String)"tutti.about.update.app.up.detail", (Object[])new Object[]{appLabel, oldVersion, newVersion, appName});
                params.add(message);
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)message);
        }
        String urlApplication = config.getUpdateApplicationUrl();
        String urlData = config.getUpdateDataUrl();
        String updateText = I18n.t((String)"tutti.about.update.content", (Object[])new Object[]{urlApplication, urlData, Joiner.on((String)"\n").join((Iterable)params)});
        updateArea.setText(updateText);
        updatePane.getViewport().add(updateArea);
        updateArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    URL url = e.getURL();
                    if (url != null) {
                        TuttiUIUtil.openLink((URL)url);
                    } else {
                        String appType = e.getDescription();
                        ShowAboutAction.this.onUpdateLinkClicked(appType);
                    }
                }
            }
        });
        this.about.getTabs().add(I18n.t((String)"tutti.about.update.title", (Object[])new Object[0]), updatePane);
    }

    protected Map<UpdateModule, ApplicationInfo> getModules(TuttiConfiguration config) {
        File current = config.getBasedir();
        String urlApplication = config.getUpdateApplicationUrl();
        String urlData = config.getUpdateDataUrl();
        ApplicationUpdater up = new ApplicationUpdater();
        LinkedHashMap versions = Maps.newLinkedHashMap();
        if (this.canUpdateApplication) {
            Map applicationVersions = up.getVersions(urlApplication, current);
            this.addUpdate(urlApplication, UpdateModule.jre, applicationVersions, versions);
            this.addUpdate(urlApplication, UpdateModule.launcher, applicationVersions, versions);
            this.addUpdate(urlApplication, UpdateModule.tutti, applicationVersions, versions);
            this.addUpdate(urlApplication, UpdateModule.i18n, applicationVersions, versions);
            this.addUpdate(urlApplication, UpdateModule.help, applicationVersions, versions);
            this.addUpdate(urlApplication, UpdateModule.ichtyometer, applicationVersions, versions);
        }
        if (this.canUpdateData) {
            Map reportVersions = up.getVersions(urlData, current);
            this.addUpdate(urlData, UpdateModule.report, reportVersions, versions);
            Map dbVersions = up.getVersions(urlData, config.getDataDirectory());
            this.addUpdate(urlData, UpdateModule.db, dbVersions, versions);
        }
        return versions;
    }

    protected void onUpdateLinkClicked(String appType) {
        AbstractTuttiAction action;
        if (log.isInfoEnabled()) {
            log.info((Object)("Open update url for module: " + appType));
        }
        UpdateModule updateModuleToUpdate = UpdateModule.valueOf((String)appType);
        switch (updateModuleToUpdate) {
            case db: {
                UpdateDbAction logicAction;
                action = logicAction = (UpdateDbAction)this.getContext().getActionFactory().createLogicAction(this.getHandler(), UpdateDbAction.class);
                if (this.getContext().isDbExist()) break;
                action.setActionDescription(I18n.t((String)"tutti.dbManager.action.installDb.tip", (Object[])new Object[0]));
                break;
            }
            case report: {
                UpdateReportAction logicAction = (UpdateReportAction)this.getContext().getActionFactory().createLogicAction(this.getHandler(), UpdateReportAction.class);
                action = logicAction;
                break;
            }
            default: {
                UpdateApplicationAction logicAction = (UpdateApplicationAction)this.getContext().getActionFactory().createLogicAction(this.getHandler(), UpdateApplicationAction.class);
                logicAction.setModulesToUpdate(updateModuleToUpdate);
                String label = this.getModuleLabel(updateModuleToUpdate);
                logicAction.setActionDescription(I18n.t((String)"tutti.main.action.updateSpecificApplication.tip", (Object[])new Object[]{label}));
                action = logicAction;
            }
        }
        this.getActionEngine().runAction((AbstractButton)this.about.getClose());
        this.getActionEngine().runAction((AbstractApplicationAction)action);
    }

    protected String getModuleLabel(UpdateModule moduleName) {
        String i18nKey = "tutti.update." + moduleName.name().toLowerCase();
        String appLabel = I18n.t((String)i18nKey, (Object[])new Object[0]);
        return appLabel;
    }
}

