/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

public class BlockingLayerUI
extends AbstractLayerUI<JComponent> {
    public static final String CAN_CLICK_PROPERTY = "canClick";
    public static final String ACCEPT_ICON_PROPERTY = "acceptIcon";
    public static final String BLOCK_ICON_PROPERTY = "blockIcon";
    public static final String BLOCK_PROPERTY = "block";
    protected Action acceptAction;
    protected BufferedImage blockIcon;
    protected BufferedImage acceptIcon;
    protected Color blockingColor;
    protected boolean canClick;
    protected boolean useIcon = true;
    protected boolean block;
    protected List<String> acceptedComponentNames;

    public void setAcceptedComponentNames(String ... acceptedComponentNames) {
        this.acceptedComponentNames = Arrays.asList(acceptedComponentNames);
        this.setDirty(true);
    }

    public void setAcceptAction(Action acceptAction) {
        this.acceptAction = acceptAction;
    }

    public void setAcceptIcon(ImageIcon acceptIcon) {
        this.acceptIcon = this.prepareIcon(acceptIcon);
        this.firePropertyChange(ACCEPT_ICON_PROPERTY, null, acceptIcon);
        this.setDirty(true);
    }

    public void setBlockIcon(ImageIcon blockIcon) {
        this.blockIcon = this.prepareIcon(blockIcon);
        this.firePropertyChange(BLOCK_ICON_PROPERTY, null, blockIcon);
        this.setDirty(true);
    }

    public void setCanClick(boolean canClick) {
        boolean oldvalue = this.canClick;
        this.canClick = canClick;
        this.firePropertyChange(CAN_CLICK_PROPERTY, oldvalue, canClick);
        if (oldvalue != canClick) {
            this.setDirty(true);
        }
    }

    public void setBlock(boolean block) {
        boolean oldvalue = this.block;
        this.block = block;
        this.firePropertyChange(BLOCK_PROPERTY, oldvalue, block);
        if (oldvalue != block) {
            this.setDirty(true);
        }
    }

    public void setDirty(boolean isDirty) {
        super.setDirty(isDirty);
    }

    public void setBlockIcon(BufferedImage blockIcon) {
        this.blockIcon = blockIcon;
    }

    public void setBlockingColor(Color blockingColor) {
        this.blockingColor = blockingColor;
    }

    public BufferedImage getBlockIcon() {
        return this.blockIcon;
    }

    protected BufferedImage getAcceptIcon() {
        return this.acceptIcon;
    }

    public boolean isCanClick() {
        return this.canClick;
    }

    public void setUseIcon(boolean useIcon) {
        boolean oldvalue = this.useIcon;
        this.useIcon = useIcon;
        if (oldvalue != useIcon) {
            this.setDirty(true);
        }
    }

    public BlockingLayerUI clone() {
        BlockingLayerUI clone = new BlockingLayerUI();
        clone.acceptAction = this.acceptAction;
        clone.acceptIcon = this.acceptIcon;
        clone.blockIcon = this.blockIcon;
        clone.useIcon = this.useIcon;
        clone.block = this.block;
        clone.blockingColor = this.blockingColor;
        clone.setCanClick(false);
        return clone;
    }

    protected void processKeyEvent(KeyEvent e, JXLayer<? extends JComponent> l) {
        if (this.useIcon) {
            e.consume();
            return;
        }
        if (this.block) {
            Object source = e.getSource();
            if (!(source instanceof JComponent)) {
                e.consume();
                return;
            }
            JComponent comp = (JComponent)source;
            String compName = comp.getName();
            if (this.acceptedComponentNames == null || !this.acceptedComponentNames.contains(compName)) {
                e.consume();
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e, JXLayer<? extends JComponent> l) {
        if (this.useIcon) {
            this.updateCanClickState(l, e);
            e.consume();
        }
        if (this.block) {
            Object source = e.getSource();
            if (!(source instanceof JComponent)) {
                e.consume();
                return;
            }
            JComponent comp = (JComponent)source;
            String compName = comp.getName();
            if (this.acceptedComponentNames == null || !this.acceptedComponentNames.contains(compName)) {
                e.consume();
            }
        }
    }

    protected void processMouseEvent(MouseEvent e, JXLayer<? extends JComponent> l) {
        if (this.useIcon) {
            switch (e.getID()) {
                case 504: {
                    this.updateCanClickState(l, e);
                    break;
                }
                case 505: {
                    this.setCanClick(false);
                    break;
                }
                case 500: {
                    if (!this.canClick) break;
                    this.acceptEvent(e, l);
                }
            }
        }
        if (this.useIcon) {
            e.consume();
            return;
        }
        if (this.block) {
            Object source = e.getSource();
            if (!(source instanceof JComponent)) {
                e.consume();
                return;
            }
            JComponent comp = (JComponent)source;
            String compName = comp.getName();
            if (this.acceptedComponentNames == null || !this.acceptedComponentNames.contains(compName)) {
                e.consume();
                return;
            }
            switch (e.getID()) {
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 500: {
                    this.acceptEvent(e, l);
                }
            }
        }
    }

    protected void processMouseWheelEvent(MouseWheelEvent e, JXLayer<? extends JComponent> l) {
        if (this.useIcon) {
            e.consume();
            return;
        }
        if (this.block) {
            Object source = e.getSource();
            if (!(source instanceof JComponent)) {
                e.consume();
                return;
            }
            JComponent comp = (JComponent)source;
            String compName = comp.getName();
            if (this.acceptedComponentNames == null || !this.acceptedComponentNames.contains(compName)) {
                e.consume();
                return;
            }
            this.acceptEvent(e, l);
        }
    }

    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        super.paintLayer(g2, l);
        if (this.block && this.blockingColor != null) {
            g2.setColor(this.blockingColor);
            g2.setComposite(AlphaComposite.getInstance(3, 0.1f));
            g2.fillRect(0, 0, l.getWidth(), l.getHeight());
        }
        if (this.useIcon && this.getCurrentIcon() != null) {
            g2.drawImage((Image)this.getCurrentIcon(), l.getWidth() - this.getCurrentIcon().getWidth() - 1, 0, null);
        }
    }

    protected void acceptEvent(MouseEvent e, JXLayer<? extends JComponent> l) {
        if (this.acceptAction != null) {
            this.acceptAction.putValue("layer", l);
            Component source = l.getView();
            this.acceptAction.actionPerformed(new ActionEvent(source, 0, "accept"));
        }
    }

    protected BufferedImage getCurrentIcon() {
        return this.canClick ? this.acceptIcon : this.blockIcon;
    }

    protected BufferedImage prepareIcon(ImageIcon image) {
        BufferedImage icon = new BufferedImage(image.getIconWidth(), image.getIconHeight(), 2);
        Graphics2D g2 = (Graphics2D)icon.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.drawImage(image.getImage(), 0, 0, null);
        g2.dispose();
        return icon;
    }

    protected void updateCanClickState(JXLayer<? extends JComponent> l, MouseEvent e) {
        Point layerLocation = ((JComponent)l.getView()).getLocation();
        Point mousePoint = e.getPoint();
        BufferedImage currentIcon = this.getCurrentIcon();
        if (currentIcon == null) {
            this.setCanClick(false);
            return;
        }
        int minX = (int)layerLocation.getX() + l.getWidth() - currentIcon.getWidth();
        int maxX = (int)layerLocation.getX() + l.getWidth();
        boolean minY = false;
        int maxY = currentIcon.getHeight();
        boolean accept = (double)minX <= mousePoint.getX() && mousePoint.getX() <= (double)maxX;
        this.setCanClick(accept &= (double)minY <= mousePoint.getLocation().getY() && mousePoint.getLocation().getY() <= (double)maxY);
    }
}

