/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentId;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonId;
import fr.ifremer.adagio.core.dao.administration.user.PersonImpl;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationImpl;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Matrix;
import fr.ifremer.adagio.core.dao.referential.pmfm.MatrixId;
import fr.ifremer.adagio.core.dao.referential.pmfm.MatrixImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.CaracteristicPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.SpeciesPersistenceService;
import fr.ifremer.tutti.persistence.service.util.BatchPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SamplePersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.springframework.stereotype.Service;

@Service(value="individualObservationBatchPersistenceService")
public class IndividualObservationBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements IndividualObservationBatchPersistenceService {
    private static final Log log = LogFactory.getLog(IndividualObservationBatchPersistenceServiceImpl.class);
    @Resource(name="caracteristicPersistenceService")
    private CaracteristicPersistenceService caracteristicService;
    @Resource(name="speciesPersistenceService")
    private SpeciesPersistenceService speciesService;
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="samplePersistenceHelper")
    protected SamplePersistenceHelper samplePersistenceHelper;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;
    @Resource(name="synchronizationStatusHelper")
    protected SynchronizationStatusHelper synchronizationStatusHelper;

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatch(String fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer operationId = Integer.valueOf(fishingOperationId);
        Batch catchBatch = this.getBatch(operationId);
        Iterator<Object[]> list = this.queryList("allFishingOperationSamplesWithBatch", "fishingOperationId", IntegerType.INSTANCE, operationId, "batchId", IntegerType.INSTANCE, catchBatch.getId());
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            IndividualObservationBatch batch = IndividualObservationBatchs.newIndividualObservationBatch();
            int colIndex = 0;
            batch.setId((Integer)source[colIndex++]);
            Integer taxonId = (Integer)source[colIndex++];
            Species species = this.speciesService.getSpeciesByReferenceTaxonId(taxonId);
            batch.setSpecies(species);
            batch.setComment((String)source[colIndex]);
            batch.setSynchronizationStatus((String)source[colIndex]);
            batch.setCaracteristics(new CaracteristicMap());
            this.fillSampleMeasurements(batch);
            result.add(batch);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public IndividualObservationBatch createIndividualObservationBatch(IndividualObservationBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkState((boolean)TuttiEntities.isNew(bean));
        Preconditions.checkNotNull((Object)bean.getSpecies());
        FishingOperation fishingOperation = bean.getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkState((!TuttiEntities.isNew(fishingOperation) ? 1 : 0) != 0);
        Batch catchBatch = this.getBatch(fishingOperation.getIdAsInt());
        Sample sample = Sample.Factory.newInstance();
        this.beanToEntity(bean, sample, catchBatch);
        this.samplePersistenceHelper.create(sample);
        bean.setId(String.valueOf(sample.getId()));
        this.synchronizationStatusHelper.setDirty(bean);
        return bean;
    }

    @Override
    public IndividualObservationBatch saveIndividualObservationBatch(IndividualObservationBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkState((!TuttiEntities.isNew(bean) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getSpecies());
        FishingOperation fishingOperation = bean.getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkState((!TuttiEntities.isNew(fishingOperation) ? 1 : 0) != 0);
        Batch catchBatch = this.getBatch(fishingOperation.getIdAsInt());
        Sample sample = this.samplePersistenceHelper.load(bean.getIdAsInt());
        this.beanToEntity(bean, sample, catchBatch);
        this.samplePersistenceHelper.update(sample);
        this.synchronizationStatusHelper.setDirty(bean);
        return bean;
    }

    @Override
    public void deleteIndividualObservationBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        Integer batchId = Integer.valueOf(id);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will delete individual observation batch: " + batchId));
        }
        this.samplePersistenceHelper.deleteSample(batchId);
    }

    @Override
    public void deleteIndividualObservationBatchForFishingOperation(String fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        List<IndividualObservationBatch> batches = this.getAllIndividualObservationBatch(fishingOperationId);
        if (CollectionUtils.isNotEmpty(batches)) {
            for (IndividualObservationBatch batch : batches) {
                this.deleteIndividualObservationBatch(batch.getId());
            }
        }
    }

    protected void beanToEntity(IndividualObservationBatch source, Sample target, Batch vracSpeciesBatch) {
        Caracteristic caracteristic;
        if (TuttiEntities.isNew(source)) {
            fr.ifremer.adagio.core.dao.data.operation.FishingOperation fishingOperation = (fr.ifremer.adagio.core.dao.data.operation.FishingOperation)this.load(FishingOperationImpl.class, source.getFishingOperation().getIdAsInt());
            fishingOperation.getSamples().add(target);
            target.setFishingOperation(fishingOperation);
            String label = fishingOperation.getId() + "_" + source.getSpecies().getReferenceTaxonId();
            target.setLabel(label);
            Matrix matrix = (Matrix)this.load(MatrixImpl.class, MatrixId.PRODUCE_BATCH.getValue());
            target.setMatrix(matrix);
            target.setIndividualCount(Short.valueOf((short)1));
            target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
            if (target.getSampleDate() == null) {
                target.setSampleDate(fishingOperation.getFishingStartDateTime());
            }
            target.setCreationDate(fishingOperation.getFishingStartDateTime());
            target.setRecorderDepartment((Department)this.load(DepartmentImpl.class, DepartmentId.UNKNOWN_RECORDER_DEPARTMENT.getValue()));
            target.setRecorderPerson((Person)this.load(PersonImpl.class, PersonId.UNKNOWN_RECORDER_PERSON.getValue()));
            Program program = fishingOperation.getFishingTrip().getProgram();
            target.setProgram(program);
        }
        target.setId(source.getIdAsInt());
        target.setBatch(vracSpeciesBatch);
        target.setComments(source.getComment());
        Species species = source.getSpecies();
        Integer referenceTaxonId = species.getReferenceTaxonId();
        target.setReferenceTaxon((ReferenceTaxon)this.load(ReferenceTaxonImpl.class, referenceTaxonId));
        CaracteristicMap caracteristics = CaracteristicMap.copy(source.getCaracteristics());
        if (source.getWeight() != null) {
            caracteristic = this.caracteristicService.getWeightMeasuredCaracteristic();
            caracteristics.put(caracteristic, source.getWeight());
        }
        if (source.getLengthStepCaracteristic() != null) {
            caracteristic = this.caracteristicService.getPmfmIdCaracteristic();
            caracteristics.put(caracteristic, source.getLengthStepCaracteristic().getId());
            caracteristics.put(source.getLengthStepCaracteristic(), source.getSize());
        }
        this.samplePersistenceHelper.setSampleMeasurements(target, caracteristics);
    }

    protected Batch getBatch(Integer operationId) {
        Preconditions.checkNotNull((Object)operationId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(operationId.toString(), false);
        return catchBatch;
    }

    protected void fillSampleMeasurements(IndividualObservationBatch batch) {
        String lengthClassId;
        CaracteristicMap result = batch.getCaracteristics();
        this.samplePersistenceHelper.fillSampleMeasurements(result, batch.getIdAsInt());
        Float weight = (Float)result.remove(this.caracteristicService.getWeightMeasuredCaracteristic());
        if (weight != null) {
            batch.setWeight(weight);
        }
        if ((lengthClassId = (String)result.remove(this.caracteristicService.getPmfmIdCaracteristic())) != null) {
            Caracteristic lengthStepCaracteristic = this.caracteristicService.getCaracteristic(Integer.valueOf(lengthClassId));
            batch.setLengthStepCaracteristic(lengthStepCaracteristic);
            Serializable length = (Serializable)result.remove(lengthStepCaracteristic);
            batch.setSize((Float)length);
        }
    }
}

