/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.sdk.Context;
import liquibase.sdk.vagrant.VagrantControl;
import liquibase.util.StringUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private boolean debug = false;
    private CommandLine globalArguments;
    private String command;
    private List<String> commandArgs = new ArrayList<String>();
    private Options globalOptions = new Options();

    public static void main(String[] args) {
        Main main = new Main();
        main.header("Liquibase SDK");
        try {
            main.init(args);
            if (main.command == null) {
                throw new UserError("No command passed");
            }
            if (main.command.equals("help")) {
                main.printHelp();
                return;
            }
            if (!main.command.equals("vagrant")) {
                throw new UserError("Unknown command: " + main.command);
            }
            VagrantControl vagrantControl = new VagrantControl(main);
            GnuParser commandParser = new GnuParser();
            try {
                CommandLine commandArguments = commandParser.parse(vagrantControl.getOptions(), main.commandArgs.toArray(new String[main.commandArgs.size()]));
                vagrantControl.execute(commandArguments);
            }
            catch (ParseException e) {
                throw new UserError("Error parsing command arguments: " + e.getMessage());
            }
            main.divider();
            main.out("Command executed successfully");
        }
        catch (UserError userError) {
            main.out("");
            main.header("ERROR EXECUTING COMMAND");
            main.out(userError.getMessage());
            main.out("");
            main.out("");
            return;
        }
        catch (Throwable exception) {
            System.out.println("Unexpected error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void init(String[] args) throws UserError {
        Context.reset();
        GnuParser globalParser = new GnuParser();
        ArrayList<String> globalArgs = new ArrayList<String>();
        boolean inGlobal = true;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (inGlobal) {
                if (arg.startsWith("--")) {
                    globalArgs.add(arg);
                } else {
                    this.command = arg;
                    inGlobal = false;
                }
            } else {
                this.commandArgs.add(arg);
            }
            ++n2;
        }
        try {
            this.globalArguments = globalParser.parse(this.globalOptions, globalArgs.toArray(new String[globalArgs.size()]));
        }
        catch (ParseException e) {
            throw new UserError("Error parsing global command line argument: " + e.getMessage());
        }
    }

    public File getSdkRoot() {
        return new File(".").getAbsoluteFile();
    }

    public String getCommand() {
        return this.command;
    }

    public void header(String ... header) {
        this.divider();
        String[] stringArray = header;
        int n = header.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            System.out.println(line);
            ++n2;
        }
        this.divider();
    }

    public void divider() {
        System.out.println("---------------------------------------------------");
    }

    public void out(String message) {
        System.out.println(message);
    }

    public void debug(String message) {
        if (this.debug) {
            System.out.println("DEBUG: " + message);
        }
    }

    public void fatal(String error) throws UserError {
        throw new UserError(error);
    }

    public void fatal(Throwable exception) {
        this.fatal(exception.getMessage(), exception);
    }

    public void fatal(String error, Throwable exception) throws UserError {
        throw new UserError(error, exception);
    }

    public String getPath() {
        Map<String, String> environment = new ProcessBuilder(new String[0]).environment();
        String path = environment.get("Path");
        if (path == null) {
            path = environment.get("PATH");
        }
        if (path == null) {
            path = environment.get("path");
        }
        if (path == null) {
            throw new UnexpectedLiquibaseException("Cannot find path variable in environment. Possible variables are " + StringUtils.join(environment.keySet(), ","));
        }
        return path;
    }

    public String getPath(String ... possibleFileNames) {
        HashSet fileNames = new HashSet();
        String[] stringArray = this.getPath().split("[:;]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            String[] stringArray2 = possibleFileNames;
            int n3 = possibleFileNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileName = stringArray2[n4];
                File file = new File(dir, fileName);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("liquibase-sdk [global options] [command] [command options]", this.globalOptions);
    }

    private static class UserError
    extends RuntimeException {
        public UserError(String message) {
            super(message);
        }

        private UserError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

