/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.extension;

import java.io.OutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemGeneration;
import org.eclipse.birt.report.engine.extension.IReportItemGenerationInfo;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.Size;
import org.eclipse.birt.report.engine.extension.internal.RowSet;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class ReportItemGenerationBase
implements IReportItemGeneration {
    protected ExtendedItemHandle modelHandle;
    protected ClassLoader appClassLoader;
    protected IReportContext context;
    protected IDataQueryDefinition[] queries;
    protected IContent content;
    protected IReportItemGenerationInfo info;

    @Override
    public void init(IReportItemGenerationInfo info) {
        if (info == null) {
            throw new NullPointerException();
        }
        this.info = info;
        this.setModelObject(info.getModelObject());
        this.setApplicationClassLoader(info.getApplicationClassLoader());
        this.setScriptContext(info.getReportContext());
        this.setReportQueries(info.getReportQueries());
        this.setExtendedItemContent(info.getExtendedItemContent());
    }

    @Override
    public Size getSize() {
        return null;
    }

    @Override
    public void finish() {
    }

    @Override
    public void setModelObject(ExtendedItemHandle modelHandle) {
        this.modelHandle = modelHandle;
    }

    @Override
    public void setApplicationClassLoader(ClassLoader loader) {
        this.appClassLoader = loader;
    }

    @Override
    public void setScriptContext(IReportContext context) {
        this.context = context;
    }

    @Override
    public void setReportQueries(IDataQueryDefinition[] queries) {
        this.queries = queries;
    }

    @Override
    public void onRowSets(IRowSet[] rowSets) throws BirtException {
    }

    @Override
    public void onRowSets(IBaseResultSet[] results) throws BirtException {
        if (results == null) {
            this.onRowSets((IRowSet[])null);
            return;
        }
        int length = results.length;
        int i = 0;
        while (i < length) {
            if (results[i].getType() == 1) {
                return;
            }
            ++i;
        }
        IRowSet[] rowSets = new IRowSet[length];
        int index = 0;
        while (index < length) {
            IQueryResultSet resultSet = (IQueryResultSet)results[index];
            rowSets[index] = new RowSet(resultSet);
            ++index;
        }
        this.onRowSets(rowSets);
    }

    @Override
    public void serialize(OutputStream ostream) throws BirtException {
    }

    @Override
    public boolean needSerialization() {
        return false;
    }

    @Override
    public void setExtendedItemContent(IContent content) {
        this.content = content;
    }

    @Override
    public IReportItemGenerationInfo getGenerationConfig() {
        return this.info;
    }
}

