/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.sumatra;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.sumatra.CatchRow;
import fr.ifremer.tutti.service.sumatra.CatchRowModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.i18n.I18n;

public class CatchesSumatraExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(CatchesSumatraExportService.class);
    protected PersistenceService persistenceService;
    protected WeightComputingService weightComputingService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
    }

    public void exportCruiseForSumatra(File file, String cruiseId) {
        Preconditions.checkNotNull((Object)cruiseId, (Object)"Cannot export a null cruise");
        Preconditions.checkNotNull((Object)file, (Object)"Cannot export to a null file");
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cruise " + cruiseId + " to file: " + file));
        }
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise, (Object)("Cruise [" + cruiseId + "] not found"));
        List<String> operations = this.persistenceService.getAllFishingOperationIds(cruiseId);
        this.prepareOperationsAndExport(file, operations);
    }

    public void exportFishingOperationForSumatra(File file, String cruiseId, String fishingOperationId) {
        Preconditions.checkNotNull((Object)file, (Object)"Cannot export to a null file");
        Preconditions.checkNotNull((Object)cruiseId, (Object)"Cannot export a null cruise");
        Preconditions.checkNotNull((Object)fishingOperationId, (Object)"Cannot export a null fishing operation");
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export fishing operation " + fishingOperationId + " to file: " + file));
        }
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise, (Object)("Cruise [" + cruiseId + "] not found"));
        ArrayList operations = Lists.newArrayList((Object[])new String[]{fishingOperationId});
        this.prepareOperationsAndExport(file, operations);
    }

    protected void prepareOperationsAndExport(File file, List<String> operations) {
        ArrayList rows = Lists.newArrayList();
        if (operations != null) {
            for (String operationId : operations) {
                this.prepareFishingOperation(rows, operationId);
            }
        }
        CatchRowModel csvModel = new CatchRowModel(this.context.getConfig().getCsvSeparator());
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.sumatra.export.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected void prepareFishingOperation(List<CatchRow> rows, String operationId) {
        CatchRow row;
        Float weight;
        int number;
        Species sp;
        FishingOperation operation = this.persistenceService.getFishingOperation(operationId);
        CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
        BatchContainer<SpeciesBatch> speciesBatchContainer = this.weightComputingService.getComputedSpeciesBatches(operationId);
        BatchContainer<BenthosBatch> benthosBatchContainer = this.weightComputingService.getComputedBenthosBatches(operationId);
        BatchContainer<MarineLitterBatch> marineLitterBatch = this.weightComputingService.getComputedMarineLitterBatches(operationId, catchBatch.getMarineLitterTotalWeight());
        this.weightComputingService.computeCatchBatchWeights(catchBatch, speciesBatchContainer, benthosBatchContainer, marineLitterBatch);
        Float totalWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)catchBatch.getCatchTotalWeight(), (Number)catchBatch.getCatchTotalComputedWeight());
        Float totalUnsortedWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)catchBatch.getCatchTotalUnsortedComputedWeight(), (Number)Float.valueOf(0.0f));
        Float totalSortedSpeciesWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)catchBatch.getSpeciesTotalSortedWeight(), (Number)catchBatch.getSpeciesTotalSortedComputedWeight());
        Float totalSampleSortedSpeciesWeight = catchBatch.getSpeciesTotalSampleSortedComputedWeight();
        Float totalSortedBenthosWeight = (Float)TuttiEntities.getValueOrComputedValue((Number)catchBatch.getBenthosTotalSortedWeight(), (Number)catchBatch.getBenthosTotalSortedComputedWeight());
        Float totalSampleSortedBenthosWeight = catchBatch.getBenthosTotalSampleSortedComputedWeight();
        Float totalSortedWeight = catchBatch.getCatchTotalSortedComputedWeight();
        Float catchRaisingFactor = Float.valueOf(totalWeight == null || totalUnsortedWeight == null || totalSortedWeight == null ? 1.0f : (totalWeight.floatValue() - totalUnsortedWeight.floatValue()) / totalSortedWeight.floatValue());
        Float speciesCatchRaisingFactor = Float.valueOf(totalSampleSortedSpeciesWeight == null || totalSortedSpeciesWeight == null || totalSampleSortedSpeciesWeight == null ? 1.0f : (totalSampleSortedSpeciesWeight.floatValue() == 0.0f ? 0.0f : totalSortedSpeciesWeight.floatValue() / totalSampleSortedSpeciesWeight.floatValue() * catchRaisingFactor.floatValue()));
        Float benthosCatchRaisingFactor = Float.valueOf(totalSampleSortedBenthosWeight == null || totalSortedBenthosWeight == null || totalSampleSortedBenthosWeight == null ? 1.0f : (totalSampleSortedBenthosWeight.floatValue() == 0.0f ? 0.0f : totalSortedBenthosWeight.floatValue() / totalSampleSortedBenthosWeight.floatValue() * catchRaisingFactor.floatValue()));
        speciesCatchRaisingFactor = Float.valueOf(speciesCatchRaisingFactor.floatValue() * catchRaisingFactor.floatValue());
        benthosCatchRaisingFactor = Float.valueOf(benthosCatchRaisingFactor.floatValue() * catchRaisingFactor.floatValue());
        LinkedHashMap rowMap = Maps.newLinkedHashMap();
        if (speciesBatchContainer != null) {
            List speciesBatches = speciesBatchContainer.getChildren();
            for (SpeciesBatch batch : speciesBatches) {
                sp = batch.getSpecies();
                number = Math.round(this.computeNumber((SpeciesAbleBatch)batch, 1.0f));
                weight = (Float)TuttiEntities.getValueOrComputedValue((Number)batch.getSampleCategoryWeight(), (Number)batch.getSampleCategoryComputedWeight());
                weight = Float.valueOf(weight.floatValue() * speciesCatchRaisingFactor.floatValue());
                number = (int)(speciesCatchRaisingFactor.floatValue() * (float)number);
                row = (CatchRow)rowMap.get(sp);
                if (row == null) {
                    row = new CatchRow();
                    row.setFishingOperation(operation);
                    row.setSpecies(sp);
                    row.setWeight(weight);
                    row.setNumber(number);
                } else {
                    row.setWeight(Float.valueOf(row.getWeight().floatValue() + weight.floatValue()));
                    row.setNumber(row.getNumber() + number);
                }
                rowMap.put(sp, row);
            }
            rows.addAll(rowMap.values());
        }
        rowMap.clear();
        if (benthosBatchContainer != null) {
            List benthosBatches = benthosBatchContainer.getChildren();
            for (SpeciesBatch batch : benthosBatches) {
                sp = batch.getSpecies();
                number = Math.round(this.computeNumber((SpeciesAbleBatch)batch, 1.0f));
                weight = (Float)TuttiEntities.getValueOrComputedValue((Number)batch.getSampleCategoryWeight(), (Number)batch.getSampleCategoryComputedWeight());
                weight = Float.valueOf(weight.floatValue() * benthosCatchRaisingFactor.floatValue());
                number = (int)(benthosCatchRaisingFactor.floatValue() * (float)number);
                row = (CatchRow)rowMap.get(sp);
                if (row == null) {
                    row = new CatchRow();
                    row.setFishingOperation(operation);
                    row.setSpecies(sp);
                    row.setWeight(weight);
                    row.setNumber(number);
                } else {
                    row.setWeight(Float.valueOf(row.getWeight().floatValue() + weight.floatValue()));
                    row.setNumber(row.getNumber() + number);
                }
                rowMap.put(sp, row);
            }
        }
        rows.addAll(rowMap.values());
    }

    protected float computeNumber(SpeciesAbleBatch batch, float rf) {
        float result;
        float weight = ((Float)TuttiEntities.getValueOrComputedValue((Number)batch.getSampleCategoryWeight(), (Number)batch.getSampleCategoryComputedWeight())).floatValue();
        if (batch.isChildBatchsEmpty()) {
            Float subweight;
            Integer number = (Integer)TuttiEntities.getValueOrComputedValue((Number)batch.getNumber(), (Number)batch.getComputedNumber());
            if (number == null) {
                number = 0;
            }
            if ((subweight = (Float)TuttiEntities.getValueOrComputedValue((Number)batch.getWeight(), (Number)batch.getComputedWeight())) != null) {
                rf *= weight / subweight.floatValue();
            }
            result = number.floatValue() * rf;
        } else {
            float totalWeight = 0.0f;
            for (SpeciesAbleBatch child : batch.getChildBatchs()) {
                totalWeight += ((Float)TuttiEntities.getValueOrComputedValue((Number)child.getSampleCategoryWeight(), (Number)child.getSampleCategoryComputedWeight())).floatValue();
            }
            result = 0.0f;
            float rf2 = rf * weight / totalWeight;
            for (SpeciesAbleBatch child : batch.getChildBatchs()) {
                result += this.computeNumber(child, rf2);
            }
        }
        return result;
    }
}

