/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class OperationExportRow
implements Serializable {
    public static final String PROPERTY_DURATION = "duration";
    public static final String PROPERTY_VERTICAL_OPENING_GEAR_USE_FEATURE = "verticalOpeningGearUseFeature";
    public static final String PROPERTY_HORIZONTAL_OPENING_WING_GEAR_USE_FEATURE = "horizontalOpeningWingGearUseFeature";
    public static final String PROPERTY_HORIZONTAL_OPENING_DOOR_GEAR_USE_FEATURE = "horizontalOpeningDoorGearUseFeature";
    public static final String PROPERTY_CATCH_TOTAL_WEIGHT = "catchTotalWeight";
    public static final String PROPERTY_CATCH_TOTAL_WEIGHT_COMPUTED = "catchTotalWeightComputed";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_TREMIS_WEIGHT = "catchTotalSortedTremisWeight";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_COMPUTED = "catchTotalSortedTremisWeightComputed";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT = "catchTotalSortedCarousselWeight";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_COMPUTED = "catchTotalSortedCarousselWeightComputed";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_WEIGHT = "catchTotalSortedWeight";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_WEIGHT_COMPUTED = "catchTotalSortedWeightComputed";
    public static final String PROPERTY_CATCH_TOTAL_UNSORTED_WEIGHT = "catchTotalUnsortedWeight";
    public static final String PROPERTY_CATCH_TOTAL_UNSORTED_WEIGHT_COMPUTED = "catchTotalUnsortedWeightComputed";
    public static final String PROPERTY_CATCH_TOTAL_REJECTED_WEIGHT = "catchTotalRejectedWeight";
    public static final String PROPERTY_CATCH_TOTAL_REJECTED_WEIGHT_COMPUTED = "catchTotalRejectedWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_WEIGHT = "speciesTotalWeight";
    public static final String PROPERTY_SPECIES_TOTAL_WEIGHT_COMPUTED = "speciesTotalWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT = "speciesTotalSortedWeight";
    public static final String PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT_COMPUTED = "speciesTotalSortedWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_UNSORTED_WEIGHT = "speciesTotalUnsortedWeight";
    public static final String PROPERTY_SPECIES_TOTAL_UNSORTED_WEIGHT_COMPUTED = "speciesTotalUnsortedWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT = "speciesTotalSampleSortedWeight";
    public static final String PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_COMPUTED = "speciesTotalSampleSortedWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_INERT_WEIGHT = "speciesTotalInertWeight";
    public static final String PROPERTY_SPECIES_TOTAL_INERT_WEIGHT_COMPUTED = "speciesTotalInertWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT = "speciesTotalLivingNotItemizedWeight";
    public static final String PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_COMPUTED = "speciesTotalLivingNotItemizedWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_WEIGHT = "benthosTotalWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_WEIGHT_COMPUTED = "benthosTotalWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT = "benthosTotalSortedWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT_COMPUTED = "benthosTotalSortedWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT = "benthosTotalUnsortedWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT_COMPUTED = "benthosTotalUnsortedWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT = "benthosTotalSampleSortedWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_COMPUTED = "benthosTotalSampleSortedWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_INERT_WEIGHT = "benthosTotalInertWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_INERT_WEIGHT_COMPUTED = "benthosTotalInertWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT = "benthosTotalLivingNotItemizedWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_COMPUTED = "benthosTotalLivingNotItemizedWeightComputed";
    public static final String PROPERTY_MARINE_LITTER_TOTAL_WEIGHT = "marineLitterTotalWeight";
    public static final String PROPERTY_MARINE_LITTER_TOTAL_WEIGHT_COMPUTED = "marineLitterTotalWeightComputed";
    private static final long serialVersionUID = 1L;
    protected Cruise cruise;
    protected FishingOperation fishingOperation;
    protected CatchBatch catchBatch;
    private Caracteristic verticalOpeningCaracteristic;
    private Caracteristic horizontalOpeningWingCaracteristic;
    private Caracteristic horizontalOpeningDoorCaracteristic;

    public OperationExportRow(Caracteristic verticalOpeningCaracteristic, Caracteristic horizontalOpeningWingCaracteristic, Caracteristic horizontalOpeningDoorCaracteristic) {
        this.verticalOpeningCaracteristic = verticalOpeningCaracteristic;
        this.horizontalOpeningWingCaracteristic = horizontalOpeningWingCaracteristic;
        this.horizontalOpeningDoorCaracteristic = horizontalOpeningDoorCaracteristic;
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public void setCatchBatch(CatchBatch catchBatch) {
        this.catchBatch = catchBatch;
    }

    public Date getBeginDate() {
        return this.cruise.getBeginDate();
    }

    public Program getProgram() {
        return this.cruise.getProgram();
    }

    public String getSurveyPart() {
        return this.cruise.getSurveyPart();
    }

    public String getStationNumber() {
        return this.fishingOperation.getStationNumber();
    }

    public Integer getFishingOperationNumber() {
        return this.fishingOperation.getFishingOperationNumber();
    }

    public String getMultirigAggregation() {
        return this.fishingOperation.getMultirigAggregation();
    }

    public Gear getGear() {
        return this.fishingOperation.getGear();
    }

    public Vessel getVessel() {
        return this.fishingOperation.getVessel();
    }

    public Date getGearShootingStartDate() {
        return this.fishingOperation.getGearShootingStartDate();
    }

    public Float getGearShootingStartLatitude() {
        return this.fishingOperation.getGearShootingStartLatitude();
    }

    public Float getGearShootingStartLongitude() {
        return this.fishingOperation.getGearShootingStartLongitude();
    }

    public Date getGearShootingEndDate() {
        return this.fishingOperation.getGearShootingEndDate();
    }

    public Float getGearShootingEndLatitude() {
        return this.fishingOperation.getGearShootingEndLatitude();
    }

    public Float getGearShootingEndLongitude() {
        return this.fishingOperation.getGearShootingEndLongitude();
    }

    public TuttiLocation getStrata() {
        return this.fishingOperation.getStrata();
    }

    public TuttiLocation getSubStrata() {
        return this.fishingOperation.getSubStrata();
    }

    public TuttiLocation getLocation() {
        return this.fishingOperation.getLocation();
    }

    public Boolean getFishingOperationValid() {
        return this.fishingOperation.getFishingOperationValid();
    }

    public boolean isFishingOperationRectiligne() {
        return this.fishingOperation.isFishingOperationRectiligne();
    }

    public Float getTrawlDistance() {
        return this.fishingOperation.getTrawlDistance();
    }

    public String getComment() {
        return this.fishingOperation.getComment();
    }

    public List<Person> getRecorderPerson() {
        return this.fishingOperation.getRecorderPerson();
    }

    public List<Vessel> getSecondaryVessel() {
        return this.fishingOperation.getSecondaryVessel();
    }

    public String getDuration() {
        return TuttiEntities.getDuration((Date)this.getGearShootingStartDate(), (Date)this.getGearShootingEndDate(), (String)"mm");
    }

    public Serializable getVerticalOpeningGearUseFeature() {
        Serializable result = this.getGearUseFeature(this.verticalOpeningCaracteristic);
        return result;
    }

    public Serializable getHorizontalOpeningWingGearUseFeature() {
        Serializable result = this.getGearUseFeature(this.horizontalOpeningWingCaracteristic);
        return result;
    }

    public Serializable getHorizontalOpeningDoorGearUseFeature() {
        Serializable result = this.getGearUseFeature(this.horizontalOpeningDoorCaracteristic);
        return result;
    }

    public Float getCatchTotalWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getCatchTotalWeight(), (Number)this.catchBatch.getCatchTotalComputedWeight());
    }

    public Boolean getCatchTotalWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getCatchTotalWeight(), (Number)this.catchBatch.getCatchTotalComputedWeight());
    }

    public Float getCatchTotalSortedTremisWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getCatchTotalSortedTremisWeight(), null);
    }

    public Boolean getCatchTotalSortedTremisWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getCatchTotalSortedTremisWeight(), null);
    }

    public Float getCatchTotalSortedCarousselWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getCatchTotalSortedCarousselWeight(), null);
    }

    public Boolean getCatchTotalSortedCarousselWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getCatchTotalSortedCarousselWeight(), null);
    }

    public Float getCatchTotalSortedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue(null, (Number)this.catchBatch.getCatchTotalSortedComputedWeight());
    }

    public Boolean getCatchTotalSortedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed(null, (Number)this.catchBatch.getCatchTotalSortedComputedWeight());
    }

    public Float getCatchTotalUnsortedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue(null, (Number)this.catchBatch.getCatchTotalUnsortedComputedWeight());
    }

    public Boolean getCatchTotalUnsortedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed(null, (Number)this.catchBatch.getCatchTotalUnsortedComputedWeight());
    }

    public Float getCatchTotalRejectedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getCatchTotalRejectedWeight(), (Number)this.catchBatch.getCatchTotalRejectedComputedWeight());
    }

    public Boolean getCatchTotalRejectedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getCatchTotalRejectedWeight(), (Number)this.catchBatch.getCatchTotalRejectedComputedWeight());
    }

    public Float getSpeciesTotalWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue(null, (Number)this.catchBatch.getSpeciesTotalComputedWeight());
    }

    public Boolean getSpeciesTotalWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed(null, (Number)this.catchBatch.getSpeciesTotalComputedWeight());
    }

    public Float getSpeciesTotalSortedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalSortedWeight(), (Number)this.catchBatch.getSpeciesTotalSortedComputedWeight());
    }

    public Boolean getSpeciesTotalSortedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getSpeciesTotalSortedWeight(), (Number)this.catchBatch.getSpeciesTotalSortedComputedWeight());
    }

    public Float getSpeciesTotalUnsortedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue(null, (Number)this.catchBatch.getSpeciesTotalUnsortedComputedWeight());
    }

    public Boolean getSpeciesTotalUnsortedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed(null, (Number)this.catchBatch.getSpeciesTotalUnsortedComputedWeight());
    }

    public Float getSpeciesTotalSampleSortedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalSampleSortedComputedWeight(), (Number)this.catchBatch.getSpeciesTotalSampleSortedComputedWeight());
    }

    public Boolean getSpeciesTotalSampleSortedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed(null, (Number)this.catchBatch.getSpeciesTotalSampleSortedComputedWeight());
    }

    public Float getSpeciesTotalInertWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalInertWeight(), (Number)this.catchBatch.getSpeciesTotalInertComputedWeight());
    }

    public Boolean getSpeciesTotalInertWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getSpeciesTotalInertWeight(), (Number)this.catchBatch.getSpeciesTotalInertComputedWeight());
    }

    public Float getSpeciesTotalLivingNotItemizedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalLivingNotItemizedWeight(), (Number)this.catchBatch.getSpeciesTotalLivingNotItemizedComputedWeight());
    }

    public Boolean getSpeciesTotalLivingNotItemizedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getSpeciesTotalLivingNotItemizedWeight(), (Number)this.catchBatch.getSpeciesTotalLivingNotItemizedComputedWeight());
    }

    public Float getBenthosTotalWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue(null, (Number)this.catchBatch.getBenthosTotalComputedWeight());
    }

    public Boolean getBenthosTotalWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed(null, (Number)this.catchBatch.getBenthosTotalComputedWeight());
    }

    public Float getBenthosTotalSortedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getBenthosTotalSortedWeight(), (Number)this.catchBatch.getBenthosTotalSortedComputedWeight());
    }

    public Boolean getBenthosTotalSortedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getBenthosTotalSortedWeight(), (Number)this.catchBatch.getBenthosTotalSortedComputedWeight());
    }

    public Float getBenthosTotalUnsortedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue(null, (Number)this.catchBatch.getBenthosTotalUnsortedComputedWeight());
    }

    public Boolean getBenthosTotalUnsortedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed(null, (Number)this.catchBatch.getBenthosTotalUnsortedComputedWeight());
    }

    public Float getBenthosTotalSampleSortedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue(null, (Number)this.catchBatch.getBenthosTotalSampleSortedComputedWeight());
    }

    public Boolean getBenthosTotalSampleSortedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed(null, (Number)this.catchBatch.getBenthosTotalSampleSortedComputedWeight());
    }

    public Float getBenthosTotalInertWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getBenthosTotalInertWeight(), (Number)this.catchBatch.getBenthosTotalInertComputedWeight());
    }

    public Boolean getBenthosTotalInertWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getBenthosTotalInertWeight(), (Number)this.catchBatch.getBenthosTotalInertComputedWeight());
    }

    public Float getBenthosTotalLivingNotItemizedWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getBenthosTotalLivingNotItemizedWeight(), (Number)this.catchBatch.getBenthosTotalLivingNotItemizedComputedWeight());
    }

    public Boolean getBenthosTotalLivingNotItemizedWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getBenthosTotalLivingNotItemizedWeight(), (Number)this.catchBatch.getBenthosTotalLivingNotItemizedComputedWeight());
    }

    public Float getMarineLitterTotalWeight() {
        return (Float)TuttiEntities.getValueOrComputedValue((Number)this.catchBatch.getMarineLitterTotalWeight(), (Number)this.catchBatch.getMarineLitterTotalComputedWeight());
    }

    public Boolean getMarineLitterTotalWeightComputed() {
        return TuttiEntities.getValueOrComputedValueComputed((Number)this.catchBatch.getMarineLitterTotalWeight(), (Number)this.catchBatch.getMarineLitterTotalComputedWeight());
    }

    protected Serializable getGearUseFeature(Caracteristic caracteristic) {
        CaracteristicMap gearUseFeatures = this.fishingOperation.getGearUseFeatures();
        Serializable serializable = gearUseFeatures == null ? null : (Serializable)gearUseFeatures.get((Object)caracteristic);
        return serializable;
    }
}

