/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class CloneProtocolAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(CloneProtocolAction.class);
    public static final JAXXContextEntryDef<TuttiProtocol> CLONE_PROTOCOL_ENTRY = new JAXXContextEntryDef("cloneProtocol", TuttiProtocol.class);
    protected TuttiProtocol protocol;

    public CloneProtocolAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_PROTOCOL);
    }

    @Override
    public boolean prepareAction() throws Exception {
        CLONE_PROTOCOL_ENTRY.removeContextValue((JAXXContext)this.getContext().getMainUI());
        boolean doAction = super.prepareAction();
        if (doAction) {
            SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
            if (log.isInfoEnabled()) {
                log.info((Object)("Clone protocol: " + this.getContext().getProtocolId()));
            }
            this.protocol = this.getContext().getPersistenceService().getProtocol(this.getContext().getProtocolId());
            this.protocol.setId((String)null);
            HashSet badCategories = Sets.newHashSet();
            TuttiProtocols.checkSampleCategories(sampleCategoryModel, this.protocol, badCategories);
            if (!badCategories.isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("There is some bad categories: " + badCategories));
                }
                String message = TuttiProtocols.getBadCategoriesMessage(badCategories, this.getDecorator(Caracteristic.class, null), (TuttiPersistence)this.getContext().getPersistenceService());
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n._((String)"tutti.common.askBeforeCloneProtocol.help", (Object[])new Object[0]));
                int response = JOptionPane.showOptionDialog(this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.common.askBeforeEditProtocol.title", (Object[])new Object[0]), 0, 2, UIManager.getIcon("warning"), new Object[]{I18n._((String)"tutti.option.cleanAndClone", (Object[])new Object[0]), I18n._((String)"tutti.option.clone", (Object[])new Object[0]), I18n._((String)"tutti.option.cancel", (Object[])new Object[0])}, I18n._((String)"tutti.option.cancel", (Object[])new Object[0]));
                switch (response) {
                    case 0: {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Clean and Clone");
                        }
                        TuttiProtocols.removeBadCategories(sampleCategoryModel, this.protocol);
                        break;
                    }
                    case 1: {
                        if (!log.isInfoEnabled()) break;
                        log.info((Object)"Clone with no cleaning");
                        break;
                    }
                    default: {
                        doAction = false;
                    }
                }
            }
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.protocol);
        CLONE_PROTOCOL_ENTRY.setContextValue((JAXXContext)this.getContext().getMainUI(), (Object)this.protocol);
        this.protocol = null;
        this.createProgressionModelIfRequired(4);
        this.getContext().setProtocolId(null);
        super.doAction();
    }
}

