/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import org.andromda.cartridges.spring.metafacades.SpringManageableEntityLogic;
import org.andromda.cartridges.spring.metafacades.SpringMetafacadeUtils;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class SpringManageableEntityLogicImpl
extends SpringManageableEntityLogic {
    public SpringManageableEntityLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    private String getNamespaceProperty() {
        return (String)this.getConfiguredProperty("namespaceSeparator");
    }

    protected String handleGetDaoReferenceName() {
        char[] name = this.getName().toCharArray();
        if (name.length > 0) {
            name[0] = Character.toLowerCase(name[0]);
        }
        return new String(name) + "Dao";
    }

    protected String handleGetManageableDaoName() {
        return this.getName() + "ManageableDao";
    }

    protected String handleGetFullyQualifiedManageableDaoName() {
        return this.getManageablePackageName() + this.getNamespaceProperty() + this.getManageableDaoName();
    }

    protected String handleGetManageableDaoFullPath() {
        return StringUtils.replace((String)this.getFullyQualifiedManageableDaoName(), (String)this.getNamespaceProperty(), (String)"/");
    }

    protected String handleGetManageableDaoBaseName() {
        return this.getManageableDaoName() + "Base";
    }

    protected String handleGetFullyQualifiedManageableDaoBaseName() {
        return this.getManageablePackageName() + this.getNamespaceProperty() + this.getManageableDaoBaseName();
    }

    protected String handleGetManageableDaoBaseFullPath() {
        return StringUtils.replace((String)this.getFullyQualifiedManageableDaoBaseName(), (String)this.getNamespaceProperty(), (String)"/");
    }

    protected String handleGetManageableServiceBaseName() {
        return this.getManageableServiceName() + "Base";
    }

    protected String handleGetFullyQualifiedManageableServiceBaseName() {
        return this.getManageablePackageName() + this.getNamespaceProperty() + this.getManageableServiceBaseName();
    }

    protected String handleGetManageableServiceBaseFullPath() {
        return StringUtils.replace((String)this.getFullyQualifiedManageableServiceBaseName(), (String)this.getNamespaceProperty(), (String)"/");
    }

    protected String handleGetManageableValueObjectFullPath() {
        return StringUtils.replace((String)this.getFullyQualifiedManageableValueObjectName(), (String)this.getNamespaceProperty(), (String)"/");
    }

    protected String handleGetManageableValueObjectClassName() {
        return this.getName() + this.getConfiguredProperty("crudValueObjectSuffix");
    }

    protected String handleGetFullyQualifiedManageableValueObjectName() {
        return this.getManageablePackageName() + this.getNamespaceProperty() + this.getManageableValueObjectClassName();
    }

    protected boolean handleIsRemotingTypeRmi() {
        return this.getRemotingType().equalsIgnoreCase("rmi");
    }

    protected boolean handleIsRemotingTypeNone() {
        return this.getRemotingType().equalsIgnoreCase("none");
    }

    protected boolean handleIsRemotingTypeHttpInvoker() {
        return this.getRemotingType().equalsIgnoreCase("httpinvoker");
    }

    protected boolean handleIsRemotingTypeHessian() {
        return this.getRemotingType().equalsIgnoreCase("hessian");
    }

    protected boolean handleIsRemotingTypeBurlap() {
        return this.getRemotingType().equalsIgnoreCase("burlap");
    }

    protected String handleGetRemoteUrl() {
        StringBuffer result = new StringBuffer();
        String propertyPrefix = ObjectUtils.toString((Object)this.getConfiguredProperty("configPropertyPrefix"));
        if (!this.isRemotingTypeNone()) {
            if (this.isRemotingTypeHttpInvoker() || this.isRemotingTypeHessian() || this.isRemotingTypeBurlap()) {
                result.append("http://${");
                result.append(propertyPrefix);
                result.append("remoteServer}");
                if (this.hasServiceRemotePort()) {
                    result.append(":${");
                    result.append(propertyPrefix);
                    result.append("remotePort}");
                }
                if (this.hasServiceRemoteContext()) {
                    result.append("/${");
                    result.append(propertyPrefix);
                    result.append("remoteContext}");
                }
                result.append("/remote");
                result.append(this.getManageableServiceName());
            } else if (this.isRemotingTypeRmi()) {
                result.append("rmi://${");
                result.append(propertyPrefix);
                result.append("remoteServer}");
                if (this.hasServiceRemotePort()) {
                    result.append(":${");
                    result.append(propertyPrefix);
                    result.append("remotePort}");
                }
                result.append("/remote");
                result.append(this.getManageableServiceName());
            }
        }
        return result.toString();
    }

    protected String handleGetRemoteServer() {
        return StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemoteServer")));
    }

    protected String handleGetRemotePort() {
        String serviceRemotePort = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemotePort")));
        return SpringMetafacadeUtils.getServiceRemotePort((ClassifierFacade)this, serviceRemotePort);
    }

    protected String handleGetRemoteContext() {
        return this.isConfiguredProperty("serviceRemoteContext") ? ObjectUtils.toString((Object)this.getConfiguredProperty("serviceRemoteContext")) : "";
    }

    protected boolean handleIsRemotable() {
        return !this.isRemotingTypeNone();
    }

    private String getRemotingType() {
        String serviceRemotingType = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemotingType")));
        return SpringMetafacadeUtils.getServiceRemotingType((ClassifierFacade)this, serviceRemotingType);
    }

    private boolean hasServiceRemotePort() {
        return StringUtils.isNotEmpty((String)this.getRemotePort());
    }

    private boolean hasServiceRemoteContext() {
        return StringUtils.isNotEmpty((String)this.getRemoteContext());
    }
}

