/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.metafacade.MetafacadeMappings;
import org.andromda.core.metafacade.MetafacadeMappingsException;
import org.andromda.core.metafacade.MetafacadeUtils;
import org.andromda.core.profile.Profile;
import org.apache.commons.lang.StringUtils;

public class MetafacadeMapping {
    private Class metafacadeClass = null;
    private String mappingClassName = null;
    private boolean contextRoot = false;
    private final List stereotypes = new ArrayList();
    private final Collection propertyReferences = new LinkedHashSet();
    private PropertyGroup mappingProperties = null;
    private final Collection mappingPropertyGroups = new ArrayList();
    private String context = "";
    private MetafacadeMappings mappings;

    public Class getMetafacadeClass() {
        return this.metafacadeClass;
    }

    public void setMetafacadeClassName(String metafacadeClassName) {
        try {
            this.metafacadeClass = ClassUtils.loadClass(StringUtils.trimToEmpty((String)metafacadeClassName));
        }
        catch (Throwable throwable) {
            throw new MetafacadeMappingsException(throwable);
        }
    }

    protected String getMappingClassName() {
        if (this.mappingClassName == null || this.mappingClassName.trim().length() == 0) {
            this.mappingClassName = MetafacadeUtils.getInheritedMappingClassName(this);
        }
        return this.mappingClassName;
    }

    final boolean isMappingClassNamePresent() {
        return this.mappingClassName != null && this.mappingClassName.trim().length() > 0;
    }

    public void setMappingClassName(String mappingClassName) {
        this.mappingClassName = StringUtils.trimToEmpty((String)mappingClassName);
    }

    public boolean isContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(boolean contextRoot) {
        this.contextRoot = contextRoot;
    }

    public void addStereotype(String stereotype) {
        this.stereotypes.add(stereotype);
    }

    final List getStereotypes() {
        ListIterator<String> iterator = this.stereotypes.listIterator();
        while (iterator.hasNext()) {
            iterator.set(Profile.instance().get((String)iterator.next()));
        }
        return this.stereotypes;
    }

    final boolean hasStereotypes() {
        return !this.stereotypes.isEmpty();
    }

    public void addPropertyReference(String reference) {
        this.propertyReferences.add(reference);
    }

    public Collection getPropertyReferences() {
        return this.propertyReferences;
    }

    public void addMappingProperty(String name, String value) {
        if (value != null) {
            if (this.mappingProperties == null) {
                this.mappingProperties = new PropertyGroup();
                this.mappingPropertyGroups.add(this.mappingProperties);
            }
            this.mappingProperties.addProperty(new Property(name, value));
        }
    }

    final void addMappingPropertyGroup(PropertyGroup propertyGroup) {
        this.mappingPropertyGroups.add(propertyGroup);
    }

    final Collection getMappingPropertyGroups() {
        return this.mappingPropertyGroups;
    }

    final PropertyGroup getMappingProperties() {
        return this.mappingProperties;
    }

    final boolean hasMappingProperties() {
        return this.mappingProperties != null && !this.mappingProperties.getProperties().isEmpty();
    }

    public void addPropertyReferences(Collection propertyReferences) {
        if (propertyReferences != null) {
            this.propertyReferences.addAll(propertyReferences);
        }
    }

    public void setContext(String context) {
        this.context = StringUtils.trimToEmpty((String)context);
    }

    final String getContext() {
        return this.context;
    }

    final boolean hasContext() {
        return StringUtils.isNotEmpty((String)this.context);
    }

    final void setMetafacadeMappings(MetafacadeMappings mappings) {
        this.mappings = mappings;
    }

    final MetafacadeMappings getMetafacadeMappings() {
        return this.mappings;
    }

    final boolean match(MetafacadeMapping mapping) {
        boolean match;
        boolean bl = match = mapping != null && this.getMetafacadeClass().equals(mapping.getMetafacadeClass()) && ((Object)this.getStereotypes()).equals(mapping.getStereotypes()) && this.getContext().equals(mapping.getContext());
        if (match && this.mappingClassName != null && mapping.mappingClassName != null) {
            match = this.getMappingClassName().equals(mapping.getMappingClassName());
        }
        return match;
    }

    public String toString() {
        return super.toString() + "[" + this.getMetafacadeClass() + "], mappingClassName[" + this.mappingClassName + "], properties[" + this.getMappingProperties() + "], stereotypes" + this.stereotypes + ", context[" + this.context + "], propertiesReferences" + this.getPropertyReferences();
    }

    static final class Property {
        private String name;
        private String value;

        Property(String name, String value) {
            this.name = StringUtils.trimToEmpty((String)name);
            this.value = value;
        }

        final String getName() {
            return StringUtils.trimToEmpty((String)this.name);
        }

        final String getValue() {
            return StringUtils.trimToEmpty((String)this.value);
        }
    }

    static final class PropertyGroup {
        private final Map properties = new LinkedHashMap();

        PropertyGroup() {
        }

        final void addProperty(Property property) {
            String name = property.getName();
            if (!this.properties.containsKey(name)) {
                this.properties.put(name, property);
            }
        }

        final Collection getProperties() {
            return this.properties.values();
        }

        public String toString() {
            StringBuffer toString = new StringBuffer();
            char seperator = ':';
            Iterator iterator = this.getProperties().iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                toString.append(property.getName());
                if (StringUtils.isNotEmpty((String)property.getValue())) {
                    toString.append(seperator);
                    toString.append(property.getValue());
                }
                if (!iterator.hasNext()) continue;
                toString.append(seperator);
            }
            return toString.toString();
        }
    }
}

