/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.sql.ResultSet;
import java.sql.SQLException;
import liquibase.database.Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.jvm.JdbcDatabaseSnapshotGenerator;

public class DerbyDatabaseSnapshotGenerator
extends JdbcDatabaseSnapshotGenerator {
    public boolean supports(Database database) {
        return database instanceof DerbyDatabase;
    }

    public int getPriority(Database database) {
        return 5;
    }

    protected String convertTableNameToDatabaseTableName(String tableName) {
        return tableName.toUpperCase();
    }

    protected String convertColumnNameToDatabaseTableName(String columnName) {
        return columnName.toUpperCase();
    }

    public boolean hasIndex(String schemaName, String tableName, String indexName, Database database, String columnNames) throws DatabaseException {
        try {
            ResultSet rs = this.getMetaData(database).getIndexInfo(database.convertRequestedSchemaToCatalog(schemaName), database.convertRequestedSchemaToSchema(schemaName), "%", false, true);
            while (rs.next()) {
                if (rs.getString("INDEX_NAME").equalsIgnoreCase(indexName)) {
                    return true;
                }
                if (tableName == null || columnNames == null || !tableName.equalsIgnoreCase(rs.getString("TABLE_NAME")) || !columnNames.replaceAll(" ", "").equalsIgnoreCase(rs.getString("COLUMN_NAME").replaceAll(" ", ""))) continue;
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }
}

