/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import liquibase.logging.LogLevel;
import liquibase.logging.core.AbstractLogger;
import liquibase.util.StringUtils;

public class DefaultLogger
extends AbstractLogger {
    private String name = "liquibase";
    private PrintStream err = System.err;

    public DefaultLogger() {
        String passedLevel = System.getProperty("liquibase.defaultlogger.level");
        if (passedLevel == null) {
            this.setLogLevel(LogLevel.INFO);
        } else {
            this.setLogLevel(passedLevel);
        }
    }

    public int getPriority() {
        return 1;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLogLevel(String logLevel, String logFile) {
        this.setLogLevel(logLevel);
        if (logFile != null) {
            File log = new File(logFile);
            try {
                if (!log.exists() && !log.createNewFile()) {
                    throw new RuntimeException("Could not create logFile " + log.getAbsolutePath());
                }
                this.err = new PrintStream(log);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void severe(String message) {
        if (this.getLogLevel().compareTo(LogLevel.SEVERE) <= 0) {
            this.print(LogLevel.SEVERE, message);
        }
    }

    protected void print(LogLevel logLevel, String message) {
        if (StringUtils.trimToNull(message) == null) {
            return;
        }
        this.err.println((Object)((Object)logLevel) + " " + DateFormat.getDateTimeInstance(3, 3).format(new Date()) + ":" + this.name + ": " + message);
    }

    public void severe(String message, Throwable e) {
        if (this.getLogLevel().compareTo(LogLevel.SEVERE) <= 0) {
            this.print(LogLevel.SEVERE, message);
            e.printStackTrace(this.err);
        }
    }

    public void warning(String message) {
        if (this.getLogLevel().compareTo(LogLevel.WARNING) <= 0) {
            this.print(LogLevel.WARNING, message);
        }
    }

    public void warning(String message, Throwable e) {
        if (this.getLogLevel().compareTo(LogLevel.WARNING) <= 0) {
            this.print(LogLevel.WARNING, message);
            e.printStackTrace(this.err);
        }
    }

    public void info(String message) {
        if (this.getLogLevel().compareTo(LogLevel.INFO) <= 0) {
            this.print(LogLevel.INFO, message);
        }
    }

    public void info(String message, Throwable e) {
        if (this.getLogLevel().compareTo(LogLevel.INFO) <= 0) {
            this.print(LogLevel.INFO, message);
            e.printStackTrace(this.err);
        }
    }

    public void debug(String message) {
        if (this.getLogLevel().compareTo(LogLevel.DEBUG) <= 0) {
            this.print(LogLevel.DEBUG, message);
        }
    }

    public void debug(String message, Throwable e) {
        if (this.getLogLevel().compareTo(LogLevel.DEBUG) <= 0) {
            this.print(LogLevel.DEBUG, message);
            e.printStackTrace(this.err);
        }
    }
}

