/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuiton.validator.xwork2.field.NuitonFieldValidatorSupport;

public class FrenchPostCodeFieldValidator
extends NuitonFieldValidatorSupport {
    protected static String POST_CODE_REGEXP = "^((0[1-9])|([1-8][0-9])|(9[0-8])|(2A)|(2B))[0-9]{3}$";
    protected static Pattern p = Pattern.compile(POST_CODE_REGEXP);

    @Override
    public void validateWhenNotSkip(Object object) throws ValidationException {
        String fieldName = this.getFieldName();
        Object value = this.getFieldValue(fieldName, object);
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            if ("".equals(value)) {
                return;
            }
            Matcher m = p.matcher((String)value);
            if (!m.matches()) {
                this.addFieldError(fieldName, object);
            }
        } else {
            this.addFieldError(fieldName, object);
        }
    }

    public String getValidatorType() {
        return "frenchPostCode";
    }
}

