/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import java.util.Collection;
import org.andromda.cartridges.spring.SpringProfile;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

class SpringMetafacadeUtils {
    SpringMetafacadeUtils() {
    }

    static String getFullyQualifiedName(String packageName, String name, String suffix) {
        StringBuffer fullyQualifiedName = new StringBuffer(StringUtils.trimToEmpty((String)packageName));
        if (StringUtils.isNotBlank((String)packageName)) {
            fullyQualifiedName.append(".");
        }
        fullyQualifiedName.append(StringUtils.trimToEmpty((String)name));
        if (StringUtils.isNotEmpty((String)suffix)) {
            fullyQualifiedName.append(StringUtils.trimToEmpty((String)suffix));
        }
        return fullyQualifiedName.toString();
    }

    static String getFullyQualifiedName(String packageName, String name) {
        return SpringMetafacadeUtils.getFullyQualifiedName(packageName, name, null);
    }

    static String getServiceRemotingType(ClassifierFacade classifier, String defaultServiceRemotingType) {
        ExceptionUtils.checkNull((String)"classifer", (Object)classifier);
        String remotingType = null;
        if (classifier.hasStereotype(UMLProfile.STEREOTYPE_SERVICE)) {
            String remotingTypeValue = (String)classifier.findTaggedValue(SpringProfile.TAGGEDVALUE_SPRING_SERVICE_REMOTING_TYPE);
            if (StringUtils.isEmpty((String)remotingTypeValue)) {
                remotingType = (String)CollectionUtils.find((Collection)classifier.getAllGeneralizations(), (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        return ((ModelElementFacade)object).findTaggedValue(SpringProfile.TAGGEDVALUE_SPRING_SERVICE_REMOTING_TYPE) != null;
                    }
                });
            }
            if (StringUtils.isNotEmpty((String)remotingTypeValue)) {
                remotingType = remotingTypeValue;
            }
        }
        if (StringUtils.isEmpty(remotingType)) {
            remotingType = defaultServiceRemotingType;
        }
        return remotingType.toLowerCase().trim();
    }

    static String[] getServiceInterceptors(ClassifierFacade classifier, String[] defaultInterceptors) {
        ExceptionUtils.checkNull((String)"classifier", (Object)classifier);
        String[] interceptors = null;
        if (classifier.hasStereotype(UMLProfile.STEREOTYPE_SERVICE)) {
            String interceptorsValue = (String)classifier.findTaggedValue(SpringProfile.TAGGEDVALUE_SPRING_SERVICE_INTERCEPTORS);
            if (StringUtils.isEmpty((String)interceptorsValue)) {
                interceptorsValue = (String)CollectionUtils.find((Collection)classifier.getAllGeneralizations(), (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        return ((ModelElementFacade)object).findTaggedValue(SpringProfile.TAGGEDVALUE_SPRING_SERVICE_INTERCEPTORS) != null;
                    }
                });
            }
            if (StringUtils.isNotEmpty((String)interceptorsValue)) {
                interceptors = interceptorsValue.split(",");
            }
        }
        if (interceptors == null || interceptors.length == 0) {
            interceptors = defaultInterceptors;
        }
        return interceptors;
    }

    static String getServiceRemotePort(ClassifierFacade classifier, String defaultRemoteServicePort) {
        ExceptionUtils.checkNull((String)"classifer", (Object)classifier);
        String remoteServicePort = null;
        if (classifier.hasStereotype(UMLProfile.STEREOTYPE_SERVICE)) {
            String remoteServicePortValue = (String)classifier.findTaggedValue(SpringProfile.TAGGEDVALUE_SPRING_SERVICE_REMOTE_PORT);
            if (StringUtils.isEmpty((String)remoteServicePortValue)) {
                remoteServicePort = (String)CollectionUtils.find((Collection)classifier.getAllGeneralizations(), (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        return ((ModelElementFacade)object).findTaggedValue(SpringProfile.TAGGEDVALUE_SPRING_SERVICE_REMOTE_PORT) != null;
                    }
                });
            }
            if (StringUtils.isNotEmpty((String)remoteServicePortValue)) {
                remoteServicePort = remoteServicePortValue;
            }
        }
        if (StringUtils.isEmpty(remoteServicePort)) {
            remoteServicePort = defaultRemoteServicePort;
        }
        return remoteServicePort.toLowerCase().trim();
    }

    static boolean getUseNamedParameters(OperationFacade operation, boolean defaultUseNamedParameters) {
        String useNamedParametersValue;
        ExceptionUtils.checkNull((String)"operation", (Object)operation);
        boolean useNamedParameters = defaultUseNamedParameters;
        if (operation.isQuery() && StringUtils.isNotEmpty((String)(useNamedParametersValue = StringUtils.trimToEmpty((String)((String)operation.findTaggedValue(SpringProfile.TAGGEDVALUE_HIBERNATE_USE_NAMED_PARAMETERS)))))) {
            useNamedParameters = Boolean.valueOf(useNamedParametersValue);
        }
        return useNamedParameters;
    }
}

