package fr.ifremer.tutti.ui.swing.util.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiActionException.java 567 2013-03-09 13:59:14Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/action/TuttiActionException.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

/**
 * To boxe any error of a {@link AbstractTuttiAction}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.1
 */
public class TuttiActionException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private final AbstractTuttiAction action;

    public TuttiActionException(AbstractTuttiAction action, Throwable cause) {
        super(cause);
        this.action = action;
    }

    public static TuttiActionException propagateError(AbstractTuttiAction action,
                                                      Throwable cause) {
        TuttiActionException result;
        if (cause instanceof TuttiActionException) {
            result = ((TuttiActionException) cause);
        } else {
            result = new TuttiActionException(action, cause);
        }
        return result;
    }

    public AbstractTuttiAction getAction() {
        return action;
    }
}
