package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportPupitriAction.java 739 2013-04-05 13:36:16Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/ImportPupitriAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.pupitri.TuttiPupitriImportExportService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JOptionPane;
import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportPupitriAction extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {

    private Log log = LogFactory.getLog(ImportPupitriAction.class);

    protected File importedTrunkFile;

    protected File importedCarrouselFile;

    protected ImportPupitriPopupUI importPupitriDialog;

    protected TuttiProtocol currentProtocol;

    protected PersistenceService persistenceService;

    protected EditFishingOperationAction editAction;

    public ImportPupitriAction(EditCatchesUIHandler handler) {
        super(handler, false);
        persistenceService = getContext().getPersistenceService();
        importPupitriDialog = new ImportPupitriPopupUI(handler.getContext());
    }

    public EditFishingOperationAction getEditAction() {
        if (editAction == null) {
            editAction = TuttiActionHelper.createLogicAction(getHandler().getParentHandler(),
                                                             EditFishingOperationAction.class);
        }
        return editAction;
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean result = true;
        currentProtocol = getDataContext().getProtocol();

        SpeciesBatchUIModel speciesBatchUIModel = getUI().getSpeciesTabContent().getModel();
        if (speciesBatchUIModel.getRowCount() > 0) {
            String htmlMessage = String.format(
                    AbstractTuttiUIHandler.CONFIRMATION_FORMAT,
                    _("tutti.editCatchBatch.action.importPupitri.existingData.message"),
                    _("tutti.editCatchBatch.action.importPupitri.existingData.help"));

            int answer = JOptionPane.showConfirmDialog(getContext().getActionUI(),
                                                       htmlMessage,
                                                       _("tutti.editCatchBatch.action.importPupitri.existingData.title"),
                                                       JOptionPane.OK_CANCEL_OPTION,
                                                       JOptionPane.WARNING_MESSAGE);

            result = answer == JOptionPane.OK_OPTION;
        }

        if (result) {
            importPupitriDialog.open();
            importedTrunkFile = importPupitriDialog.getTrunkFile().getSelectedFile();
            importedCarrouselFile = importPupitriDialog.getCarrouselFile().getSelectedFile();
            result = importedTrunkFile != null
                     && importedCarrouselFile != null;
        }

        return result;
    }

    @Override
    protected void doAction() throws Exception {
        TuttiPupitriImportExportService pupitriImportExportService =
                getContext().getTuttiPupitriImportExportService();

        EditCatchesUIModel model = getModel();

        FishingOperation operation = model.getFishingOperation();
        CatchBatch catchBatch = model.getCatchBatch();

        // import
        int rejectedSpeciesNb =
                pupitriImportExportService.importPupitri(importedTrunkFile,
                                                         importedCarrouselFile,
                                                         operation,
                                                         catchBatch);

        String fishingOperationText = getEditAction().getFishingOperationTitle(operation);

        getEditAction().loadCatchBatch(operation, fishingOperationText, true);

        sendMessage(_("tutti.editCatchBatch.action.importPupitri.success", getUI().getSpeciesTabContent().getModel().getRootNumber(), rejectedSpeciesNb));
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        importedTrunkFile = null;
        importedCarrouselFile = null;
        currentProtocol = null;
    }

}
