/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.optimization.location;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchy;
import fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyDao;
import fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyImpl;
import fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyPK;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class LocationHierarchyDaoBase
extends HibernateDaoSupport
implements LocationHierarchyDao {
    @Override
    public Object load(int transform, Location parent, Location location) {
        LocationHierarchyPK entityPk = new LocationHierarchyPK();
        if (parent == null) {
            throw new IllegalArgumentException("LocationHierarchy.load - 'parent' can not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("LocationHierarchy.load - 'location' can not be null");
        }
        entityPk.setParent(parent);
        entityPk.setLocation(location);
        Object entity = this.getHibernateTemplate().get(LocationHierarchyImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (LocationHierarchy)entity);
    }

    @Override
    public LocationHierarchy load(Location parent, Location location) {
        return (LocationHierarchy)this.load(0, parent, location);
    }

    @Override
    public Collection<LocationHierarchy> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(LocationHierarchyImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public LocationHierarchy create(LocationHierarchy locationHierarchy) {
        return (LocationHierarchy)this.create(0, locationHierarchy);
    }

    @Override
    public Object create(int transform, LocationHierarchy locationHierarchy) {
        if (locationHierarchy == null) {
            throw new IllegalArgumentException("LocationHierarchy.create - 'locationHierarchy' can not be null");
        }
        this.getHibernateTemplate().save((Object)locationHierarchy);
        return this.transformEntity(transform, locationHierarchy);
    }

    @Override
    public Collection<LocationHierarchy> create(Collection<LocationHierarchy> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<LocationHierarchy> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationHierarchy.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationHierarchyDaoBase.this.create(transform, (LocationHierarchy)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public LocationHierarchy create(Float childSurfaceRatio, Boolean isMainAssociation, Location parent, Location location) {
        return (LocationHierarchy)this.create(0, childSurfaceRatio, isMainAssociation, parent, location);
    }

    @Override
    public Object create(int transform, Float childSurfaceRatio, Boolean isMainAssociation, Location parent, Location location) {
        LocationHierarchyImpl entity = new LocationHierarchyImpl();
        LocationHierarchyPK entityPk = new LocationHierarchyPK();
        entity.setLocationHierarchyPk(entityPk);
        entity.setChildSurfaceRatio(childSurfaceRatio);
        entity.setIsMainAssociation(isMainAssociation);
        entityPk.setParent(parent);
        entityPk.setLocation(location);
        return this.create(transform, entity);
    }

    @Override
    public void update(LocationHierarchy locationHierarchy) {
        if (locationHierarchy == null) {
            throw new IllegalArgumentException("LocationHierarchy.update - 'locationHierarchy' can not be null");
        }
        this.getHibernateTemplate().update((Object)locationHierarchy);
    }

    @Override
    public void update(final Collection<LocationHierarchy> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationHierarchy.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationHierarchyDaoBase.this.update((LocationHierarchy)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(LocationHierarchy locationHierarchy) {
        if (locationHierarchy == null) {
            throw new IllegalArgumentException("LocationHierarchy.remove - 'locationHierarchy' can not be null");
        }
        this.getHibernateTemplate().delete((Object)locationHierarchy);
    }

    @Override
    public void remove(Location parent, Location location) {
        LocationHierarchyPK entityPk = new LocationHierarchyPK();
        if (parent == null) {
            throw new IllegalArgumentException("LocationHierarchy.remove - 'parent' can not be null");
        }
        entityPk.setParent(parent);
        if (location == null) {
            throw new IllegalArgumentException("LocationHierarchy.remove - 'location' can not be null");
        }
        entityPk.setLocation(location);
        LocationHierarchy entity = this.load(parent, location);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<LocationHierarchy> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationHierarchy.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    @Override
    public LocationHierarchy findLocationHierarchyByIdentifiers(Integer id, Integer fatherId) {
        if (id == null) {
            throw new IllegalArgumentException("fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyDao.findLocationHierarchyByIdentifiers(java.lang.Integer id, java.lang.Integer fatherId) - 'id' can not be null");
        }
        if (fatherId == null) {
            throw new IllegalArgumentException("fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyDao.findLocationHierarchyByIdentifiers(java.lang.Integer id, java.lang.Integer fatherId) - 'fatherId' can not be null");
        }
        try {
            return this.handleFindLocationHierarchyByIdentifiers(id, fatherId);
        }
        catch (Throwable th) {
            throw new RuntimeException("Error performing 'fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyDao.findLocationHierarchyByIdentifiers(java.lang.Integer id, java.lang.Integer fatherId)' --> " + th, th);
        }
    }

    protected abstract LocationHierarchy handleFindLocationHierarchyByIdentifiers(Integer var1, Integer var2) throws Exception;

    @Override
    public Collection<?> findLocationHierarchiesById(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyDao.findLocationHierarchiesById(java.lang.Integer id) - 'id' can not be null");
        }
        try {
            return this.handleFindLocationHierarchiesById(id);
        }
        catch (Throwable th) {
            throw new RuntimeException("Error performing 'fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyDao.findLocationHierarchiesById(java.lang.Integer id)' --> " + th, th);
        }
    }

    protected abstract Collection<?> handleFindLocationHierarchiesById(Integer var1) throws Exception;

    @Override
    public Collection<?> findLocationHierarchiesByFatherId(Integer fatherId) {
        if (fatherId == null) {
            throw new IllegalArgumentException("fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyDao.findLocationHierarchiesByFatherId(java.lang.Integer fatherId) - 'fatherId' can not be null");
        }
        try {
            return this.handleFindLocationHierarchiesByFatherId(fatherId);
        }
        catch (Throwable th) {
            throw new RuntimeException("Error performing 'fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyDao.findLocationHierarchiesByFatherId(java.lang.Integer fatherId)' --> " + th, th);
        }
    }

    protected abstract Collection<?> handleFindLocationHierarchiesByFatherId(Integer var1) throws Exception;

    protected Object transformEntity(int transform, LocationHierarchy entity) {
        LocationHierarchy target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected LocationHierarchy toEntity(Object[] row) {
        LocationHierarchy target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof LocationHierarchy)) continue;
                target = (LocationHierarchy)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationHierarchyImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationHierarchyImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<LocationHierarchy> search(Search search) {
        return this.search(0, search);
    }
}

