/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.taxon.Citation;
import fr.ifremer.adagio.core.dao.referential.taxon.CitationDao;
import fr.ifremer.adagio.core.dao.referential.taxon.CitationImpl;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class CitationDaoBase
extends HibernateDaoSupport
implements CitationDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Citation.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(CitationImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Citation)entity);
    }

    @Override
    public Citation load(Integer id) {
        return (Citation)this.load(0, id);
    }

    @Override
    public Collection<Citation> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(CitationImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Citation create(Citation citation) {
        return (Citation)this.create(0, citation);
    }

    @Override
    public Object create(int transform, Citation citation) {
        if (citation == null) {
            throw new IllegalArgumentException("Citation.create - 'citation' can not be null");
        }
        this.getHibernateTemplate().save((Object)citation);
        return this.transformEntity(transform, citation);
    }

    @Override
    public Collection<Citation> create(Collection<Citation> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Citation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Citation.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    CitationDaoBase.this.create(transform, (Citation)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Citation create(String name, Date creationDate, Timestamp updateDate, Status status) {
        return (Citation)this.create(0, name, creationDate, updateDate, status);
    }

    @Override
    public Object create(int transform, String name, Date creationDate, Timestamp updateDate, Status status) {
        CitationImpl entity = new CitationImpl();
        entity.setName(name);
        entity.setCreationDate(creationDate);
        entity.setUpdateDate(updateDate);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public Citation create(Date creationDate, String name, Status status) {
        return (Citation)this.create(0, creationDate, name, status);
    }

    @Override
    public Object create(int transform, Date creationDate, String name, Status status) {
        CitationImpl entity = new CitationImpl();
        entity.setCreationDate(creationDate);
        entity.setName(name);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(Citation citation) {
        if (citation == null) {
            throw new IllegalArgumentException("Citation.update - 'citation' can not be null");
        }
        this.getHibernateTemplate().update((Object)citation);
    }

    @Override
    public void update(final Collection<Citation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Citation.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    CitationDaoBase.this.update((Citation)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Citation citation) {
        if (citation == null) {
            throw new IllegalArgumentException("Citation.remove - 'citation' can not be null");
        }
        this.getHibernateTemplate().delete((Object)citation);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Citation.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Citation entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Citation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Citation.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Citation entity) {
        Citation target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Citation toEntity(Object[] row) {
        Citation target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Citation)) continue;
                target = (Citation)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), CitationImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), CitationImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Citation> search(Search search) {
        return this.search(0, search);
    }
}

