/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.config.TuttiConfigUI;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.SelectCruiseAction;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.DbManagerUI;
import fr.ifremer.tutti.ui.swing.content.db.OpenDbAction;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.RemoveablePropertyChangeListener;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiUIAction;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;
import org.nuiton.util.config.ApplicationConfig;
import org.nuiton.widget.SwingSession;

public class MainUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, MainUI> {
    private static final Log log = LogFactory.getLog(MainUIHandler.class);
    protected JComponent currentBody;
    protected PersistenceService persistenceService;

    protected MainUIHandler(TuttiUIContext context, MainUI ui) {
        super(context, ui);
        this.persistenceService = context.getPersistenceService();
        context.setMainUI(ui);
        context.setActionUI(new TuttiActionUI(ui, context));
    }

    public MainUIHandler(TuttiUIContext context) {
        super(context, null);
        this.persistenceService = null;
    }

    @Override
    public void beforeInitUI() {
        this.context.addPropertyChangeListener(new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (TuttiUIContext.PROPERTIES_TO_SAVE.contains(propertyName)) {
                    MainUIHandler.this.changeTitle();
                } else if (propertyName.equals("screen")) {
                    MainUIHandler.this.setScreen((TuttiScreen)((Object)evt.getNewValue()));
                }
            }
        });
        ((MainUI)this.ui).setContextValue(this.ui, MainUI.class.getName());
        this.context.addPropertyChangeListener("busy", new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newvalue = (Boolean)evt.getNewValue();
                MainUIHandler.this.updateBusyState(newvalue != null && newvalue != false);
            }
        });
    }

    protected void updateBusyState(boolean busy) {
        if (busy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"block ui in busy mode");
            }
            ((MainUI)this.ui).setCursor(Cursor.getPredefinedCursor(3));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"unblock ui in none busy mode");
            }
            ((MainUI)this.ui).setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        SwingUtil.setLayerUI((JComponent)((MainUI)this.ui).getBody(), (LayerUI)((MainUI)this.ui).getBusyBlockLayerUI());
        ((MainUI)this.ui).applyDataBinding("menuChangeLocaleFR.enabled");
        ((MainUI)this.ui).applyDataBinding("menuChangeLocaleUK.enabled");
        SwingSession swingSession = this.context.getSwingSession();
        swingSession.add((Component)((Object)this.ui));
        swingSession.save();
        this.changeTitle();
        JToolBar bar = ((MainUI)this.ui).getBottomBar();
        ((MainUI)this.ui).getStatus().addWidget((Component)bar, 0);
        if (this.context.isDbLoaded()) {
            TuttiUIAction<SelectCruiseAction> uiAction = this.createUIAction(null, SelectCruiseAction.class);
            SelectCruiseAction logicAction = uiAction.getLogicAction();
            logicAction.setSkipCheckCurrentScreen(true);
            logicAction.setActionDescription(((MainUI)this.ui).getMenuActionSelectCruise().getToolTipText());
            uiAction.actionPerformed(null);
        } else if (this.context.isDbExist()) {
            TuttiUIAction<OpenDbAction> uiAction = this.createUIAction(null, OpenDbAction.class);
            OpenDbAction logicAction = uiAction.getLogicAction();
            logicAction.setSkipCheckCurrentScreen(true);
            logicAction.setActionDescription(I18n._((String)"tuttihelp.dbManager.action.openDb.tip", (Object[])new Object[0]));
            uiAction.actionPerformed(null);
        } else {
            this.context.clearDbContext();
            this.context.setScreen(TuttiScreen.MANAGE_DB);
        }
    }

    @Override
    public void onCloseUI() {
        this.context.setScreen(null);
        this.context.removeMessageNotifier(this);
        TuttiUIUtil.closeBean(this.context);
        TuttiUIUtil.closeUI(this.ui);
        ((MainUI)this.ui).setVisible(false);
        ((MainUI)this.ui).dispose();
    }

    @Override
    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    public void reloadUI() {
        ((MainUI)this.getUI()).getHandler().onCloseUI();
        RunTutti.startTutti(this.getContext(), false);
    }

    public boolean acceptLocale(Locale l, String expected) {
        return l != null && l.toString().equals(expected);
    }

    public void changeLocale(Locale locale) {
        ((TuttiUIContext)this.getModel()).setLocale(locale);
        I18n.setDefaultLocale((Locale)this.getConfig().getI18nLocale());
        this.getContext().reloadDecoratorService();
        this.reloadUI();
    }

    public void showConfig() {
        TuttiConfigUI configUI = new TuttiConfigUI((MainUI)this.ui);
        configUI.createUI();
    }

    public void showAbout() {
        ApplicationConfig applicationConfig = this.context.getConfig().getApplicationConfig();
        String iconPath = applicationConfig.getOption("application.icon.path");
        String name = "tutti";
        String licensePath = "META-INF/" + name + "-LICENSE.txt";
        String thirdPartyPath = "META-INF/" + name + "-THIRD-PARTY.txt";
        AboutPanel about = new AboutPanel();
        about.setTitle(I18n._((String)"tutti.title.about", (Object[])new Object[0]));
        about.setAboutText(I18n._((String)"tutti.about.message", (Object[])new Object[0]));
        TuttiApplicationConfig config = this.context.getConfig();
        int currentYear = Calendar.getInstance().get(1);
        int inceptionYear = config.getInceptionYear();
        String years = currentYear != inceptionYear ? inceptionYear + "-" + currentYear : inceptionYear + "";
        about.setBottomText(I18n._((String)"tutti.about.bottomText", (Object[])new Object[]{config.getOrganizationName(), years, config.getVersion()}));
        about.setIconPath(iconPath);
        about.setLicenseFile(licensePath);
        about.setThirdpartyFile(thirdPartyPath);
        about.buildTopPanel();
        JScrollPane component = new JScrollPane();
        JEditorPane translateArea = new JEditorPane();
        translateArea.setContentType("text/html");
        translateArea.setEditable(false);
        if (translateArea.getFont() != null) {
            translateArea.setFont(translateArea.getFont().deriveFont(11.0f));
        }
        translateArea.setBorder(null);
        String text = I18n._((String)"tutti.about.translate.content", (Object[])new Object[0]);
        translateArea.setText(text);
        component.getViewport().add(translateArea);
        about.getTabs().add(I18n._((String)"tutti.title.about.translate", (Object[])new Object[0]), component);
        about.init();
        about.showInDialog((Frame)((Object)this.ui), true);
        this.context.getSwingSession().add((Component)about);
    }

    public void gotoSite() {
        TuttiApplicationConfig config = this.context.getConfig();
        URL siteURL = config.getSiteUrl();
        if (log.isDebugEnabled()) {
            log.debug((Object)("goto " + siteURL));
        }
        TuttiUIUtil.openLink(siteURL);
    }

    public void showHelp() {
        ((TuttiUIContext)this.getModel()).showHelp((JAXXContext)this.ui, ((MainUI)this.ui).getBroker(), null);
    }

    @Override
    public final void showInformationMessage(String message) {
        ((MainUI)this.ui).getStatus().setStatus("<html><body>" + message + "</body></html>");
    }

    public void registerValidator(SwingValidator validator) {
        ((MainUI)this.ui).getValidatorMessageWidget().registerValidator(validator);
    }

    @Override
    public void clearValidators() {
        ((MainUI)this.ui).getValidatorMessageWidget().clearValidators();
    }

    public boolean quitCurrentScreen() {
        boolean canClose;
        if (this.context.getScreen() == null) {
            canClose = true;
            if (log.isWarnEnabled()) {
                log.warn((Object)"==================================================");
                log.warn((Object)"No screen, Should then skipCheckCurrent in action.");
                log.warn((Object)"==================================================");
            }
        } else {
            TuttiUI body = (TuttiUI)((Object)this.currentBody);
            Preconditions.checkNotNull((Object)this.currentBody);
            Object handler = body.getHandler();
            canClose = handler instanceof CloseableUI ? ((CloseableUI)handler).quitUI() : true;
        }
        return canClose;
    }

    public AbstractTuttiUIHandler getCurrentHandler() {
        TuttiUI body = (TuttiUI)((Object)this.currentBody);
        return body.getHandler();
    }

    public void reloadPersistenceService() {
        this.persistenceService = this.context.reloadPersistenceService();
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    protected void setScreen(TuttiScreen screen) {
        if (this.currentBody != null) {
            TuttiUI body = (TuttiUI)((Object)this.currentBody);
            ((AbstractTuttiUIHandler)body.getHandler()).onCloseUI();
            this.context.getSwingSession().save();
            ((MainUI)this.ui).getBody().remove((Component)this.currentBody);
            this.currentBody = null;
        }
        if (screen != null) {
            Icon icon;
            String screenTitle;
            JPanel screenUI;
            JToolBar rightDecoration = null;
            switch (screen) {
                default: {
                    screenUI = new DbManagerUI(this.ui);
                    screenTitle = I18n._((String)"tutti.title.manageDb", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuActionManageDb().getIcon();
                    break;
                }
                case SELECT_CRUISE: {
                    screenUI = new SelectCruiseUI(this.ui);
                    screenTitle = I18n._((String)"tutti.title.home", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuActionSelectCruise().getIcon();
                    break;
                }
                case EDIT_PROGRAM: {
                    screenTitle = EditProgramUIHandler.getTitle(this.context.isProgramFilled());
                    screenUI = new EditProgramUI(this.ui);
                    icon = ((MainUI)this.ui).getMenuActionEditProgram().getIcon();
                    break;
                }
                case EDIT_CRUISE: {
                    screenTitle = EditCruiseUIHandler.getTitle(this.context.isCruiseFilled());
                    screenUI = new EditCruiseUI(this.ui);
                    rightDecoration = ((EditCruiseUI)screenUI).getTopToolBar();
                    icon = ((MainUI)this.ui).getMenuActionEditCruise().getIcon();
                    break;
                }
                case EDIT_PROTOCOL: {
                    screenTitle = EditProtocolUIHandler.getTitle(this.context.isProtocolFilled());
                    screenUI = new EditProtocolUI(this.ui);
                    icon = ((MainUI)this.ui).getMenuActionEditProtocol().getIcon();
                    break;
                }
                case EDIT_FISHING_OPERATION: {
                    String validationContext = this.context.getValidationContext();
                    if ("edit".equals(validationContext)) {
                        screenTitle = I18n._((String)"tutti.title.edit.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()});
                        icon = ((MainUI)this.ui).getMenuActionEditCatches().getIcon();
                    } else {
                        screenTitle = I18n._((String)"tutti.title.validate.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()});
                        icon = ((MainUI)this.ui).getMenuActionValidateCatches().getIcon();
                    }
                    screenUI = new FishingOperationsUI(this.ui);
                    break;
                }
                case IMPORT_TEMPORARY_REFERENTIAL: {
                    screenTitle = I18n._((String)"tutti.title.import.temporary.referential", (Object[])new Object[0]);
                    screenUI = new ManageTemporaryReferentialUI(this.ui);
                    icon = ((MainUI)this.ui).getMenuImportTemporaryReferential().getIcon();
                }
            }
            JButton showHelp = ((MainUI)this.ui).getShowHelp();
            if (rightDecoration == null) {
                rightDecoration = new JToolBar();
                rightDecoration.setFloatable(false);
                rightDecoration.setOpaque(false);
                rightDecoration.setBorderPainted(false);
            } else {
                rightDecoration.remove(showHelp);
            }
            rightDecoration.add((Component)showHelp, 0);
            this.currentBody = screenUI;
            this.context.getSwingSession().add((Component)this.currentBody);
            ((MainUI)this.ui).getBody().setTitle(screenTitle);
            ((MainUI)this.ui).getBody().add((Component)this.currentBody);
            ((MainUI)this.ui).getBody().setLeftDecoration((JComponent)new JLabel(icon));
            ((MainUI)this.ui).getBody().setRightDecoration((JComponent)rightDecoration);
        }
    }

    public void changeTitle() {
        String title = this.getSelectedCruiseTitle();
        ((MainUI)this.ui).setTitle("Tutti - v " + this.getConfig().getVersion() + " [ " + title + " ]");
    }

    protected String getSelectedCruiseTitle() {
        String title;
        if (this.context.isDbLoaded()) {
            if (this.context.isProgramFilled()) {
                Program program = this.getDataContext().getProgram();
                title = I18n._((String)"tutti.title.selectedProgram", (Object[])new Object[]{program.getName()}) + " / ";
                if (this.context.isCruiseFilled()) {
                    Cruise cruise = this.getDataContext().getCruise();
                    if (cruise != null) {
                        title = title + I18n._((String)"tutti.title.selectedCruise", (Object[])new Object[]{cruise.getName()});
                    }
                } else {
                    title = title + I18n._((String)"tutti.title.noSelectedCruise", (Object[])new Object[0]);
                }
                title = title + " / ";
                if (this.context.isProtocolFilled()) {
                    TuttiProtocol protocol = this.getDataContext().getProtocol();
                    title = title + I18n._((String)"tutti.title.selectedProtocol", (Object[])new Object[]{protocol.getName()});
                } else {
                    title = title + I18n._((String)"tutti.title.noSelectedProtocol", (Object[])new Object[0]);
                }
            } else {
                title = I18n._((String)"tutti.title.noSelectedProgram", (Object[])new Object[0]);
            }
        } else {
            title = I18n._((String)"tutti.title.nodb", (Object[])new Object[0]);
        }
        return title;
    }

    public void setBodyTitle(String title) {
        ((MainUI)this.ui).getBody().setTitle(title);
    }
}

