/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.awt.Point;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.SwingUtil;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.i18n.I18n;

public class ButtonAttachment
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    protected final AttachmentEditorUI popup;
    private transient PropertyChangeListener listenAttachmentsChanged;
    protected Point popupPosition = null;
    protected boolean popupMoving;

    public ButtonAttachment(TuttiUIContext context, AttachmentModelAware model) {
        this.setIcon(SwingUtil.createActionIcon((String)"edit-attachment"));
        this.setToolTipText(I18n._((String)"tutti.action.attachments.tip", (Object[])new Object[0]));
        this.popup = new AttachmentEditorUI(context);
        this.popup.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ButtonAttachment.this.setSelected(true);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ButtonAttachment.this.setSelected(false);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                ButtonAttachment.this.setSelected(false);
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ButtonAttachment.this.isSelected()) {
                    ButtonAttachment.this.popup.openEditor(ButtonAttachment.this);
                } else {
                    ButtonAttachment.this.popup.closeEditor();
                }
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (ButtonAttachment.this.popup.isShowing()) {
                    Point point = new Point(ButtonAttachment.this.getLocationOnScreen());
                    point.translate(-ButtonAttachment.this.popup.getWidth() + ButtonAttachment.this.getWidth(), ButtonAttachment.this.getHeight());
                    ButtonAttachment.this.popupMoving = true;
                    try {
                        ButtonAttachment.this.popup.setLocation(point);
                    }
                    finally {
                        ButtonAttachment.this.popupMoving = false;
                    }
                }
            }
        });
        this.setBean(model);
    }

    public static String getButtonText(List<Attachment> attachment) {
        return I18n._((String)"tutti.action.attachments", (Object[])new Object[]{attachment.size()});
    }

    public void init() {
        this.popup.getHandler().init();
    }

    public void init(AttachmentModelAware model) {
        this.setBean(model);
        this.init();
    }

    public void onCloseUI() {
        this.setSelected(false);
    }

    public AttachmentModelAware getBean() {
        return this.popup.getBean();
    }

    protected void setBean(AttachmentModelAware model) {
        AttachmentModelAware bean = this.popup.getBean();
        if (bean != null) {
            ((AbstractSerializableBean)bean).removePropertyChangeListener("attachment", this.getListenAttachmentsChanged());
        }
        this.popup.setBean(model);
        if (model != null) {
            ((AbstractSerializableBean)model).addPropertyChangeListener("attachment", this.getListenAttachmentsChanged());
            List<Attachment> attachment = model.getAttachment();
            this.setText(ButtonAttachment.getButtonText(attachment));
        }
    }

    protected PropertyChangeListener getListenAttachmentsChanged() {
        if (this.listenAttachmentsChanged == null) {
            this.listenAttachmentsChanged = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    List attachment = (List)evt.getNewValue();
                    ButtonAttachment.this.setText(ButtonAttachment.getButtonText(attachment));
                    if (!ButtonAttachment.this.popup.isVisible()) {
                        ButtonAttachment.this.init();
                    }
                }
            };
        }
        return this.listenAttachmentsChanged;
    }
}

