/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportTemporaryGearExampleAction
extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ExportTemporaryGearExampleAction.class);
    private File file;

    public ExportTemporaryGearExampleAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.exportTemporaryGearExampleFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseReferentialGearFile", (Object[])new Object[0]), "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
            if (this.file == null) {
                doAction = false;
            } else {
                this.file = TuttiIOUtil.addExtensionIfMissing(this.file, ".csv");
                doAction = ((ManageTemporaryReferentialUIHandler)this.getHandler()).askOverwriteFile(this.file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export example gears temporary referential to file: " + this.file));
        }
        TuttiReferentialImportExportService service = this.getContext().getTuttiReferentialImportExportService();
        service.exportTemporaryGearExample(this.file);
        this.sendMessage("Exemple de r\u00e9f\u00e9rentiel temporaire d'engins export\u00e9 dans le fichier " + this.file + ".");
    }
}

