/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.administration.user;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.user.ManagedData;
import fr.ifremer.adagio.core.dao.administration.user.VesselManagePeriod;
import fr.ifremer.adagio.core.dao.administration.user.VesselManagePeriodDao;
import fr.ifremer.adagio.core.dao.administration.user.VesselManagePeriodImpl;
import fr.ifremer.adagio.core.dao.administration.user.VesselManagePeriodPK;
import fr.ifremer.adagio.core.dao.referential.vessel.Vessel;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class VesselManagePeriodDaoBase
extends HibernateDaoSupport
implements VesselManagePeriodDao {
    @Override
    public Object load(int transform, Date startDateTime, Vessel vessel, ManagedData managedData) {
        VesselManagePeriodPK entityPk = new VesselManagePeriodPK();
        if (startDateTime == null) {
            throw new IllegalArgumentException("VesselManagePeriod.load - 'startDateTime' can not be null");
        }
        if (vessel == null) {
            throw new IllegalArgumentException("VesselManagePeriod.load - 'vessel' can not be null");
        }
        if (managedData == null) {
            throw new IllegalArgumentException("VesselManagePeriod.load - 'managedData' can not be null");
        }
        entityPk.setStartDateTime(startDateTime);
        entityPk.setVessel(vessel);
        entityPk.setManagedData(managedData);
        Object entity = this.getHibernateTemplate().get(VesselManagePeriodImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (VesselManagePeriod)entity);
    }

    @Override
    public VesselManagePeriod load(Date startDateTime, Vessel vessel, ManagedData managedData) {
        return (VesselManagePeriod)this.load(0, startDateTime, vessel, managedData);
    }

    @Override
    public Collection<VesselManagePeriod> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(VesselManagePeriodImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public VesselManagePeriod create(VesselManagePeriod vesselManagePeriod) {
        return (VesselManagePeriod)this.create(0, vesselManagePeriod);
    }

    @Override
    public Object create(int transform, VesselManagePeriod vesselManagePeriod) {
        if (vesselManagePeriod == null) {
            throw new IllegalArgumentException("VesselManagePeriod.create - 'vesselManagePeriod' can not be null");
        }
        this.getHibernateTemplate().save((Object)vesselManagePeriod);
        return this.transformEntity(transform, vesselManagePeriod);
    }

    @Override
    public Collection<VesselManagePeriod> create(Collection<VesselManagePeriod> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<VesselManagePeriod> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("VesselManagePeriod.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    VesselManagePeriodDaoBase.this.create(transform, (VesselManagePeriod)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public VesselManagePeriod create(Date startDateTime, Date endDateTime, Vessel vessel, ManagedData managedData) {
        return (VesselManagePeriod)this.create(0, startDateTime, endDateTime, vessel, managedData);
    }

    @Override
    public Object create(int transform, Date startDateTime, Date endDateTime, Vessel vessel, ManagedData managedData) {
        VesselManagePeriodImpl entity = new VesselManagePeriodImpl();
        VesselManagePeriodPK entityPk = new VesselManagePeriodPK();
        entity.setVesselManagePeriodPk(entityPk);
        entityPk.setStartDateTime(startDateTime);
        entity.setEndDateTime(endDateTime);
        entityPk.setVessel(vessel);
        entityPk.setManagedData(managedData);
        return this.create(transform, entity);
    }

    @Override
    public VesselManagePeriod create(ManagedData managedData, Date startDateTime, Vessel vessel) {
        return (VesselManagePeriod)this.create(0, managedData, startDateTime, vessel);
    }

    @Override
    public Object create(int transform, ManagedData managedData, Date startDateTime, Vessel vessel) {
        VesselManagePeriodImpl entity = new VesselManagePeriodImpl();
        VesselManagePeriodPK entityPk = new VesselManagePeriodPK();
        entity.setVesselManagePeriodPk(entityPk);
        entityPk.setManagedData(managedData);
        entityPk.setStartDateTime(startDateTime);
        entityPk.setVessel(vessel);
        return this.create(transform, entity);
    }

    @Override
    public void update(VesselManagePeriod vesselManagePeriod) {
        if (vesselManagePeriod == null) {
            throw new IllegalArgumentException("VesselManagePeriod.update - 'vesselManagePeriod' can not be null");
        }
        this.getHibernateTemplate().update((Object)vesselManagePeriod);
    }

    @Override
    public void update(final Collection<VesselManagePeriod> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("VesselManagePeriod.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    VesselManagePeriodDaoBase.this.update((VesselManagePeriod)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(VesselManagePeriod vesselManagePeriod) {
        if (vesselManagePeriod == null) {
            throw new IllegalArgumentException("VesselManagePeriod.remove - 'vesselManagePeriod' can not be null");
        }
        this.getHibernateTemplate().delete((Object)vesselManagePeriod);
    }

    @Override
    public void remove(Date startDateTime, Vessel vessel, ManagedData managedData) {
        VesselManagePeriodPK entityPk = new VesselManagePeriodPK();
        if (startDateTime == null) {
            throw new IllegalArgumentException("VesselManagePeriod.remove - 'startDateTime' can not be null");
        }
        entityPk.setStartDateTime(startDateTime);
        if (vessel == null) {
            throw new IllegalArgumentException("VesselManagePeriod.remove - 'vessel' can not be null");
        }
        entityPk.setVessel(vessel);
        if (managedData == null) {
            throw new IllegalArgumentException("VesselManagePeriod.remove - 'managedData' can not be null");
        }
        entityPk.setManagedData(managedData);
        VesselManagePeriod entity = this.load(startDateTime, vessel, managedData);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<VesselManagePeriod> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("VesselManagePeriod.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, VesselManagePeriod entity) {
        VesselManagePeriod target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected VesselManagePeriod toEntity(Object[] row) {
        VesselManagePeriod target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof VesselManagePeriod)) continue;
                target = (VesselManagePeriod)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), VesselManagePeriodImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), VesselManagePeriodImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<VesselManagePeriod> search(Search search) {
        return this.search(0, search);
    }
}

