/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget;

import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class JComboBoxAutoCompletionKit {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        String[] petStrings = new String[]{"Bird", "Cat", "Cot", "Dog", "Dog", "Dog1", "Dog2", "Dog3", "Dog4", "Dog5", "Dog6", "Dog7", "Dog", "Dog8", "Dog9", "Dog10", "Rabbit", "Pig"};
        JComboBox<String> combo = new JComboBox<String>(petStrings);
        combo.setRenderer(new TestCellRenderer());
        JComboBoxAutoCompletionKit.setAutoCompleted(combo);
        frame.getContentPane().add(combo);
        frame.setSize(800, 50);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static void setAutoCompleted(JComboBox comboBox) {
        AutoCompletionManager autoCompletionManager = new AutoCompletionManager(comboBox);
        AutoCompletionModelListener autoCompletionModelListener = new AutoCompletionModelListener(autoCompletionManager);
        AutoCompletionCellRenderer autoCompletionCellRenderer = new AutoCompletionCellRenderer(autoCompletionManager, comboBox.getRenderer());
        comboBox.setKeySelectionManager(autoCompletionManager);
        comboBox.getModel().addListDataListener(autoCompletionModelListener);
        comboBox.setRenderer(autoCompletionCellRenderer);
    }

    private static class AutoCompletionModelListener
    implements ListDataListener {
        private AutoCompletionManager _manager = null;

        public AutoCompletionModelListener(AutoCompletionManager manager) {
            this.setManager(manager);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.getManager().modelChanged();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.getManager().modelChanged();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.getManager().modelChanged();
        }

        protected AutoCompletionManager getManager() {
            return this._manager;
        }

        protected void setManager(AutoCompletionManager manager) {
            this._manager = manager;
        }
    }

    private static class AutoCompletionCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private ListCellRenderer _existingRenderer = null;
        private AutoCompletionManager _manager = null;

        public AutoCompletionCellRenderer(AutoCompletionManager manager, ListCellRenderer existingRenderer) {
            this.setManager(manager);
            this.setExistingRenderer(existingRenderer);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String prefix;
            Component component = this.getExistingRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null && (prefix = this.getManager().getPrefix()) != null && component instanceof JLabel) {
                JLabel label = (JLabel)component;
                if (value.toString().startsWith(prefix)) {
                    String text = label.getText();
                    text = "<html><font color=#ffffdd>" + prefix + "</font>" + text.substring(prefix.length()) + "</html>";
                    label.setText(text);
                }
            }
            return component;
        }

        protected AutoCompletionManager getManager() {
            return this._manager;
        }

        protected void setManager(AutoCompletionManager manager) {
            this._manager = manager;
        }

        protected ListCellRenderer getExistingRenderer() {
            return this._existingRenderer;
        }

        protected void setExistingRenderer(ListCellRenderer existingRenderer) {
            this._existingRenderer = existingRenderer;
        }
    }

    private static class TestCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private TestCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && component instanceof JLabel) {
                JLabel label = (JLabel)component;
                String text = label.getText();
                text = "J" + text;
                label.setText(text);
            }
            return component;
        }
    }

    private static class AutoCompletionManager
    implements JComboBox.KeySelectionManager {
        private static String EMPTY_PREFIX = "";
        private static int NO_SELECTION = -1;
        private JComboBox _comboBox = null;
        private int _currentSelection = NO_SELECTION;
        private String _prefix = EMPTY_PREFIX;

        public AutoCompletionManager(JComboBox comboBox) {
            this.setComboBox(comboBox);
        }

        public int selectionForKey(char key, ComboBoxModel model) {
            System.out.println("" + Integer.toString(key));
            if (key == '\b' && this.getPrefix().length() > 0 || Character.isLetterOrDigit(key)) {
                String prefix = this.getPrefix();
                prefix = key == '\b' && prefix.length() > 0 ? prefix.substring(0, prefix.length() - 1) : this.getPrefix() + key;
                this.setPrefix(prefix);
                boolean prefixedItemFound = false;
                for (int i = 0; i < model.getSize(); ++i) {
                    Object element = model.getElementAt(i);
                    if (!element.toString().startsWith(prefix)) continue;
                    this.setCurrentSelection(i);
                    prefixedItemFound = true;
                    break;
                }
                if (!prefixedItemFound) {
                    this.reset();
                }
                this.getComboBox().showPopup();
                model.setSelectedItem(null);
            }
            return this.getCurrentSelection();
        }

        public void reset() {
            this.setPrefix(EMPTY_PREFIX);
            this.setCurrentSelection(NO_SELECTION);
        }

        public void modelChanged() {
        }

        protected JComboBox getComboBox() {
            return this._comboBox;
        }

        protected void setComboBox(JComboBox comboBox) {
            this._comboBox = comboBox;
        }

        protected int getCurrentSelection() {
            return this._currentSelection;
        }

        protected void setCurrentSelection(int currentSelection) {
            this._currentSelection = currentSelection;
        }

        protected String getPrefix() {
            return this._prefix;
        }

        protected void setPrefix(String prefix) {
            this._prefix = prefix;
        }
    }
}

