/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.ezware.oxbow.swingbits.util.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportProtocolSpeciesAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ExportProtocolSpeciesAction.class);
    private File file;

    public ExportProtocolSpeciesAction(EditProtocolUIHandler handler) {
        super(handler, "export", I18n._((String)"tutti.action.exportProtocolSpecies", (Object[])new Object[0]), I18n._((String)"tutti.action.exportProtocolSpecies.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction() {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.protocolSpeciesExportFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseProtocolSpeciesFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
            if (this.file == null) {
                doAction = false;
            } else {
                this.file = TuttiIOUtil.addExtensionIfMissing(this.file, ".csv");
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export protocol species to file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        ArrayList protocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getRows()) {
            if (!row.isValid()) continue;
            protocols.add(row.toBean());
        }
        TuttiProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.exportProtocolSpecies(this.file, (List)protocols, model.getAllCaracteristic(), model.getAllReferentSpeciesByTaxonId());
        this.sendMessage(I18n._((String)"tutti.flash.information.species.exported.from.protocol", (Object[])new Object[]{this.file}));
    }
}

