/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.batch;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchQuickFix;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.tutti.persistence.service.BatchPersistenceService;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;

@Component(value="scientificCruiseCatchBatchValidator")
public class ScientificCruiseCatchBatchValidator
implements CatchBatchValidator {
    private static final Log log = LogFactory.getLog(ScientificCruiseCatchBatchValidator.class);
    @Autowired
    protected BatchPersistenceService batchService;
    @Autowired
    protected CatchBatchExtendDao catchBatchDao;
    @Autowired
    protected TuttiEnumerationFile enumeration;

    public boolean isEnable(CatchBatch catchBatch) {
        return catchBatch.getFishingOperation() != null;
    }

    public List<CatchBatchValidationError> validate(CatchBatch catchBatch) {
        ArrayList errors = Lists.newArrayList();
        this.validate(catchBatch.getChildBatchs(), errors, 1);
        return errors;
    }

    protected void validate(Collection<Batch> batchs, List<CatchBatchValidationError> errors, int treeLevel) {
        SortingBatch vracBatch = this.catchBatchDao.getSortingBatch(batchs, new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID});
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to validate Vrac batch model " + vracBatch));
        }
        if (vracBatch == null) {
            this.addError(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracNotFound", (Object[])new Object[0]), null);
        } else {
            SortingBatch speciesBatch = this.catchBatchDao.getSortingBatch(vracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
            if (speciesBatch == null) {
                this.addError(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesNotFound", (Object[])new Object[0]), null);
            } else {
                SortingBatch livingNotItemizedBatch;
                SortingBatch inertBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_INERT});
                if (inertBatch == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesInertNotFound", (Object[])new Object[0]));
                }
                if ((livingNotItemizedBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_LIFE})) == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesLifeNotFound", (Object[])new Object[0]));
                }
            }
            SortingBatch benthosBatch = this.catchBatchDao.getSortingBatch(vracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS});
            if (benthosBatch == null) {
                this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosNotFound", (Object[])new Object[0]));
            } else {
                SortingBatch livingNotItemizedBatch;
                SortingBatch inertBatch = this.catchBatchDao.getSortingBatch(benthosBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_INERT});
                if (inertBatch == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosInertNotFound", (Object[])new Object[0]));
                }
                if ((livingNotItemizedBatch = this.catchBatchDao.getSortingBatch(benthosBatch.getChildBatchs(), new Object[]{"referenceTaxonId", this.enumeration.REFERENCE_TAXON_ID_LIFE})) == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosLifeNotFound", (Object[])new Object[0]));
                }
            }
        }
        SortingBatch horsVracBatch = this.catchBatchDao.getSortingBatch(batchs, new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID});
        if (horsVracBatch == null) {
            this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracSpeciesNotFound", (Object[])new Object[0]));
        } else {
            SortingBatch benthosBatch;
            SortingBatch speciesBatch = this.catchBatchDao.getSortingBatch(horsVracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
            if (speciesBatch == null) {
                this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracSpeciesNotFound", (Object[])new Object[0]));
            }
            if ((benthosBatch = this.catchBatchDao.getSortingBatch(horsVracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS})) == null) {
                this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracBenthosNotFound", (Object[])new Object[0]));
            }
        }
        SortingBatch unsortedBatch = this.catchBatchDao.getSortingBatch(batchs, new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_UNSORTED_ID});
        if (unsortedBatch == null) {
            this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.unsortedNotFound", (Object[])new Object[0]));
        }
        if (vracBatch == null && horsVracBatch == null && unsortedBatch == null) {
            boolean allBatchHasSpecies = true;
            boolean allBatchHasVrac = true;
            boolean someBatchHasSortingMeasurement = false;
            for (Batch batch1 : batchs) {
                SortingBatch batch = (SortingBatch)batch1;
                if (batch.getReferenceTaxon() == null) {
                    allBatchHasSpecies = false;
                    break;
                }
                if (!allBatchHasVrac || batch.getSortingMeasurements() == null) continue;
                if (batch.getSortingMeasurements().size() > 1) {
                    allBatchHasVrac = false;
                    someBatchHasSortingMeasurement = true;
                    continue;
                }
                if (batch.getSortingMeasurements().size() != 1) continue;
                someBatchHasSortingMeasurement = true;
                SortingMeasurement sm = (SortingMeasurement)batch.getSortingMeasurements().iterator().next();
                if (this.enumeration.PMFM_ID_SORTED_UNSORTED.equals(sm.getPmfm().getId()) && sm.getQualitativeValue() != null && this.enumeration.QUALITATIVE_VRAC_ID.equals(sm.getQualitativeValue().getId())) continue;
                allBatchHasVrac = false;
            }
            if (allBatchHasSpecies && !someBatchHasSortingMeasurement) {
                errors.clear();
                this.addError(errors, I18n.n_((String)"tutti.persistence.batch.validation.onlySpeciesBatchStructure", (Object[])new Object[0]), new CatchBatchQuickFix(){

                    public CatchBatch repair(CatchBatch catchBatch) {
                        return ScientificCruiseCatchBatchValidator.this.repairHistoricalData(catchBatch, false);
                    }
                });
            } else if (allBatchHasSpecies && allBatchHasVrac) {
                errors.clear();
                this.addError(errors, I18n.n_((String)"tutti.persistence.batch.validation.onlySpeciesBatchStructure", (Object[])new Object[0]), new CatchBatchQuickFix(){

                    public CatchBatch repair(CatchBatch catchBatch) {
                        return ScientificCruiseCatchBatchValidator.this.repairHistoricalData(catchBatch, true);
                    }
                });
            }
        }
    }

    protected CatchBatch repairHistoricalData(CatchBatch catchBatch, boolean batchHasVracSortingMeasurement) {
        Preconditions.checkNotNull((Object)catchBatch);
        Preconditions.checkNotNull((Object)catchBatch.getId());
        Preconditions.checkNotNull((Object)catchBatch.getFishingOperation());
        Preconditions.checkNotNull((Object)catchBatch.getFishingOperation().getId());
        HashSet speciesBatchChilds = Sets.newHashSet();
        speciesBatchChilds.addAll(catchBatch.getChildBatchs());
        catchBatch.setChildBatchs(new HashSet());
        this.batchService.cleanEntity(catchBatch, true);
        SortingBatch speciesBatch = this.catchBatchDao.getSortingBatch(catchBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, "pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
        if (speciesBatch == null) {
            throw new DataIntegrityViolationException("Invalid batch tree format. Could not retrieve 'Vrac>Species' batch.");
        }
        for (Batch speciesBatchChild : speciesBatchChilds) {
            SortingBatch batch = (SortingBatch)speciesBatchChild;
            batch.setParentBatch((Batch)speciesBatch);
            if (batchHasVracSortingMeasurement) {
                SortingMeasurement sm = this.catchBatchDao.getSortingMeasurement(batch, this.enumeration.PMFM_ID_SORTED_UNSORTED, null, false);
                batch.getSortingMeasurements().remove(sm);
            }
            batch.setExhaustiveInventory(Boolean.TRUE);
            short rankOrder = (short)(batch.getRankOrder() + 2);
            batch.setRankOrder(Short.valueOf(rankOrder));
            if (batch.getComments() != null && "taxon".equals(batch.getComments())) {
                batch.setComments(null);
            }
            speciesBatch.getChildBatchs().add(batch);
        }
        this.catchBatchDao.update(catchBatch);
        return catchBatch;
    }

    protected void addError(List<CatchBatchValidationError> errors, String messageKey, CatchBatchQuickFix quickFix) {
        CatchBatchValidationError error = new CatchBatchValidationError(messageKey, I18n._((String)messageKey, (Object[])new Object[0]), 2);
        error.setQuickFixes((List)Lists.newArrayList((Object[])new CatchBatchQuickFix[]{quickFix}));
        errors.add(error);
    }

    protected void addWarning(List<CatchBatchValidationError> errors, String messageKey) {
        CatchBatchValidationError error = new CatchBatchValidationError(messageKey, I18n._((String)messageKey, (Object[])new Object[0]), 1);
        errors.add(error);
    }
}

