/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential;

import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportTemporaryGearAction
extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ImportTemporaryGearAction.class);
    private File file;

    public ImportTemporaryGearAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, "importTemporaryGear", "import", I18n._((String)"tutti.action.importTemporaryGear", (Object[])new Object[0]), I18n._((String)"tutti.action.importTemporaryGear.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean doAction;
        this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.importTemporaryGearFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseReferentialGearFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
        boolean bl = doAction = this.file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        this.file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import gear temporary referential from file: " + this.file));
        }
        TuttiReferentialImportExportService service = this.getService(TuttiReferentialImportExportService.class);
        service.importTemporaryGear(this.file);
        this.sendMessage("R\u00e9f\u00e9rentiel temporaire d'engins import\u00e9 depuis le fichier " + this.file + ".");
    }
}

