package fr.ifremer.tutti.ui.swing.content.referential;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportTemporaryVesselExampleAction.java 382 2013-02-10 14:59:07Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/referential/ExportTemporaryVesselExampleAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.service.referential.TuttiReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;
import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Export an example file of temporary species referential.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ExportTemporaryVesselExampleAction extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ExportTemporaryVesselExampleAction.class);

    private File file;

    public ExportTemporaryVesselExampleAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler,
              "exportTemporaryVesselExample",
              "export",
              _("tutti.action.exportTemporaryVesselExample"),
              _("tutti.action.exportTemporaryVesselExample.tip"),
              true
        );
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {

        // choose file to export
        file = TuttiUIUtil.chooseFile(
                getContext().getMainUI(),
                _("tutti.title.choose.exportTemporaryVesselExampleFile"),
                _("tutti.action.chooseReferentialVesselFile"),
                null,
                "^.*\\.csv", _("tutti.file.csv")
        );
        boolean doAction = file != null;
        if (doAction) {
            super.prepareAction(event);
        }
        return doAction;
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        super.releaseAction(event);
        file = null;
    }

    @Override
    protected void doAction(ActionEvent e) throws Exception {

        if (log.isInfoEnabled()) {
            log.info("Will export example vessels temporary " +
                     "referential to file: " + file);
        }

        TuttiReferentialImportExportService service =
                getService(TuttiReferentialImportExportService.class);

        service.exportTemporaryVesselExample(file);

        sendMessage("Exemple de référentiel temporaire de navires exporté " +
                    "dans le fichier " + file + ".");
    }
}