package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id: CreateSpeciesBatchUIHandler.java 455 2013-02-22 17:47:32Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/split/CreateSpeciesBatchUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SelectSpeciesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.JAXXContextEntryDef;

/**
 * Handler of {@link CreateSpeciesBatchUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class CreateSpeciesBatchUIHandler extends AbstractTuttiUIHandler<CreateSpeciesBatchUIModel, CreateSpeciesBatchUI> implements Cancelable {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(CreateSpeciesBatchUIHandler.class);

    private final TuttiPersistence persistenceService;

    private final CaracteristicQualitativeValue sortedValue;

    public CreateSpeciesBatchUIHandler(TuttiUI parentUi,
                                       CreateSpeciesBatchUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        persistenceService = context.getService(PersistenceService.class);

        Caracteristic caracteristic =
                persistenceService.getSortedUnsortedCaracteristic();

        CaracteristicQualitativeValue v = null;
        for (CaracteristicQualitativeValue value : caracteristic.getQualitativeValue()) {
            if (persistenceService.isSortedQualitativeValue(value)) {
                v = value;
                break;
            }
        }
        sortedValue = v;
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInitUI() {
        CreateSpeciesBatchUIModel model = new CreateSpeciesBatchUIModel();
        ui.setContextValue(model);
        listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        boolean protocolFilled = context.isProtocolFilled();

        initBeanComboBox(ui.getSpeciesComboBox(),
                         Lists.<Species>newArrayList(),
                         null,
                         DecoratorService.getSpeciesContext(protocolFilled));

        Caracteristic caracteristic =
                persistenceService.getSortedUnsortedCaracteristic();

        initBeanComboBox(ui.getSortedUnsortedCategoryComboBox(),
                         caracteristic.getQualitativeValue(),
                         null);

        getModel().addPropertyChangeListener(CreateSpeciesBatchUIModel.PROPERTY_SPECIES, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {

                CreateSpeciesBatchUIModel source =
                        (CreateSpeciesBatchUIModel) evt.getSource();
                Species newValue = (Species) evt.getNewValue();

                if (log.isInfoEnabled()) {
                    log.info("New Selected species " + (newValue == null ? null : newValue.getRefTaxCode()));
                }

                if (newValue == null || source.getSpeciesUsed() == null) {

                    source.setSortedUnsortedCategory(null);

                } else {

                    // look for best value : if sorted is available then use it

                    List<CaracteristicQualitativeValue> qualitativeValues =
                            ui.getSortedUnsortedCategoryComboBox().getData();

                    CaracteristicQualitativeValue newCategory = null;

                    for (CaracteristicQualitativeValue qualitativeValue : qualitativeValues) {
                        if (source.isSpeciesAndCategoryAvailable(newValue, qualitativeValue)) {
                            newCategory = qualitativeValue;

                            if (newCategory.equals(sortedValue)) {
                                break;
                            }
                        }
                    }
                    source.setSortedUnsortedCategory(newCategory);
                }
            }
        });

//        SwingValidatorUtil.installUI(ui.getErrorTable(),
//                                     new SwingValidatorMessageTableRenderer());

        listenValidatorValid(ui.getValidator(), getModel());
    }

    @Override
    public void onCloseUI() {

        if (log.isInfoEnabled()) {
            log.info("closing: " + ui);
        }

        // evict model from validator
        ui.getValidator().setBean(null);

        // when canceling always invalid model
        getModel().setValid(false);

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        parent.getHandler().setSpeciesSelectedCard(EditCatchesUIHandler.MAIN_CARD);

    }

    @Override
    public SwingValidator<CreateSpeciesBatchUIModel> getValidator() {
        return ui.getValidator();
    }

    //------------------------------------------------------------------------//
    //-- Cancelable methods                                                 --//
    //------------------------------------------------------------------------//

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info("Cancel UI " + ui);
        }
        closeUI(ui);
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public void openUI(SpeciesBatchUIModel batchModel) {

        CreateSpeciesBatchUIModel model = getModel();

        // connect model to validator
        ui.getValidator().setBean(model);

        model.setSpecies(null);
        model.setSortedUnsortedCategory(null);
        model.setBatchWeight(null);

        List<Species> speciesToUse = Lists.newArrayList();

        Multimap<CaracteristicQualitativeValue, Species> speciesUsed =
                model.getSpeciesUsed();
        speciesUsed.clear();

        if (batchModel != null) {

            speciesUsed.putAll(batchModel.getSpeciesUsed());

            // compute which species can still be used

            List<Species> allSpecies = batchModel.getAllSpecies();

            speciesToUse.addAll(allSpecies);
        }

        model.setAvailableSpecies(speciesToUse);
        ui.getSpeciesComboBox().requestFocus();
    }

    public void save() {

        if (log.isInfoEnabled()) {
            log.info("Save UI " + ui);
        }

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        parent.getSpeciesTabContent().getHandler().addSpeciesBatch(getModel());

        // close dialog
        closeUI(ui);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialog = new SelectSpeciesUI(ui);
        SelectSpeciesUIModel model = dialog.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);

        openDialog(ui, dialog, title, new Dimension(400, 130));

        return model.getSelectedSpecies();
    }

}
