/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer;

import java.util.ArrayList;
import java.util.List;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceRecordsFinder {
    private static final Log log = LogFactory.getLog(ServiceRecordsFinder.class);
    private final int maximumNumberOfTryToConnect;
    private final Object lock;
    private final List<ServiceRecord> serviceRecords;

    public ServiceRecordsFinder(int maximumNumberOfTryToConnect, Object lock) {
        this.maximumNumberOfTryToConnect = maximumNumberOfTryToConnect;
        this.lock = lock;
        this.serviceRecords = new ArrayList<ServiceRecord>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceRecord> findServices(LocalDevice localDevice, RemoteDevice device, int serviceIndex) throws InterruptedException, BluetoothStateException {
        ServicesDiscoveryListener listener = new ServicesDiscoveryListener();
        for (int tryRound = 0; tryRound < this.maximumNumberOfTryToConnect && this.serviceRecords.isEmpty(); ++tryRound) {
            Object object = this.lock;
            synchronized (object) {
                int[] attrIDs = new int[]{256};
                if (log.isInfoEnabled()) {
                    log.info((Object)("Trying to get services (try " + tryRound + ")"));
                }
                localDevice.getDiscoveryAgent().searchServices(attrIDs, new UUID[]{new UUID((long)serviceIndex)}, device, (DiscoveryListener)listener);
                this.lock.wait();
                continue;
            }
        }
        return this.serviceRecords;
    }

    protected String getServiceName(ServiceRecord serviceRecord) {
        DataElement serviceName = serviceRecord.getAttributeValue(256);
        String result = serviceName == null ? null : String.valueOf(serviceName.getValue());
        return result;
    }

    protected class ServicesDiscoveryListener
    implements DiscoveryListener {
        protected ServicesDiscoveryListener() {
        }

        public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        }

        public void inquiryCompleted(int discType) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceSearchCompleted(int transID, int respCode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Service search completed!");
            }
            Object object = ServiceRecordsFinder.this.lock;
            synchronized (object) {
                ServiceRecordsFinder.this.lock.notifyAll();
            }
        }

        public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
            for (ServiceRecord aServRecord : servRecord) {
                String url = aServRecord.getConnectionURL(0, false);
                if (url == null) continue;
                ServiceRecordsFinder.this.serviceRecords.add(aServRecord);
                String serviceName = ServiceRecordsFinder.this.getServiceName(aServRecord);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("service found " + url + (serviceName == null ? "" : ", name: " + serviceName)));
            }
        }
    }
}

