/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer.interactive;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import fr.ifremer.tutti.ichtyometer.IchtyometerClient;
import fr.ifremer.tutti.ichtyometer.interactive.Command;
import fr.ifremer.tutti.ichtyometer.interactive.IchtyometerCommandException;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.microedition.io.StreamConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandEngine {
    private static final Log log = LogFactory.getLog(CommandEngine.class);
    protected IchtyometerClient client;
    protected StreamConnection connection;
    protected DataOutputStream dataOutputStream;
    protected DataInputStream dataInputStream;
    protected ExecutorService service;

    public void start(IchtyometerClient client) throws IOException {
        Preconditions.checkNotNull((Object)client, (Object)"client can not be null");
        Preconditions.checkState((boolean)client.isOpen(), (Object)"client must be opened");
        this.client = client;
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.connection = client.openConnection();
        this.dataInputStream = this.connection.openDataInputStream();
        this.dataOutputStream = this.connection.openDataOutputStream();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Ready to read remote device...");
        }
    }

    public void stop() throws IOException {
        Closeables.close((Closeable)this.dataInputStream, (boolean)true);
        Closeables.close((Closeable)this.dataOutputStream, (boolean)true);
        Closeables.close((Closeable)this.client, (boolean)true);
    }

    public Command sendCommand(char question) throws IOException {
        Preconditions.checkNotNull((Object)Character.valueOf(question), (Object)"command can not be null");
        CommandCallable call = new CommandCallable(question, this.dataInputStream, this.dataOutputStream);
        Future<Command> submit = this.service.submit(call);
        try {
            Command result = submit.get(1L, TimeUnit.MINUTES);
            return result;
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IchtyometerCommandException("Time out on command " + question, e);
        }
        catch (ExecutionException e) {
            throw new IchtyometerCommandException(e.getCause());
        }
    }

    protected static class CommandCallable
    implements Callable<Command> {
        protected char question;
        protected DataInputStream dataInputStream;
        protected DataOutputStream dataOutputStream;

        protected CommandCallable(char question, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
            this.question = question;
            this.dataInputStream = dataInputStream;
            this.dataOutputStream = dataOutputStream;
        }

        @Override
        public Command call() throws Exception {
            boolean responseComplete;
            this.dataOutputStream.writeChar(this.question);
            StringBuilder responseBuilder = new StringBuilder();
            boolean bl = responseComplete = this.question == 'g';
            while (!responseComplete) {
                block5: while (this.dataInputStream.available() > 0) {
                    int c = this.dataInputStream.read();
                    switch (c) {
                        case 13: {
                            responseBuilder.append('\n');
                            continue block5;
                        }
                        case 64: {
                            responseComplete = true;
                            continue block5;
                        }
                    }
                    responseBuilder.append((char)c);
                }
            }
            String response = responseBuilder.toString();
            Command result = new Command(this.question, response, null);
            return result;
        }
    }
}

