/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer.interactive;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import fr.ifremer.tutti.ichtyometer.IchtyometerClient;
import fr.ifremer.tutti.ichtyometer.interactive.Command;
import fr.ifremer.tutti.ichtyometer.interactive.IchtyometerCommandException;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.microedition.io.StreamConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandEngine {
    private static final Log log = LogFactory.getLog(CommandEngine.class);
    protected IchtyometerClient client;
    protected StreamConnection connection;
    protected DataOutputStream dataOutputStream;
    protected DataInputStream dataInputStream;
    protected ExecutorService service;

    public void start(IchtyometerClient client) throws IOException {
        Preconditions.checkNotNull((Object)client, (Object)"client can not be null");
        Preconditions.checkState((boolean)client.isOpen(), (Object)"client must be opened");
        this.client = client;
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.connection = client.openConnection();
        this.dataInputStream = this.connection.openDataInputStream();
        this.dataOutputStream = this.connection.openDataOutputStream();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Ready to read remote device...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        try {
            if (this.client != null && this.connection != null) {
                this.client.closeConnection(this.connection);
            }
        }
        finally {
            if (this.client != null) {
                Closeables.close((Closeable)this.client, (boolean)true);
            }
        }
    }

    public Command sendCommand(char question) throws IOException {
        Preconditions.checkNotNull((Object)Character.valueOf(question), (Object)"command can not be null");
        CommandCallable call = new CommandCallable(question, this.dataInputStream, this.dataOutputStream);
        Future<Command> submit = this.service.submit(call);
        try {
            Command result = submit.get(30L, TimeUnit.SECONDS);
            return result;
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IchtyometerCommandException("Time out on command " + question, e);
        }
        catch (ExecutionException e) {
            throw new IchtyometerCommandException(e.getCause());
        }
    }

    protected static class CommandCallable
    implements Callable<Command> {
        protected Set<Character> questionsWithNoEndLines = Sets.newHashSet((Object[])new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('g')});
        protected char question;
        protected DataInputStream dataInputStream;
        protected DataOutputStream dataOutputStream;

        protected CommandCallable(char question, DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
            this.question = question;
            this.dataInputStream = dataInputStream;
            this.dataOutputStream = dataOutputStream;
        }

        @Override
        public Command call() throws Exception {
            boolean responseComplete;
            this.dataOutputStream.writeChar(this.question);
            StringBuilder responseBuilder = new StringBuilder();
            boolean bl = responseComplete = 'g' == this.question;
            while (!responseComplete) {
                block10: {
                    while (this.dataInputStream.available() > 0) {
                        int c = this.dataInputStream.read();
                        if (c == 13) {
                            block9: {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {
                                    if (!log.isDebugEnabled()) break block9;
                                    log.debug((Object)"Cant wait...");
                                }
                            }
                            boolean bl2 = responseComplete = this.dataInputStream.available() == 0;
                            if (responseComplete) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"No more data to read after 0.1s, response is complete");
                                continue;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Will start to read a new line");
                            }
                            responseBuilder.append('\n');
                            continue;
                        }
                        responseBuilder.append((char)c);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        if (!log.isDebugEnabled()) break block10;
                        log.debug((Object)"Cant wait...");
                    }
                }
                if (responseComplete || this.dataInputStream.available() != 0 || responseBuilder.length() <= 0 || !this.questionsWithNoEndLines.contains(Character.valueOf(this.question))) continue;
                responseComplete = true;
            }
            String response = responseBuilder.toString();
            Command result = new Command(this.question, response, null);
            return result;
        }
    }
}

