/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.vcs;

import fr.ifremer.isisfish.vcs.VCS;
import fr.ifremer.isisfish.vcs.VCSActionEvent;
import fr.ifremer.isisfish.vcs.VCSException;
import fr.ifremer.isisfish.vcs.VetoableActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractVCS
implements VCS {
    private static Log log = LogFactory.getLog(AbstractVCS.class);
    protected Set<VetoableActionListener> listeners = new HashSet<VetoableActionListener>();
    protected File localRepository;
    protected String protocol;
    protected String host;
    protected String path;
    protected File sshKeyFile;
    protected String login;
    protected String password;
    protected boolean writeable = true;

    public AbstractVCS(File localRepository, String protocol, String host, String path, File sshKeyFile, String login, String password) {
        this.localRepository = localRepository;
        this.protocol = protocol;
        this.host = host;
        this.path = path;
        this.sshKeyFile = sshKeyFile;
        this.login = login;
        this.password = password;
    }

    @Override
    public void addVetoableActionListener(VetoableActionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void remoteVetoableActionListener(VetoableActionListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setWriteable(boolean value) {
        this.writeable = value;
    }

    protected boolean fireAction(VCSActionEvent e, File ... files) {
        boolean result = true;
        if (this.listeners.size() > 0) {
            VetoableActionListener[] ls;
            for (VetoableActionListener l : ls = this.listeners.toArray(new VetoableActionListener[0])) {
                boolean bl = result = result && l.canDoAction(this, e, files);
                if (!result) break;
            }
        }
        if (!result) {
            log.info((Object)("Canceled action: " + String.valueOf((Object)e)));
        }
        return result;
    }

    @Override
    public File getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(File localRepository) {
        this.localRepository = localRepository;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) throws VCSException {
        this.protocol = protocol;
        this.checkProtocol();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) throws VCSException {
        this.host = host;
        this.checkProtocol();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) throws VCSException {
        this.path = path;
        this.checkProtocol();
    }

    @Override
    public File getSshKeyFile() {
        return this.sshKeyFile;
    }

    @Override
    public void setSshKeyFile(File sshKeyFile) {
        this.sshKeyFile = sshKeyFile;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(String login) throws VCSException {
        this.login = login;
        this.checkProtocol();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean accept(File pathname) {
        return this.isVersionnableFile(pathname);
    }

    @Override
    public boolean isVersionnableFile(File file) {
        String filename = file.getName();
        return !".svn".equals(filename) && !"CVS".equals(filename) && !filename.endsWith("~") && file.getAbsolutePath().startsWith(this.getLocalRepository().getAbsolutePath());
    }
}

