/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.config;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.config.IsisAction;
import fr.ifremer.isisfish.config.Option;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.util.cache.IsisCacheBackend;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.Vector;
import org.nuiton.util.StringUtil;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;

public class IsisConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(IsisConfig.class);
    public static final int ISIS_FISH_MAJOR_VERSION = 4;
    public static final int STEP_AFTER_INIT = 0;
    public static final int STEP_AFTER_INIT_VCS = 1;
    public static final int STEP_AFTER_UI = 2;
    public static final int STEP_BEFORE_EXIT = 3;
    protected static Version version;
    protected static Version databaseVersion;
    protected static Version apiVersion;
    public static final String COMPRESSION_EXTENSION = ".gz";
    public static final String SEP = ",";
    protected long startingTime = System.currentTimeMillis();
    public static File currentTempDirectory;

    public static String getVersion() {
        String result = version.toString();
        return result;
    }

    public static Version getDatabaseVersion() {
        return databaseVersion;
    }

    public static Version getApiVersion() {
        return apiVersion;
    }

    public IsisConfig() {
        for (Option option : Option.values()) {
            if (option.defaultValue == null) continue;
            this.setDefaultOption(option.key, option.defaultValue);
        }
        for (Enum enum_ : IsisAction.values()) {
            for (String alias : ((IsisAction)enum_).aliases) {
                this.addActionAlias(alias, ((IsisAction)enum_).action);
            }
        }
    }

    public static String getEnvUserHome() {
        String result = ApplicationConfig.getUserHome();
        if (log.isInfoEnabled()) {
            log.info((Object)("Using user home : " + result));
        }
        return result;
    }

    public ApplicationConfig parse(String ... args) throws ArgumentsParserException {
        ApplicationConfig config = super.parse(args);
        this.postInitWithVersion(config.getOption("isisfish.version"));
        return config;
    }

    protected void postInitWithVersion(String fullVersion) {
        version = Versions.valueOf((String)fullVersion);
        databaseVersion = Versions.extractVersion((Version)version, (int)0, (int)1);
        apiVersion = Versions.extractVersion((Version)version, (int)0, (int)2);
        this.setDefaultOption(Option.SIMULATOR_DATARMOR_SSH_ISISHOME.key, "/appli/emh-commun/isis-fish/isis-fish-" + apiVersion.toString());
    }

    public String getIsisHomeDirectory() {
        String result = this.getOption(Option.ISIS_HOME_DIRECTORY.key);
        return result;
    }

    public void setIsisHomeDirectory(String homeDirectory) {
        this.setOption(Option.ISIS_HOME_DIRECTORY.key, homeDirectory);
    }

    public File getDatabaseDirectory() {
        File result = this.getOptionAsFile(Option.DATABASE_DIRECTORY.key);
        return result;
    }

    public File getCommunityDatabaseDirectory() {
        File result = this.getOptionAsFile(Option.COMMUNITY_DATABASE_DIRECTORY.key);
        return result;
    }

    public File getContextDatabaseDirectory() {
        SimulationContext simContext = SimulationContext.get();
        File scriptDirectory = simContext.getScriptDirectory();
        if (scriptDirectory == null) {
            scriptDirectory = this.getDatabaseDirectory();
        }
        return scriptDirectory;
    }

    public String getDatabaseLockMode() {
        String result = this.getOption(Option.DATABASE_LOCK_MODE.key);
        return result;
    }

    public File getCompileDirectory() {
        File result = this.getOptionAsFile(Option.COMPILATION_DIRECTORY.key);
        SimulationContext simContext = SimulationContext.get();
        SimulationControl control = simContext.getSimulationControl();
        if (control != null) {
            result = this.getOptionAsFile(Option.COMPILATION_SIM_DIRECTORY.key);
            result = new File(result, control.getId());
        }
        return result;
    }

    public File getRegionCacheDirectory() {
        File result = this.getOptionAsFile(Option.REGION_CACHE_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getMonitoringDirectory() {
        File result = this.getOptionAsFile(Option.MONITORING_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getJavadocDirectory() {
        File result = this.getOptionAsFile(Option.JAVADOC_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getCurrentTempDirectory() {
        String yyyyMMddHHmmss;
        File tempDirectory;
        if (currentTempDirectory == null && !(currentTempDirectory = new File(tempDirectory = this.getOptionAsFile(Option.TEMP_DIRECTORY.key), "tmp-" + (yyyyMMddHHmmss = DateFormatUtils.format((long)this.startingTime, (String)"yyyyMMddHHmmss")) + "-" + RandomUtils.nextInt())).exists()) {
            currentTempDirectory.mkdirs();
        }
        return currentTempDirectory;
    }

    public static void clearCurrentTempDirectory() {
        currentTempDirectory = null;
    }

    public File getLogDirectory() {
        File result = this.getOptionAsFile(Option.LOG_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getSwingSessionFile() {
        File result = this.getOptionAsFile(Option.SWING_SESSION_FILE.key);
        return result;
    }

    public Locale getLocale() {
        String value = this.getOption(Option.LOCALE.key);
        Locale result = (Locale)ConvertUtils.convert((String)value, Locale.class);
        return result;
    }

    public void setLocale(String locale) {
        this.setOption(Option.LOCALE.key, locale);
    }

    public String getEncoding() {
        String result = this.getOption(Option.ENCODING.key);
        return result;
    }

    public String getUserName() {
        String result = this.getOption(Option.USER_NAME.key);
        return result;
    }

    public String getUserMail() {
        String result = this.getOption(Option.USER_MAIL.key);
        return result;
    }

    public String getSimulatorClassfile() {
        String result = this.getOption(Option.SIMULATOR_CLASSFILE.key);
        return result;
    }

    public void setSimulatorClassfile(String value) {
        this.setOption(Option.SIMULATOR_CLASSFILE.key, value);
    }

    public int getSimulatorInMaxThreads() {
        int result = this.getOptionAsInt(Option.SIMULATOR_IN_MAXTHREADS.key);
        return result;
    }

    public void setSimulatorInMaxThreads(int value) {
        this.setOption(Option.SIMULATOR_IN_MAXTHREADS.key, String.valueOf(value));
    }

    public int getSimulatorSubMaxProcess() {
        int result = this.getOptionAsInt(Option.SIMULATOR_SUB_MAXPROCESS.key);
        return result;
    }

    public void setSimulatorSubMaxProcess(int value) {
        this.setOption(Option.SIMULATOR_SUB_MAXPROCESS.key, String.valueOf(value));
    }

    public String getSimulatorSubMaxMemory() {
        String result = this.getOption(Option.SIMULATOR_SUB_MAXMEMORY.key);
        return result;
    }

    public void setSimulatorSubMaxMemory(String value) {
        this.setOption(Option.SIMULATOR_SUB_MAXMEMORY.key, value);
    }

    public String getSimulatorSshServer() {
        String result = this.getOption(Option.SIMULATOR_DATARMOR_SSH_SERVER.key);
        return result;
    }

    public void setSimulatorSshServer(String sshServer) {
        this.setOption(Option.SIMULATOR_DATARMOR_SSH_SERVER.key, sshServer);
    }

    public String getSimulatorSshUsername() {
        String result = this.getOption(Option.SIMULATOR_DATARMOR_SSH_USERNAME.key);
        return result;
    }

    public void setSimulatorSshUsername(String username) {
        this.setOption(Option.SIMULATOR_DATARMOR_SSH_USERNAME.key, username);
    }

    public String getSimulatorSshIsisHome() {
        String result = this.getOption(Option.SIMULATOR_DATARMOR_SSH_ISISHOME.key);
        return result;
    }

    public void setSimulatorSshIsisHome(String isishome) {
        this.setOption(Option.SIMULATOR_DATARMOR_SSH_ISISHOME.key, isishome);
    }

    public String getSimulatorSshPbsQsubOptions() {
        String result = this.getOption(Option.SIMULATOR_DATARMOR_QSUB_OPTIONS.key);
        return result;
    }

    public void setSimulatorSshPbsQsubOptions(String options) {
        this.setOption(Option.SIMULATOR_DATARMOR_QSUB_OPTIONS.key, options);
    }

    public String getSimulatorSshJavaPath() {
        String result = this.getOption(Option.SIMULATOR_DATARMOR_SSH_JAVAPATH.key);
        return result;
    }

    public void setSimulatorSshJavaPath(String path) {
        this.setOption(Option.SIMULATOR_DATARMOR_SSH_JAVAPATH.key, path);
    }

    public int getSimulatorSshControlCheckInterval() {
        int result = this.getOptionAsInt(Option.SIMULATOR_DATARMOR_SSH_CONTROLCHECKINTERVAL.key);
        return result;
    }

    public void setSimulatorSshControlCheckInterval(int interval) {
        this.setOption(Option.SIMULATOR_DATARMOR_SSH_CONTROLCHECKINTERVAL.key, String.valueOf(interval));
    }

    public int getSimulatorSshMaxThreads() {
        int result = this.getOptionAsInt(Option.SIMULATOR_DATARMOR_MAXTHREADS.key);
        return result;
    }

    public void setSimulatorSshMaxThreads(int max) {
        this.setOption(Option.SIMULATOR_DATARMOR_MAXTHREADS.key, String.valueOf(max));
    }

    public String getSimulatorSshMaxMemory() {
        String result = this.getOption(Option.SIMULATOR_DATARMOR_MAXMEMORY.key);
        return result;
    }

    public void setSimulatorSshMaxMemory(String memory) {
        this.setOption(Option.SIMULATOR_DATARMOR_MAXMEMORY.key, memory);
    }

    public String getSimulatorFtpServer() {
        String result = this.getOption(Option.SIMULATOR_DATARMOR_FTP_SERVER.key);
        return result;
    }

    public void setSimulatorFtpServer(String value) {
        this.setOption(Option.SIMULATOR_DATARMOR_FTP_SERVER.key, value);
    }

    public String getSimulatorFtpLogin() {
        String result = this.getOption(Option.SIMULATOR_DATARMOR_FTP_LOGIN.key);
        return result;
    }

    public void setSimulatorFtpLogin(String value) {
        this.setOption(Option.SIMULATOR_DATARMOR_FTP_LOGIN.key, value);
    }

    public String getSimulatorFtpPassword() {
        String result = this.getOption(Option.SIMULATOR_DATARMOR_FTP_PASSWORD.key);
        return result;
    }

    public void setSimulatorFtpPassword(String value) {
        this.setOption(Option.SIMULATOR_DATARMOR_FTP_PASSWORD.key, value);
    }

    public File getSSHPrivateKeyFilePath() {
        File result = this.getOptionAsFile(Option.SSH_KEY_FILE.key);
        return result;
    }

    public void setSSHPrivateKeyFilePath(File sshFile) {
        if (sshFile == null) {
            this.setOption(Option.SSH_KEY_FILE.key, null);
        } else {
            this.setOption(Option.SSH_KEY_FILE.key, sshFile.getAbsolutePath());
        }
    }

    public boolean isLaunchUI() {
        boolean result = this.getOptionAsBoolean(Option.LAUNCH_UI.key);
        return result;
    }

    public boolean isPerformVcsUpdate() {
        boolean result = this.getOptionAsBoolean(Option.PERFORM_VCS_UPDATE.key);
        return result;
    }

    public boolean isPerformCron() {
        boolean result = this.getOptionAsBoolean(Option.PERFORM_CRON.key);
        return result;
    }

    public boolean isScriptAutoconfig() {
        boolean result = this.getOptionAsBoolean(Option.SIMULATION_SCRIPT_AUTOCONFIG.key);
        return result;
    }

    public String getDefaultExportNames() {
        String result = this.getOption(Option.DEFAULT_EXPORT_NAMES.key);
        return result;
    }

    public boolean getExportForceCompression() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        boolean result = config.getOptionAsBoolean(Option.EXPORT_FORCE_COMPRESSION.key);
        return result;
    }

    public void setExportForceCompression(boolean value) {
        this.setOption(Option.EXPORT_FORCE_COMPRESSION.key, String.valueOf(value));
    }

    public void setDefaultExportNames(List<String> exportNames) {
        StringBuilder sb = new StringBuilder();
        for (String exportName : exportNames) {
            sb.append(SEP).append(exportName);
        }
        String value = sb.toString();
        if (value.length() > 0) {
            value = value.substring(1);
        }
        this.setOption(Option.DEFAULT_EXPORT_NAMES.key, value);
        this.saveForUser(new String[0]);
    }

    public List<String> getDefaultExportNamesAsList() {
        ArrayList<String> result = null;
        String exportNamesList = this.getDefaultExportNames();
        if (exportNamesList != null) {
            String[] exportNames = StringUtil.split((String)exportNamesList, (String)SEP);
            result = new ArrayList<String>(Arrays.asList(exportNames));
        }
        return result;
    }

    public String getDefaultMapFilename() {
        String result = this.getOption(Option.DEFAULT_MAP_FILENAME.key);
        return result;
    }

    public String getDefaultResultNames() {
        String result = this.getOption(Option.DEFAULT_RESULT_NAMES.key);
        return result;
    }

    public void setDefaultResultNames(List<String> resultNames) {
        StringBuilder sb = new StringBuilder();
        for (String resultName : resultNames) {
            sb.append(SEP).append(resultName);
        }
        String value = sb.toString();
        if (value.length() > 0) {
            value = value.substring(1);
        }
        this.setOption(Option.DEFAULT_RESULT_NAMES.key, value);
        this.saveForUser(new String[0]);
    }

    public List<String> getDefaultResultNamesAsList() {
        ArrayList<String> result = null;
        String resultNamesList = this.getDefaultResultNames();
        if (resultNamesList != null) {
            String[] resultNames = StringUtil.split((String)resultNamesList, (String)SEP);
            result = new ArrayList<String>(Arrays.asList(resultNames));
        }
        return result;
    }

    public String getDefaultTagValue() {
        String result = this.getOption(Option.DEFAULT_TAG_VALUE.key);
        return result;
    }

    public void setDefaultTagValues(Map<String, String> tagValues) {
        StringBuilder sb = new StringBuilder(" ");
        for (Map.Entry<String, String> entry : tagValues.entrySet()) {
            sb.append(SEP).append('\"').append(entry.getKey()).append("\":\"").append(entry.getValue()).append('\"');
        }
        String value = sb.toString().trim();
        this.setOption(Option.DEFAULT_TAG_VALUE.key, value.isEmpty() ? "" : value.substring(1));
        this.saveForUser(new String[0]);
    }

    public Map<String, String> getDefaultSimulationConfig() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(Option.SIMULATION_MATRIX_VECTOR_CLASS.key, this.getOption(Option.SIMULATION_MATRIX_VECTOR_CLASS.key));
        result.put(Option.SIMULATION_MATRIX_VECTOR_SPARSE_CLASS.key, this.getOption(Option.SIMULATION_MATRIX_VECTOR_SPARSE_CLASS.key));
        result.put(Option.SIMULATION_MATRIX_THRESHOLD_USE_SPARSE_CLASS.key, this.getOption(Option.SIMULATION_MATRIX_THRESHOLD_USE_SPARSE_CLASS.key));
        result.put(Option.SIMULATION_MATRIX_USE_LAZY_VECTOR.key, this.getOption(Option.SIMULATION_MATRIX_USE_LAZY_VECTOR.key));
        result.put(Option.SIMULATION_STORE_RESULT_ON_DISK.key, this.getOption(Option.SIMULATION_STORE_RESULT_ON_DISK.key));
        result.put(Option.SIMULATION_STORE_RESULT_CACHE_STEP.key, this.getOption(Option.SIMULATION_STORE_RESULT_CACHE_STEP.key));
        result.put(Option.CACHE_BACKEND_FACTORY_CLASS.key, this.getOption(Option.CACHE_BACKEND_FACTORY_CLASS.key));
        result.put(Option.EXPORT_FORCE_COMPRESSION.key, this.getOption(Option.EXPORT_FORCE_COMPRESSION.key));
        return result;
    }

    public Map<String, String> getDefaultTagValueAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        String tagValuesList = this.getDefaultTagValue();
        if (tagValuesList != null) {
            String[] tagValues;
            for (String tagValue : tagValues = StringUtil.split((String)tagValuesList, (String)SEP)) {
                String[] tagAndValue = StringUtil.split((String)tagValue, (String)":");
                String tag = tagAndValue[0].trim();
                tag = tag.substring(1, tag.length() - 1);
                String value = tagAndValue[1].trim();
                value = value.substring(1, value.length() - 1);
                result.put(tag, value);
            }
        }
        return result;
    }

    public String getIsisFishURL() {
        String result = this.getOption(Option.ISIS_URL.key);
        return result;
    }

    public String getJavadocIsisURL() {
        String result = this.getOption(Option.JAVADOC_ISIS_URL.key);
        return result;
    }

    public String getJavadocMatrixURL() {
        String result = this.getOption(Option.JAVADOC_MATRIX_URL.key);
        return result;
    }

    public String getJavadocTopiaURL() {
        String result = this.getOption(Option.JAVADOC_TOPIA_URL.key);
        return result;
    }

    public String getJavadocJavaURL() {
        String result = this.getOption(Option.JAVADOC_JAVA_URL.key);
        return result;
    }

    public long getStartingTime() {
        return this.startingTime;
    }

    public String getElapsedTimeAsString() {
        long diff = System.currentTimeMillis() - this.getStartingTime();
        String result = DurationFormatUtils.formatDuration((long)diff, (String)"s'.'S");
        return result;
    }

    public ClassLoader getScriptClassLoader() {
        SimulationContext simContext = SimulationContext.get();
        ClassLoader result = simContext.getClassLoader();
        if (result == null) {
            URL[] cp = this.getScriptDirectoryURLs();
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            result = new URLClassLoader(cp, parent);
        }
        return result;
    }

    public URL[] getScriptDirectoryURLs() {
        URL[] cp;
        File f = this.getCompileDirectory();
        try {
            cp = new URL[]{f.toURI().toURL()};
        }
        catch (MalformedURLException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.load.classloader", (Object[])new Object[]{f, eee.getMessage()}), eee);
        }
        return cp;
    }

    public Class getMappedResultMatrixVectorClass() {
        Class result = this.getOptionAsClass(Option.MAPPED_RESULT_MATRIX_VECTOR_CLASS.key);
        return result;
    }

    public Class<Vector> getSimulationMatrixVectorClass() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        Class result = config.getOptionAsClass(Option.SIMULATION_MATRIX_VECTOR_CLASS.key);
        return result;
    }

    public void setSimulationMatrixVectorClass(Class<Vector> value) {
        this.setOption(Option.SIMULATION_MATRIX_VECTOR_CLASS.key, value.getName());
    }

    public Class<Vector> getSimulationMatrixVectorSparseClass() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        Class result = config.getOptionAsClass(Option.SIMULATION_MATRIX_VECTOR_SPARSE_CLASS.key);
        return result;
    }

    public void setSimulationMatrixVectorSparseClass(Class<Vector> value) {
        this.setOption(Option.SIMULATION_MATRIX_VECTOR_SPARSE_CLASS.key, value.getName());
    }

    public int getSimulationMatrixThresholdUseSparse() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        int result = config.getOptionAsInt(Option.SIMULATION_MATRIX_THRESHOLD_USE_SPARSE_CLASS.key);
        return result;
    }

    public void setSimulationMatrixThresholdUseSparse(int value) {
        this.setOption(Option.SIMULATION_MATRIX_THRESHOLD_USE_SPARSE_CLASS.key, String.valueOf(value));
    }

    public boolean getSimulationMatrixdUseLazyVector() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        boolean result = config.getOptionAsBoolean(Option.SIMULATION_MATRIX_USE_LAZY_VECTOR.key);
        return result;
    }

    public void setSimulationMatrixdUseLazyVector(boolean value) {
        this.setOption(Option.SIMULATION_MATRIX_USE_LAZY_VECTOR.key, String.valueOf(value));
    }

    public int getSimulationStoreResultOnDisk() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        int result = config.getOptionAsInt(Option.SIMULATION_STORE_RESULT_ON_DISK.key);
        return result;
    }

    public void setSimulationStoreResultOnDisk(int value) {
        this.setOption(Option.SIMULATION_STORE_RESULT_ON_DISK.key, String.valueOf(value));
    }

    public int getSimulationStoreResultCacheStep() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        int result = config.getOptionAsInt(Option.SIMULATION_STORE_RESULT_CACHE_STEP.key);
        return result;
    }

    public void setSimulationStoreResultCacheStep(int value) {
        this.setOption(Option.SIMULATION_STORE_RESULT_CACHE_STEP.key, String.valueOf(value));
    }

    public IsisCacheBackend.Factory getCacheBackendFactoryClass() {
        ApplicationConfig config = SimulationContext.get().getConfig();
        IsisCacheBackend.Factory result = (IsisCacheBackend.Factory)config.getOptionAsObject(IsisCacheBackend.Factory.class, Option.CACHE_BACKEND_FACTORY_CLASS.key);
        return result;
    }

    public String getVcsUserName() {
        String result = this.getOption(Option.VCS_USER_NAME.key);
        return result;
    }

    public void setVcsUserName(String value) {
        this.setOption(Option.VCS_USER_NAME.key, value);
    }

    public String getVcsUserPassword() {
        String result = this.getOption(Option.VCS_USER_PASSWORD.key);
        return result;
    }

    public void setVcsUserPassword(String value) {
        this.setOption(Option.VCS_USER_PASSWORD.key, value);
    }

    public String getVcsCommunityUserName() {
        String result = this.getOption(Option.VCS_COMMUNITY_USER_NAME.key);
        return result;
    }

    public void setVcsCommunityUserName(String value) {
        this.setOption(Option.VCS_COMMUNITY_USER_NAME.key, value);
    }

    public String getVcsCommunityUserPassword() {
        String result = this.getOption(Option.VCS_COMMUNITY_PASSWORD.key);
        return result;
    }

    public void setVcsCommunityUserPassword(String value) {
        this.setOption(Option.VCS_COMMUNITY_PASSWORD.key, value);
    }

    public String getBugReportUrl() {
        String result = this.getOption(Option.BUG_REPORT_URL.key);
        return result;
    }

    public String getKeystorePasswords() {
        String result = this.getOption(Option.KEYSTORE.key);
        return result;
    }

    public void setKeystorePasswords(String value) {
        this.setOption(Option.KEYSTORE.key, value);
    }

    public LocalDate getJavaVersionCheckDate() {
        String result = this.getOption(Option.JAVA_VERSION_CHECK_DATE.key);
        LocalDate localDate = null;
        if (StringUtils.isNotBlank((CharSequence)result)) {
            localDate = LocalDate.parse(result);
        }
        return localDate;
    }

    public void setJavaVersionCheckDate(LocalDate value) {
        this.setOption(Option.JAVA_VERSION_CHECK_DATE.key, String.valueOf(value));
    }
}

