/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import fr.ifremer.isisfish.util.ssh.InvalidPassphraseException;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.nuiton.i18n.I18n;

public class SSHAgent {
    protected JSch jsch = new JSch();
    protected Map<String, char[]> passphraseForKeys = new HashMap<String, char[]>();
    private static SSHAgent agent = new SSHAgent();

    private SSHAgent() {
    }

    public static SSHAgent getAgent() {
        return agent;
    }

    public char[] getPassphrase(File privatekeyFile) throws InvalidPassphraseException {
        char[] passphrase = this.getPassphrase(privatekeyFile.getAbsolutePath());
        return passphrase;
    }

    public char[] getPassphrase(String privatekeyFile) throws InvalidPassphraseException {
        char[] passphrase = this.passphraseForKeys.get(privatekeyFile);
        if (passphrase == null) {
            try {
                KeyPair kpair = KeyPair.load((JSch)this.jsch, (String)privatekeyFile);
                if (kpair.isEncrypted()) {
                    boolean isValid = false;
                    String message = I18n.t((String)"isisfish.ssh.askpassphrase.message", (Object[])new Object[]{privatekeyFile});
                    do {
                        if (kpair.decrypt(SSHAgent.toBytes(passphrase = this.askPassphrase(privatekeyFile, message)))) {
                            isValid = true;
                            this.passphraseForKeys.put(privatekeyFile, passphrase);
                            continue;
                        }
                        message = I18n.t((String)"isisfish.ssh.askpassphrase.wrongpassphrase", (Object[])new Object[]{privatekeyFile});
                    } while (!isValid);
                }
            }
            catch (JSchException e) {
                throw new RuntimeException("Can't find key : " + privatekeyFile);
            }
        }
        return passphrase;
    }

    protected char[] askPassphrase(String privatekeyFile, String message) throws InvalidPassphraseException {
        JPasswordField passwordField = new JPasswordField();
        JLabel labelField = new JLabel(message);
        Object[] objs = new Object[]{labelField, passwordField};
        int option = JOptionPane.showConfirmDialog(null, objs, I18n.t((String)"isisfish.ssh.askpassphrase.title", (Object[])new Object[0]), 2, 3);
        if (option == 2) {
            throw new InvalidPassphraseException("User cancel passphrase ask");
        }
        return passwordField.getPassword();
    }

    protected static byte[] toBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }
}

