/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.datastore.OptimizationStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableModel;
import fr.ifremer.isisfish.ui.models.optimization.ExportObservationTableModel;
import fr.ifremer.isisfish.ui.models.optimization.ExportTableCellEditor;
import fr.ifremer.isisfish.ui.models.optimization.ExportTableCellRenderer;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivitySaveVerifier;
import fr.ifremer.isisfish.ui.simulator.OptimizationUI;
import fr.ifremer.isisfish.ui.simulator.SimulatorTabHandler;
import fr.ifremer.isisfish.ui.widget.editor.FactorEditorListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.ListModel;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;

public class OptimizationHandler
extends SimulatorTabHandler {
    private static final Log log = LogFactory.getLog(OptimizationHandler.class);
    protected FactorEditorListener factorEditorListener;
    protected OptimizationUI tabUI;

    public OptimizationHandler(OptimizationUI tabUI) {
        super((JAXXContext)tabUI);
        this.tabUI = tabUI;
    }

    public void afterInit() {
        this.tabUI.getExportObservationTable().setModel(this.getExportObservationTableModel());
    }

    public void refresh() {
        SimulationParameter param = this.getParameters();
        RegionStorage regionStorage = this.tabUI.getContextValue(RegionStorage.class);
        if (param.getObjective() != null) {
            this.tabUI.getFieldObjectiveMethodSelect().setSelectedItem(ObjectiveStorage.getName(param.getObjective()));
        }
        if (param.getOptimization() != null) {
            this.tabUI.getFieldOptimizationMethodSelect().setSelectedItem(OptimizationStorage.getName(param.getOptimization()));
        }
        this.tabUI.getExportObservationTable().setModel(this.getExportObservationTableModel());
        this.tabUI.getExportObservationTable().getColumnModel().getColumn(0).setCellRenderer(new ExportTableCellRenderer());
        ExportTableCellEditor editor = new ExportTableCellEditor();
        editor.setRegionStorage(regionStorage);
        this.tabUI.getExportObservationTable().getColumnModel().getColumn(1).setCellEditor(editor);
        this.tabUI.getExportObservationTable().getColumnModel().getColumn(1).setCellRenderer(new ExportTableCellRenderer());
    }

    public GenericComboModel<String> getObjectiveComboModel() {
        ArrayList<String> result = new ArrayList<String>();
        for (String r : ObjectiveStorage.getObjectiveNames()) {
            if (!r.endsWith(".java")) continue;
            result.add(r.substring(0, r.length() - 5));
        }
        GenericComboModel<String> model = new GenericComboModel<String>(result);
        return model;
    }

    public void objectiveChanged() {
        Objective objective;
        RegionStorage regionStorage;
        SimulationParameter param;
        block4: {
            String objectiveName = (String)this.tabUI.getFieldObjectiveMethodSelect().getSelectedItem();
            param = this.getParameters();
            regionStorage = this.tabUI.getContextValue(RegionStorage.class);
            objective = param.getObjective();
            if (objective == null || !objective.getClass().getSimpleName().equals(objectiveName)) {
                try {
                    ObjectiveStorage objectiveStorage = ObjectiveStorage.getObjective(objectiveName, new CodeSourceStorage.Location[0]);
                    objective = (Objective)objectiveStorage.getNewInstance();
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Can't set optimization", (Throwable)e);
                }
            }
        }
        if (objective != null) {
            param.setObjective(objective);
            ScriptParametersTableModel parametersTableModel = new ScriptParametersTableModel(objective);
            this.tabUI.getSimulObjectiveMethodParam().setModel(parametersTableModel);
            this.tabUI.getSimulObjectiveMethodParam().getColumnModel().getColumn(0).setCellRenderer(new ScriptParametersTableCellRenderer(objective));
            ScriptParametersTableCellEditor editor = new ScriptParametersTableCellEditor(objective);
            editor.setRegionStorage(regionStorage);
            editor.setFactorActionListener(this.getFactorActionListener());
            this.tabUI.getSimulObjectiveMethodParam().getColumnModel().getColumn(1).setCellEditor(editor);
        }
    }

    protected FactorEditorListener getFactorActionListener() {
        if (this.factorEditorListener == null) {
            this.factorEditorListener = new FactorEditorListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SensitivityInputUI sensitivityTabUI = new SensitivityInputUI((JAXXContext)OptimizationHandler.this.tabUI);
                    sensitivityTabUI.setContextValue(new SensitivitySaveVerifier());
                    sensitivityTabUI.setContextValue(OptimizationHandler.this.tabUI.getParentContainer(SimulationUI.class), "SimulationUI");
                    try {
                        RegionStorage regionStorage = OptimizationHandler.this.tabUI.getContextValue(RegionStorage.class);
                        TopiaContext tx = regionStorage.getStorage().beginTransaction();
                        FisheryRegion fisheryRegion = RegionStorage.getFisheryRegion(tx);
                        sensitivityTabUI.setFisheryRegion(fisheryRegion);
                        sensitivityTabUI.getHandler().setTreeModel();
                    }
                    catch (Exception ex) {
                        throw new IsisFishRuntimeException("Can't init dialog tree", ex);
                    }
                    JDialog dialog = new JDialog();
                    dialog.setTitle("S\u00e9lection d'un facteur");
                    dialog.add(sensitivityTabUI);
                    dialog.setSize(800, 600);
                    dialog.setLocationRelativeTo((Component)((Object)OptimizationHandler.this.tabUI));
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            FactorGroup factorGroup = OptimizationHandler.this.getFactorGroup();
                            if (factorGroup.size() > 0) {
                                Factor factor = factorGroup.get(factorGroup.size() - 1);
                                OptimizationHandler.this.removeFactor(factor.getPath());
                                this.setSelectedFactor(factor);
                            }
                        }
                    });
                    dialog.setVisible(true);
                }
            };
        }
        return this.factorEditorListener;
    }

    @Deprecated
    public void removeFactor(String factorPath) {
        this.removeFactor(this.getFactorGroup(), factorPath);
    }

    @Deprecated
    protected void removeFactor(FactorGroup factorGroup, String factorPath) {
        ArrayList<Factor> factorCopy = new ArrayList<Factor>(factorGroup.getFactors());
        for (Factor factor : factorCopy) {
            if (factor instanceof FactorGroup) {
                this.removeFactor((FactorGroup)factor, factorPath);
            }
            if (!factorPath.equals(factor.getPath())) continue;
            factorGroup.remove(factor);
        }
    }

    public GenericComboModel<String> getOptimizationComboModel() {
        ArrayList<String> result = new ArrayList<String>();
        for (String r : OptimizationStorage.getOptimizationNames()) {
            if (!r.endsWith(".java")) continue;
            result.add(r.substring(0, r.length() - 5));
        }
        GenericComboModel<String> model = new GenericComboModel<String>(result);
        return model;
    }

    public void optimizationChanged() {
        Optimization optimization;
        RegionStorage regionStorage;
        SimulationParameter param;
        block4: {
            String optimizationName = (String)this.tabUI.getFieldOptimizationMethodSelect().getSelectedItem();
            param = this.getParameters();
            regionStorage = this.tabUI.getContextValue(RegionStorage.class);
            optimization = param.getOptimization();
            if (optimization == null || !optimization.getClass().getSimpleName().equals(optimizationName)) {
                try {
                    OptimizationStorage optimizationStorage = OptimizationStorage.getOptimization(optimizationName, new CodeSourceStorage.Location[0]);
                    optimization = (Optimization)optimizationStorage.getNewInstance();
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Can't set optimization", (Throwable)e);
                }
            }
        }
        if (optimization != null) {
            param.setOptimization(optimization);
            ScriptParametersTableModel parametersTableModel = new ScriptParametersTableModel(optimization);
            this.tabUI.getSimulOptimizationMethodParam().setModel(parametersTableModel);
            this.tabUI.getSimulOptimizationMethodParam().getColumnModel().getColumn(0).setCellRenderer(new ScriptParametersTableCellRenderer(optimization));
            ScriptParametersTableCellEditor editor = new ScriptParametersTableCellEditor(optimization);
            editor.setRegionStorage(regionStorage);
            editor.setFactorActionListener(this.getFactorActionListener());
            this.tabUI.getSimulOptimizationMethodParam().getColumnModel().getColumn(1).setCellEditor(editor);
        }
    }

    public ListModel<String> getExportListModel() {
        ArrayList<String> result = new ArrayList<String>();
        for (String r : ExportStorage.getExportNames()) {
            if (!r.endsWith(".java")) continue;
            result.add(r.substring(0, r.length() - 5));
        }
        GenericComboModel<String> model = new GenericComboModel<String>(result);
        return model;
    }

    public ExportObservationTableModel getExportObservationTableModel() {
        SimulationParameter param = this.getParameters();
        Map<ExportInfo, Observation> optimizationExportsObservations = param.getOptimizationExportsObservations();
        ExportObservationTableModel model = new ExportObservationTableModel(optimizationExportsObservations);
        return model;
    }

    public void addExports() {
        SimulationParameter param = this.getParameters();
        ExportObservationTableModel tableModel = (ExportObservationTableModel)this.tabUI.getExportObservationTable().getModel();
        List<String> selectedExports = this.tabUI.getFieldExportList().getSelectedValuesList();
        for (String selectedExport : selectedExports) {
            try {
                ExportStorage exportStorage = ExportStorage.getExport(selectedExport, new CodeSourceStorage.Location[0]);
                ExportInfo export = (ExportInfo)exportStorage.getNewInstance();
                Map<ExportInfo, Observation> optimizationExports = param.getOptimizationExportsObservations();
                optimizationExports.put(export, null);
                tableModel.setOptimizationExportsObservations(optimizationExports);
                param.setOptimizationExportsObservations(optimizationExports);
            }
            catch (IsisFishException ex) {
                throw new IsisFishRuntimeException("Can't create new export", ex);
            }
        }
    }

    public void removeExports() {
        SimulationParameter param = this.getParameters();
        Map<ExportInfo, Observation> optimizationExports = param.getOptimizationExportsObservations();
        ExportObservationTableModel tableModel = (ExportObservationTableModel)this.tabUI.getExportObservationTable().getModel();
        JTable table = this.tabUI.getExportObservationTable();
        int[] rows = table.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            ExportInfo export = tableModel.getExportForRow(rows[i]);
            optimizationExports.remove(export);
            tableModel.deleteExport(export);
        }
        param.setOptimizationExportsObservations(optimizationExports);
    }

    public void clearExports() {
        SimulationParameter param = this.getParameters();
        Map<ExportInfo, Observation> optimizationExports = param.getOptimizationExportsObservations();
        ExportObservationTableModel tableModel = (ExportObservationTableModel)this.tabUI.getExportObservationTable().getModel();
        optimizationExports.clear();
        tableModel.setOptimizationExportsObservations(optimizationExports);
        param.setOptimizationExportsObservations(optimizationExports);
    }
}

