/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.sensitivityanalysis;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.SensitivityAnalysisStorage;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.ui.util.RendererHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class SensitivityAnalysisComboRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, SensitivityAnalysis> sensitivityAnalysisCache = new HashMap<String, SensitivityAnalysis>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String sensitivityName = (String)value;
        String text = null;
        if (sensitivityName != null) {
            try {
                SensitivityAnalysis plan = this.sensitivityAnalysisCache.get(sensitivityName);
                if (plan == null) {
                    SensitivityAnalysisStorage storage = SensitivityAnalysisStorage.getSensitivityAnalysis(sensitivityName, new CodeSourceStorage.Location[0]);
                    plan = (SensitivityAnalysis)storage.getNewInstance();
                    this.sensitivityAnalysisCache.put(sensitivityName, plan);
                }
                text = RendererHelper.getNameAndDocComboString(sensitivityName, plan.getDescription());
            }
            catch (Exception e) {
                text = RendererHelper.getNameAndCompComboString(sensitivityName);
            }
            c.setText(text);
        }
        return c;
    }
}

