/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.population;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationGroupDAO;
import fr.ifremer.isisfish.ui.input.population.PopulationBasicsUI;
import fr.ifremer.isisfish.ui.input.population.WizardGroupCreationUI;
import java.awt.CardLayout;
import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class WizardGroupCreationHandler {
    private static final Log log = LogFactory.getLog(WizardGroupCreationHandler.class);
    protected WizardGroupCreationUI wizardUI;
    protected String current = null;
    protected boolean ageType = false;
    protected boolean inputType = false;
    protected boolean sameSizeType = false;
    protected boolean growthCurveType = false;
    protected double first = 0.0;
    protected double last = 0.0;
    protected String maxLength = "";
    protected int numberOfGroup = 0;
    protected double groupSize = 0.0;
    protected double step = 1.0;
    protected PopulationBasicsUI popBasic;

    public WizardGroupCreationHandler(WizardGroupCreationUI wizardUI) {
        this.wizardUI = wizardUI;
    }

    protected void afterInit() {
    }

    public void initParent(PopulationBasicsUI popBasic) {
        this.popBasic = popBasic;
    }

    public boolean isAgeType() {
        return this.ageType;
    }

    public void setAgeType(boolean ageType) {
        this.ageType = ageType;
    }

    public boolean isInputType() {
        return this.inputType;
    }

    public void setInputType(boolean inputType) {
        this.inputType = inputType;
    }

    public boolean isSameSizeType() {
        return this.sameSizeType;
    }

    public void setSameSizeType(boolean sameSizeType) {
        this.sameSizeType = sameSizeType;
    }

    public boolean isGrowthCurveType() {
        return this.growthCurveType;
    }

    public void setGrowthCurveType(boolean growthCurveType) {
        this.growthCurveType = growthCurveType;
    }

    public double getFirst() {
        return this.first;
    }

    public void setFirst(double first) {
        this.first = first;
    }

    public double getLast() {
        return this.last;
    }

    public void setLast(double last) {
        this.last = last;
    }

    public String getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(String maxLength) {
        this.maxLength = maxLength;
    }

    public int getNumberOfGroup() {
        return this.numberOfGroup;
    }

    public void setNumberOfGroup(int numberOfGroup) {
        this.numberOfGroup = numberOfGroup;
    }

    public double getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(double groupSize) {
        this.groupSize = groupSize;
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
    }

    public void setCard(String name) {
        this.current = name;
        ((CardLayout)this.wizardUI.wizardPanels.getLayout()).show(this.wizardUI.wizardPanels, name);
    }

    protected void prev() {
        if (!this.isAgeType()) {
            this.setCard("beginGroupLength");
        }
        this.wizardUI.prev.setEnabled(false);
        this.wizardUI.next.setEnabled(true);
        this.wizardUI.finish.setEnabled(false);
    }

    protected void next() {
        if (!this.isAgeType()) {
            if (this.isInputType()) {
                this.setCard("endInputGroupLength");
            } else if (this.isSameSizeType()) {
                this.setCard("endSameSizeGroupLength");
            } else if (this.isGrowthCurveType()) {
                this.setCard("endGrowthCurveGroupLength");
            }
        }
        this.wizardUI.prev.setEnabled(true);
        this.wizardUI.next.setEnabled(false);
        this.wizardUI.finish.setEnabled(true);
    }

    protected void finish() {
        block18: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"wizardGroupFinish called");
            }
            try {
                Population pop = this.popBasic.getBean();
                pop.clearPopulationGroup();
                TopiaContext isisContext = pop.getTopiaContext();
                PopulationGroupDAO populationGroupDAO = IsisFishDAOHelper.getPopulationGroupDAO(isisContext);
                if (this.isAgeType()) {
                    double ageFirst = this.getFirst();
                    double ageLast = this.getLast();
                    int id = 0;
                    while ((double)id + ageFirst <= ageLast) {
                        PopulationGroup group = (PopulationGroup)populationGroupDAO.create(new Object[0]);
                        group.setId(id);
                        group.setPopulation(pop);
                        group.setAge(ageFirst + (double)id);
                        pop.addPopulationGroup(group);
                        populationGroupDAO.update((TopiaEntity)group);
                        ++id;
                    }
                } else if (this.isInputType()) {
                    double minLength = this.getFirst();
                    String[] values = this.getMaxLength().split(";");
                    for (int i = 0; i < values.length; ++i) {
                        if ("".equals(values[i])) continue;
                        double length = Double.parseDouble(values[i]);
                        PopulationGroup group = (PopulationGroup)populationGroupDAO.create(new Object[0]);
                        group.setId(i);
                        group.setPopulation(pop);
                        group.setMinLength(minLength);
                        group.setMaxLength(length);
                        pop.addPopulationGroup(group);
                        populationGroupDAO.update((TopiaEntity)group);
                        minLength = length;
                    }
                } else if (this.isSameSizeType()) {
                    double minLength = this.getFirst();
                    int numberOfGroup = this.getNumberOfGroup();
                    double step = this.getGroupSize();
                    if (numberOfGroup < 0) {
                        // empty if block
                    }
                    if (step == 0.0) {
                        // empty if block
                    }
                    double maxLength = minLength;
                    for (int i = 0; i < numberOfGroup; ++i) {
                        maxLength = minLength + step;
                        PopulationGroup group = (PopulationGroup)populationGroupDAO.create(new Object[0]);
                        group.setId(i);
                        group.setPopulation(pop);
                        group.setMinLength(minLength);
                        group.setMaxLength(maxLength);
                        pop.addPopulationGroup(group);
                        populationGroupDAO.update((TopiaEntity)group);
                        minLength = maxLength;
                    }
                } else if (this.isGrowthCurveType()) {
                    double minLength = this.getFirst();
                    int numberOfGroup = this.getNumberOfGroup();
                    int step = (int)this.getStep();
                    Equation equation = pop.getGrowth();
                    if (equation == null) {
                        // empty if block
                    }
                    double deltat = -1.0;
                    double Lmin = minLength;
                    for (int i = 0; i < numberOfGroup; ++i) {
                        PopulationGroup group = (PopulationGroup)populationGroupDAO.create(new Object[0]);
                        group.setId(i);
                        group.setPopulation(pop);
                        group.setMinLength(Lmin);
                        group.setMaxLength(Lmin);
                        pop.addPopulationGroup(group);
                        if (deltat < 0.0) {
                            deltat = pop.getAge(minLength, group);
                        }
                        double Lmax = pop.getLength(deltat += (double)step, group);
                        group.setMaxLength(Lmax);
                        Lmin = Lmax;
                    }
                }
                this.popBasic.getHandler().refresh();
                this.cancel();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block18;
                log.error((Object)"Can't create PopulationGroup", (Throwable)e);
            }
        }
    }

    protected void cancel() {
        this.wizardUI.getParentContainer(JFrame.class).dispose();
    }

    protected void refreshChoice() {
        this.setInputType(this.wizardUI.beginGroupLengthTypeInput.isSelected());
        this.setSameSizeType(this.wizardUI.beginGroupLengthTypeSameSize.isSelected());
        this.setGrowthCurveType(this.wizardUI.beginGroupLengthTypeGrowthCurve.isSelected());
    }

    protected void stepChanged() {
        if (!this.wizardUI.fieldStep.getText().equals("")) {
            this.setStep(Double.parseDouble(this.wizardUI.fieldStep.getText()));
        }
    }

    protected void firstAgeChanged() {
        if (!this.wizardUI.firstAge.getText().equals("")) {
            this.setFirst(Double.parseDouble(this.wizardUI.firstAge.getText()));
        }
    }

    protected void lastAgeChanged() {
        if (!this.wizardUI.lastAge.getText().equals("")) {
            this.setLast(Double.parseDouble(this.wizardUI.lastAge.getText()));
        }
    }

    protected void firstInputLengthChanged() {
        if (!this.wizardUI.firstInputLength.getText().equals("")) {
            this.setFirst(Double.parseDouble(this.wizardUI.firstInputLength.getText()));
        }
    }

    protected void maximalGroupsLengthChanged() {
        if (!this.wizardUI.maximalGroupsLength.getText().equals("")) {
            this.setMaxLength(this.wizardUI.maximalGroupsLength.getText());
        }
    }

    protected void firstSizeLengthChanged() {
        if (!this.wizardUI.firstSizeLength.getText().equals("")) {
            this.setFirst(Double.parseDouble(this.wizardUI.firstSizeLength.getText()));
        }
    }

    protected void sameSizeNumberOfGroupChanged() {
        if (!this.wizardUI.sameSizeNumberOfGroup.getText().equals("")) {
            this.setNumberOfGroup(Integer.parseInt(this.wizardUI.sameSizeNumberOfGroup.getText()));
        }
    }

    protected void groupWidthChanged() {
        if (!this.wizardUI.groupWidth.getText().equals("")) {
            this.setGroupSize(Double.parseDouble(this.wizardUI.groupWidth.getText()));
        }
    }

    protected void growthCurveFirstGroupChanged() {
        if (!this.wizardUI.growthCurveFirstGroup.getText().equals("")) {
            this.setFirst(Double.parseDouble(this.wizardUI.growthCurveFirstGroup.getText()));
        }
    }

    protected void fieldNumberOfGroupChanged() {
        if (!this.wizardUI.fieldNumberOfGroup.getText().equals("")) {
            this.setNumberOfGroup(Integer.parseInt(this.wizardUI.fieldNumberOfGroup.getText()));
        }
    }
}

