/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationParameterImpl;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;

public class SimulationParameterCache
implements SimulationParameter {
    protected File paramFile;
    protected SoftReference<SimulationParameter> ref;

    public SimulationParameterCache(SimulationParameter param) {
        try {
            this.paramFile = File.createTempFile("isis-fish-param", ".properties");
            this.paramFile.deleteOnExit();
            this.store(param);
        }
        catch (IOException eee) {
            throw new IsisFishRuntimeException("Can't cache param to disk", eee);
        }
        this.ref = new SoftReference<SimulationParameter>(param);
    }

    protected void store(SimulationParameter param) {
        Properties prop = param.toProperties();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.paramFile));
            prop.store(writer, "Parameter cache");
        }
        catch (IOException eee) {
            try {
                throw new IsisFishRuntimeException("Can't cache param to disk", eee);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    protected SimulationParameter getParam() {
        SimulationParameter result = this.ref.get();
        if (result == null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(this.paramFile));
                Properties prop = new Properties();
                prop.load(reader);
                result = new SimulationParameterImpl();
                result.fromProperties(prop);
                this.ref = new SoftReference<SimulationParameter>(result);
            }
            catch (IOException eee) {
                try {
                    throw new IsisFishRuntimeException("Can't cache param to disk", eee);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        return result;
    }

    @Override
    public List<String> check() {
        SimulationParameter param = this.getParam();
        return param.check();
    }

    @Override
    public String getIsisFishVersion() {
        SimulationParameter param = this.getParam();
        return param.getIsisFishVersion();
    }

    @Override
    public void setIsisFishVersion(String isisFishVersion) {
        SimulationParameter param = this.getParam();
        param.setIsisFishVersion(isisFishVersion);
        this.store(param);
    }

    @Override
    public String getDescription() {
        SimulationParameter param = this.getParam();
        return param.getDescription();
    }

    @Override
    public void setDescription(String description) {
        SimulationParameter param = this.getParam();
        param.setDescription(description);
        this.store(param);
    }

    @Override
    public RegionStorage getRegion() {
        SimulationParameter param = this.getParam();
        return param.getRegion();
    }

    @Override
    public MatrixND getNumberOf(Population pop) {
        SimulationParameter param = this.getParam();
        return param.getNumberOf(pop);
    }

    @Override
    public List<String> getExtraRules() {
        SimulationParameter param = this.getParam();
        return param.getExtraRules();
    }

    @Override
    public void addExtraRules(String ... extraRules) {
        SimulationParameter param = this.getParam();
        param.addExtraRules(extraRules);
        this.store(param);
    }

    @Override
    public List<Population> getPopulations() {
        SimulationParameter param = this.getParam();
        return param.getPopulations();
    }

    @Override
    public void setPopulations(List<Population> populations) {
        SimulationParameter param = this.getParam();
        param.setPopulations(populations);
        this.store(param);
    }

    @Override
    public List<Strategy> getStrategies() {
        SimulationParameter param = this.getParam();
        return param.getStrategies();
    }

    @Override
    public void setStrategies(List<Strategy> strategies) {
        SimulationParameter param = this.getParam();
        param.setStrategies(strategies);
        this.store(param);
    }

    @Override
    public void addSimulationPlan(SimulationPlan plan) {
        SimulationParameter param = this.getParam();
        param.addSimulationPlan(plan);
        this.store(param);
    }

    @Override
    public boolean removeSimulationPlan(SimulationPlan plan) {
        SimulationParameter param = this.getParam();
        boolean result = param.removeSimulationPlan(plan);
        this.store(param);
        return result;
    }

    @Override
    public List<SimulationPlan> getSimulationPlans() {
        SimulationParameter param = this.getParam();
        return param.getSimulationPlans();
    }

    @Override
    public void setSimulationPlans(List<SimulationPlan> plans) {
        SimulationParameter param = this.getParam();
        param.setSimulationPlans(plans);
        this.store(param);
    }

    @Override
    public boolean isIndependentPlan() {
        SimulationParameter param = this.getParam();
        return param.isIndependentPlan();
    }

    @Override
    public void clearPlans() {
        SimulationParameter param = this.getParam();
        param.clearPlans();
        this.store(param);
    }

    @Override
    public void addRule(Rule rule) {
        SimulationParameter param = this.getParam();
        param.addRule(rule);
        this.store(param);
    }

    @Override
    public boolean removeRule(Rule rule) {
        SimulationParameter param = this.getParam();
        boolean result = param.removeRule(rule);
        this.store(param);
        return result;
    }

    @Override
    public List<Rule> getRules() {
        SimulationParameter param = this.getParam();
        return param.getRules();
    }

    @Override
    public void setRules(List<Rule> rules) {
        SimulationParameter param = this.getParam();
        param.setRules(rules);
        this.store(param);
    }

    @Override
    public void clearRules() {
        SimulationParameter param = this.getParam();
        param.clearRules();
        this.store(param);
    }

    @Override
    public boolean getUseOptimization() {
        SimulationParameter param = this.getParam();
        return param.getUseOptimization();
    }

    @Override
    public void setUseOptimization(boolean useOptimization) {
        SimulationParameter param = this.getParam();
        param.setUseOptimization(useOptimization);
        this.store(param);
    }

    @Override
    public boolean getUseStatistic() {
        SimulationParameter param = this.getParam();
        return param.getUseStatistic();
    }

    @Override
    public void setUseStatistic(boolean useStatistic) {
        SimulationParameter param = this.getParam();
        param.setUseStatistic(useStatistic);
        this.store(param);
    }

    @Override
    public List<String> getExportNames() {
        SimulationParameter param = this.getParam();
        return param.getExportNames();
    }

    @Override
    public void setExportNames(List<String> exportNames) {
        SimulationParameter param = this.getParam();
        param.setExportNames(exportNames);
        this.store(param);
    }

    @Override
    public int getNumberOfSensitivitySimulation() {
        SimulationParameter param = this.getParam();
        return param.getNumberOfSensitivitySimulation();
    }

    @Override
    public void setNumberOfSensitivitySimulation(int numberOfSensitivitySimulation) {
        SimulationParameter param = this.getParam();
        param.setNumberOfSensitivitySimulation(numberOfSensitivitySimulation);
        this.store(param);
    }

    @Override
    public SensitivityAnalysis getSensitivityAnalysis() {
        SimulationParameter param = this.getParam();
        return param.getSensitivityAnalysis();
    }

    @Override
    public void setSensitivityAnalysis(SensitivityAnalysis sensitivityAnalysis) {
        SimulationParameter param = this.getParam();
        param.setSensitivityAnalysis(sensitivityAnalysis);
        this.store(param);
    }

    @Override
    public List<SensitivityExport> getSensitivityExport() {
        SimulationParameter param = this.getParam();
        return param.getSensitivityExport();
    }

    @Override
    public void setSensitivityExport(List<SensitivityExport> sensitivityExport) {
        SimulationParameter param = this.getParam();
        param.setSensitivityExport(sensitivityExport);
        this.store(param);
    }

    @Override
    public boolean getUseSimulationPlan() {
        SimulationParameter param = this.getParam();
        return param.getUseSimulationPlan();
    }

    @Override
    public void setUseSimulationPlan(boolean useSimulationPlan) {
        SimulationParameter param = this.getParam();
        param.setUseSimulationPlan(useSimulationPlan);
        this.store(param);
    }

    @Override
    public int getSimulationPlanNumber() {
        SimulationParameter param = this.getParam();
        return param.getSimulationPlanNumber();
    }

    @Override
    public void setSimulationPlanNumber(int simulationPlanNumber) {
        SimulationParameter param = this.getParam();
        param.setSimulationPlanNumber(simulationPlanNumber);
        this.store(param);
    }

    @Override
    public int getOptimizationGeneration() {
        SimulationParameter param = this.getParam();
        return param.getOptimizationGeneration();
    }

    @Override
    public void setOptimizationGeneration(int optimizationGeneration) {
        SimulationParameter param = this.getParam();
        param.setOptimizationGeneration(optimizationGeneration);
        this.store(param);
    }

    @Override
    public int getOptimizationGenerationIndividual() {
        SimulationParameter param = this.getParam();
        return param.getOptimizationGenerationIndividual();
    }

    @Override
    public void setOptimizationGenerationIndividual(int optimizationGenerationIndividual) {
        SimulationParameter param = this.getParam();
        param.setOptimizationGenerationIndividual(optimizationGenerationIndividual);
        this.store(param);
    }

    @Override
    public boolean isSensitivityAnalysisOnlyKeepFirst() {
        SimulationParameter param = this.getParam();
        return param.isSensitivityAnalysisOnlyKeepFirst();
    }

    @Override
    public void setSensitivityAnalysisOnlyKeepFirst(boolean onlyKeepFirst) {
        SimulationParameter param = this.getParam();
        param.setSensitivityAnalysisOnlyKeepFirst(onlyKeepFirst);
        this.store(param);
    }

    @Override
    public boolean isResultDeleteAfterExport() {
        SimulationParameter param = this.getParam();
        return param.isResultDeleteAfterExport();
    }

    @Override
    public void setResultDeleteAfterExport(boolean deleteAfterExport) {
        SimulationParameter param = this.getParam();
        param.setResultDeleteAfterExport(deleteAfterExport);
        this.store(param);
    }

    @Override
    public int getNumberOfYear() {
        SimulationParameter param = this.getParam();
        return param.getNumberOfYear();
    }

    @Override
    public void setNumberOfYear(int numberOfYear) {
        SimulationParameter param = this.getParam();
        param.setNumberOfYear(numberOfYear);
        this.store(param);
    }

    @Override
    public int getNumberOfMonths() {
        SimulationParameter param = this.getParam();
        return param.getNumberOfMonths();
    }

    @Override
    public void setNumberOfMonths(int numberOfMonths) {
        SimulationParameter param = this.getParam();
        param.setNumberOfMonths(numberOfMonths);
        this.store(param);
    }

    @Override
    public boolean getUsePreScript() {
        SimulationParameter param = this.getParam();
        return param.getUsePreScript();
    }

    @Override
    public void setUsePreScript(boolean usePreScript) {
        SimulationParameter param = this.getParam();
        param.setUsePreScript(usePreScript);
        this.store(param);
    }

    @Override
    public String getPreScript() {
        SimulationParameter param = this.getParam();
        return param.getPreScript();
    }

    @Override
    public void setPreScript(String preScript) {
        SimulationParameter param = this.getParam();
        param.setPreScript(preScript);
        this.store(param);
    }

    @Override
    public String getGeneratedPreScript() {
        SimulationParameter param = this.getParam();
        return param.getGeneratedPreScript();
    }

    @Override
    public void setGeneratedPreScript(String preScript) {
        SimulationParameter param = this.getParam();
        param.setGeneratedPreScript(preScript);
        this.store(param);
    }

    @Override
    public String getRegionName() {
        SimulationParameter param = this.getParam();
        return param.getRegionName();
    }

    @Override
    public void setRegionName(String regionName) {
        SimulationParameter param = this.getParam();
        param.setRegionName(regionName);
        this.store(param);
    }

    @Override
    public String getSimulatorName() {
        SimulationParameter param = this.getParam();
        return param.getSimulatorName();
    }

    @Override
    public void setSimulatorName(String simulatorName) {
        SimulationParameter param = this.getParam();
        param.setSimulatorName(simulatorName);
        this.store(param);
    }

    @Override
    public Collection<String> getResultEnabled() {
        SimulationParameter param = this.getParam();
        return param.getResultEnabled();
    }

    @Override
    public void setResultEnabled(Collection<String> resultEnabled) {
        SimulationParameter param = this.getParam();
        param.setResultEnabled(resultEnabled);
        this.store(param);
    }

    @Override
    public Map<String, String> getTagValue() {
        SimulationParameter param = this.getParam();
        return param.getTagValue();
    }

    @Override
    public void setTagValue(Map<String, String> tagValue) {
        SimulationParameter param = this.getParam();
        param.setTagValue(tagValue);
        this.store(param);
    }

    @Override
    public String getSimulLogLevel() {
        SimulationParameter param = this.getParam();
        return param.getSimulLogLevel();
    }

    @Override
    public void setSimulLogLevel(String logLevel) {
        SimulationParameter param = this.getParam();
        param.setSimulLogLevel(logLevel);
        this.store(param);
    }

    @Override
    public String getScriptLogLevel() {
        SimulationParameter param = this.getParam();
        return param.getScriptLogLevel();
    }

    @Override
    public void setScriptLogLevel(String logLevel) {
        SimulationParameter param = this.getParam();
        param.setScriptLogLevel(logLevel);
        this.store(param);
    }

    @Override
    public String getLibLogLevel() {
        SimulationParameter param = this.getParam();
        return param.getLibLogLevel();
    }

    @Override
    public void setLibLogLevel(String logLevel) {
        SimulationParameter param = this.getParam();
        param.setLibLogLevel(logLevel);
        this.store(param);
    }

    @Override
    public boolean isSimulErrorLevel() {
        SimulationParameter param = this.getParam();
        return param.isSimulErrorLevel();
    }

    @Override
    public boolean isSimulWarnLevel() {
        SimulationParameter param = this.getParam();
        return param.isSimulErrorLevel();
    }

    @Override
    public boolean isSimulInfoLevel() {
        SimulationParameter param = this.getParam();
        return param.isScriptInfoLevel();
    }

    @Override
    public boolean isSimulDebugLevel() {
        SimulationParameter param = this.getParam();
        return param.isSimulDebugLevel();
    }

    @Override
    public boolean isScriptErrorLevel() {
        SimulationParameter param = this.getParam();
        return param.isScriptErrorLevel();
    }

    @Override
    public boolean isScriptWarnLevel() {
        SimulationParameter param = this.getParam();
        return param.isScriptWarnLevel();
    }

    @Override
    public boolean isScriptInfoLevel() {
        SimulationParameter param = this.getParam();
        return param.isScriptInfoLevel();
    }

    @Override
    public boolean isScriptDebugLevel() {
        SimulationParameter param = this.getParam();
        return param.isScriptDebugLevel();
    }

    @Override
    public boolean isLibErrorLevel() {
        SimulationParameter param = this.getParam();
        return param.isLibErrorLevel();
    }

    @Override
    public boolean isLibWarnLevel() {
        SimulationParameter param = this.getParam();
        return param.isLibWarnLevel();
    }

    @Override
    public boolean isLibInfoLevel() {
        SimulationParameter param = this.getParam();
        return param.isLibInfoLevel();
    }

    @Override
    public boolean isLibDebugLevel() {
        SimulationParameter param = this.getParam();
        return param.isLibDebugLevel();
    }

    @Override
    public void setProperty(String key, String value) {
        SimulationParameter param = this.getParam();
        param.setProperty(key, value);
    }

    @Override
    public SimulationParameter copy() {
        SimulationParameter param = this.getParam();
        return param.copy();
    }

    @Override
    public SimulationParameter deepCopy() {
        SimulationParameter param = this.getParam();
        return param.deepCopy();
    }

    @Override
    public Properties toProperties() {
        SimulationParameter param = this.getParam();
        return param.toProperties();
    }

    @Override
    public void fromProperties(Properties props) {
        SimulationParameter param = this.getParam();
        param.fromProperties(props);
        this.store(param);
    }

    @Override
    public void reloadContextParameters() throws TopiaException {
        SimulationParameter param = this.getParam();
        param.reloadContextParameters();
        this.store(param);
    }

    @Override
    public Optimization getOptimization() {
        SimulationParameter param = this.getParam();
        return param.getOptimization();
    }

    @Override
    public Objective getObjective() {
        SimulationParameter param = this.getParam();
        return param.getObjective();
    }

    @Override
    public void setOptimization(Optimization optimization) {
        SimulationParameter param = this.getParam();
        param.setOptimization(optimization);
        this.store(param);
    }

    @Override
    public void setObjective(Objective objective) {
        SimulationParameter param = this.getParam();
        param.setObjective(objective);
        this.store(param);
    }

    @Override
    public Map<ExportInfo, Observation> getOptimizationExportsObservations() {
        SimulationParameter param = this.getParam();
        return param.getOptimizationExportsObservations();
    }

    @Override
    public void setOptimizationExportsObservations(Map<ExportInfo, Observation> exportsObservations) {
        SimulationParameter param = this.getParam();
        param.setOptimizationExportsObservations(exportsObservations);
        this.store(param);
    }

    @Override
    public boolean getUseCache() {
        SimulationParameter param = this.getParam();
        return param.getUseCache();
    }

    @Override
    public void setUseCache(boolean useCache) {
        SimulationParameter param = this.getParam();
        param.setUseCache(useCache);
        this.store(param);
    }
}

