/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging.io;

import fr.ifremer.isisfish.logging.io.OffsetReader;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MemoryOffsetReader
extends OffsetReader {
    protected static final Log log = LogFactory.getLog(MemoryOffsetReader.class);
    protected Map<Long, Long> offsetCache;
    protected int capacity;

    public MemoryOffsetReader(int capacity) {
        this.capacity = capacity;
        this.offsetCache = new TreeMap<Long, Long>();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.offsetCache.clear();
    }

    @Override
    public long getOffset(long position) {
        long result = -1L;
        if (this.offsetCache.containsKey(position)) {
            result = this.offsetCache.get(position);
        }
        return result;
    }

    @Override
    protected void storeOffset(long position, long offset) {
        if (this.offsetCache.size() < this.capacity) {
            this.offsetCache.put(position, offset);
        }
    }

    @Override
    protected boolean needCreate() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(capacity:").append(this.capacity).append(", nbLines:").append(this.getNbLines()).append(')');
        return sb.toString();
    }
}

