/*
 * #%L
 * $Id: ZoneBasicsHandler.java 4237 2015-05-27 13:00:56Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/input/zone/ZoneBasicsHandler.java $
 * %%
 * Copyright (C) 2015 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.zone;

import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.event.ListSelectionEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.bbn.openmap.event.SelectMouseMode;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.map.CellSelectionLayer;
import fr.ifremer.isisfish.map.OpenMapEvents;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;

/**
 * Zone handler.
 */
public class ZoneBasicsHandler extends InputContentHandler<ZoneBasicsUI> {

    /** Class logger. */
    private static final Log log = LogFactory.getLog(ZoneBasicsHandler.class);

    public ZoneBasicsHandler(ZoneBasicsUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        new OpenMapEvents(inputContentUI.zoneMap, new SelectMouseMode(false), CellSelectionLayer.MULT_SELECTION) {
            @Override
            public boolean mouseClicked(MouseEvent e) {
                boolean result = false;
                if (inputContentUI.getBean() != null) { // impossible de desactiver la carte :(
                    inputContentUI.getBean().setCell(inputContentUI.zoneMap.getSelectedCells());
                    setZoneCells();
                }
                return result;
            }
        };

        inputContentUI.addPropertyChangeListener(ZoneBasicsUI.PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    inputContentUI.fieldZoneName.setText("");
                    inputContentUI.fieldZoneComment.setText("");
                    inputContentUI.zoneMap.setSelectedCells();
                }
                if (evt.getNewValue() != null) {
                    
                }
                setZoneCells();
            }
        });
    }

    protected void setZoneCells() {
        GenericListModel<Cell> zoneModel = new GenericListModel<>();
        if (inputContentUI.getBean() != null) {
            
            // build model
            List<Cell> cells = inputContentUI.getFisheryRegion().getCell();
            zoneModel.setElementList(cells);
            inputContentUI.zoneCells.setModel(zoneModel);

            // restore selection
            int firstIndex = -1;
            if (inputContentUI.getBean().getCell() != null) {
                for (Cell selectedCell : inputContentUI.getBean().getCell()) {
                    int index = cells.indexOf(selectedCell);
                    inputContentUI.zoneCells.addSelectionInterval(index, index);
                    
                    if (firstIndex == -1) {
                        firstIndex = index;
                    }
                }
            }
            
            // sroll to visible
            if (firstIndex != -1) {
                inputContentUI.zoneCells.ensureIndexIsVisible(firstIndex);
            }
        } else {
            inputContentUI.zoneCells.setModel(zoneModel);
        }
    }

    public void zoneCellsChange(ListSelectionEvent event) {
        // sans ca, ca boucle (modification depuis la carte)
        if (event.getValueIsAdjusting()) {
            // pas a faie dans le cas d'une AS
            if (inputContentUI.isActive()) {
                List<Cell> cells = new ArrayList<>(inputContentUI.zoneCells.getSelectedValuesList());
                inputContentUI.getBean().setCell(cells);
            }
        }
    }
}
