package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class PopulationMigrationEmigrationUI extends InputContentUI<Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POP_INFO = "popInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_COEFFICIENT_ENABLED = "fieldPopulationMigrationEmigrationCoefficient.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_DEPARTURE_ZONE_CHOOSER_ENABLED = "fieldPopulationMigrationEmigrationDepartureZoneChooser.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_GROUP_CHOOSER_ENABLED = "fieldPopulationMigrationEmigrationGroupChooser.enabled";
    public static final String BINDING_POPULATION_MIGRATION_EMIGRATION_TABLE_ENABLED = "populationMigrationEmigrationTable.enabled";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VS28TMRB2Qx+0BVqoWoooopRKCAmcFiQk1EIfgbapEkCUSlVzwek6idHGNrYXthfET+AnwJ0LEjdOiANnDlwQfwEhDlwRY+e5ZZtECjnsej0z33zjGX95+wP1aYUuPCFhiFXADStTvLmys3M//4TumTtU7ykmjVCo8utJoEQODXv1fW3QxVzGhier4cmUKEvBKW+KXsigIW32fapLlBqDzkUj9rRObtXNC6EMVA21TioO9fWvn4lX3ss3CYRCCexGoZTpdlGNSnozKME8g05Bpmck6RNeBBqK8SLwPW73Uj7R+h4p06foBRrIoH5JFIAZNNN5yQ7DxYfSoNHZNJeBSQluwH07PWfQekFhVlC0TOGtmS4wXcIBw8w6Yilk4BPDBMcP6sssKyq3uFuurbbTUro0/Qb15inhBl2KA4aszDCqm9AagQOQLc0LwqD5DmO3KNGC25gmlBLhnk+VQZn/UtpGBa65PuHtQ99si0Ksn0PH8OYDwqnfRGL2Ecn7FM53MjIRFW9ns57j9YCjs5sZkqf+3EFgt2udJuu+uMCo77Ukva5EIFMlIbQ9iPEIIoxLXqyKMApaIzBvv89FbVfbJ0wJWiiwPebmcyKS7xENzZoFiE94LSbhjfYJ71C4DSZQdBdGv1qpjZ7+J4trzZz9Ph21HSEe3L+xCNnVwBjBo34zshUR10yDrghVxDxgEI3LxJTsQ7EQF2Hgsm7peNz1wENF8fthRMUzNxC4alHobGRuQKNwQ6MaItKTQ30qgG0YtNy/svYQTBVBmzwgaBbQWf9MjH398P39Wk3FRiD3eKxrkwiDukglJMwWs6lHKhIWGOYns0Qu5NCgpj4ouFPoqRhiW1UzkIN8J204tuF4g+gSQPQNfPv4aeLxlyMosYaGfEG8NWL902jQlBScgvC9UC4tO0bHnh+18mu5wc2j3DYEGnti0SOGTOcZ96C1t0M4hamYU6hTyQ9+/j229W65dhI9wOzMoe6N0+jbRf2M+4xTp+hVsY5V8GGpaeCJhijHyXSPfU/JqpjcdM9bcaX2GrhZoBeLlezTxMCY5QNDoVYbtOKKsKtUh5h2e8k+luMRzneNMNMRwrp9bHSD0IrDbNcIl7quojOEVhwud45wCIerXVfRGUKrKuY6mPNhO91EZYVX+Sc8hEx7qHZkrnd9IBbhL/S+gsDWCgAA";
    private static final Log log = LogFactory.getLog(PopulationMigrationEmigrationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected Population bean;
    protected JTextField fieldPopulationMigrationEmigrationCoefficient;
    protected JComboBox<Zone> fieldPopulationMigrationEmigrationDepartureZoneChooser;
    protected JComboBox<PopulationGroup> fieldPopulationMigrationEmigrationGroupChooser;
    protected PopulationMigrationEmigrationHandler handler;
    protected PopulationSeasonInfo popInfo;
    protected MatrixPanelEditor populationMigrationEmigrationTable;
    protected JButton remove;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationMigrationEmigrationUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationMigrationEmigrationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationEmigrationUI() {
        $initialize();
    }

    public PopulationMigrationEmigrationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationEmigrationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.add();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.remove();
    }

    public void doItemStateChanged__on__fieldPopulationMigrationEmigrationDepartureZoneChooser(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    public void doItemStateChanged__on__fieldPopulationMigrationEmigrationGroupChooser(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    public void doKeyReleased__on__fieldPopulationMigrationEmigrationCoefficient(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    public void doMatrixChanged__on__populationMigrationEmigrationTable(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.populationMigrationEmigrationMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public Population getBean() {
        return bean;
    }

    public JTextField getFieldPopulationMigrationEmigrationCoefficient() {
        return fieldPopulationMigrationEmigrationCoefficient;
    }

    public JComboBox<Zone> getFieldPopulationMigrationEmigrationDepartureZoneChooser() {
        return fieldPopulationMigrationEmigrationDepartureZoneChooser;
    }

    public JComboBox<PopulationGroup> getFieldPopulationMigrationEmigrationGroupChooser() {
        return fieldPopulationMigrationEmigrationGroupChooser;
    }

    public PopulationMigrationEmigrationHandler getHandler() {
        return handler;
    }

    public PopulationSeasonInfo getPopInfo() {
        return popInfo;
    }

    public MatrixPanelEditor getPopulationMigrationEmigrationTable() {
        return populationMigrationEmigrationTable;
    }

    public JButton getRemove() {
        return remove;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopInfo(PopulationSeasonInfo popInfo) {
        PopulationSeasonInfo oldValue = this.popInfo;
        this.popInfo = popInfo;
        firePropertyChange(PROPERTY_POP_INFO, oldValue, popInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setEnabled(false);
        add.setText(t("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createFieldPopulationMigrationEmigrationCoefficient() {
        $objectMap.put("fieldPopulationMigrationEmigrationCoefficient", fieldPopulationMigrationEmigrationCoefficient = new JTextField());
        
        fieldPopulationMigrationEmigrationCoefficient.setName("fieldPopulationMigrationEmigrationCoefficient");
        fieldPopulationMigrationEmigrationCoefficient.setColumns(15);
        fieldPopulationMigrationEmigrationCoefficient.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationMigrationEmigrationCoefficient"));
    }

    protected void createFieldPopulationMigrationEmigrationDepartureZoneChooser() {
        $objectMap.put("fieldPopulationMigrationEmigrationDepartureZoneChooser", fieldPopulationMigrationEmigrationDepartureZoneChooser = new JComboBox<Zone>());
        
        fieldPopulationMigrationEmigrationDepartureZoneChooser.setName("fieldPopulationMigrationEmigrationDepartureZoneChooser");
        fieldPopulationMigrationEmigrationDepartureZoneChooser.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldPopulationMigrationEmigrationDepartureZoneChooser"));
    }

    protected void createFieldPopulationMigrationEmigrationGroupChooser() {
        $objectMap.put("fieldPopulationMigrationEmigrationGroupChooser", fieldPopulationMigrationEmigrationGroupChooser = new JComboBox<PopulationGroup>());
        
        fieldPopulationMigrationEmigrationGroupChooser.setName("fieldPopulationMigrationEmigrationGroupChooser");
        fieldPopulationMigrationEmigrationGroupChooser.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldPopulationMigrationEmigrationGroupChooser"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PopulationMigrationEmigrationHandler(this));
    }

    protected void createPopInfo() {
        $objectMap.put("popInfo", popInfo = null);
    }

    protected void createPopulationMigrationEmigrationTable() {
        $objectMap.put("populationMigrationEmigrationTable", populationMigrationEmigrationTable = new MatrixPanelEditor());
        
        populationMigrationEmigrationTable.setName("populationMigrationEmigrationTable");
        populationMigrationEmigrationTable.setLinearModel(true);
        populationMigrationEmigrationTable.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__populationMigrationEmigrationTable"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setText(t("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationEmigrationGroupChooser, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationEmigrationCoefficient, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationEmigrationDepartureZoneChooser, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 1, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(add, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(populationMigrationEmigrationTable, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(remove, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopInfo();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.common.populationGroup"));
        createFieldPopulationMigrationEmigrationGroupChooser();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationMigrationEmigration.coefficient"));
        createFieldPopulationMigrationEmigrationCoefficient();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.populationMigrationEmigration.departureZone"));
        createFieldPopulationMigrationEmigrationDepartureZoneChooser();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createAdd();
        createPopulationMigrationEmigrationTable();
        createRemove();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_GROUP_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationEmigrationGroupChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_COEFFICIENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationEmigrationCoefficient.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_EMIGRATION_DEPARTURE_ZONE_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationEmigrationDepartureZoneChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_EMIGRATION_TABLE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationMigrationEmigrationTable.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                remove.setEnabled(isActive());
            }
        });
    }

}