/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.dsml;

import edu.vt.middleware.ldap.LdapUtil;
import edu.vt.middleware.ldap.bean.LdapAttribute;
import edu.vt.middleware.ldap.bean.LdapAttributes;
import edu.vt.middleware.ldap.bean.LdapEntry;
import edu.vt.middleware.ldap.bean.LdapResult;
import edu.vt.middleware.ldap.dsml.AbstractDsml;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dsmlv1
extends AbstractDsml {
    private static final long serialVersionUID = 1047858330816575821L;

    @Override
    public Document createDsml(Iterator<SearchResult> results) {
        Document dsml;
        block2: {
            dsml = null;
            try {
                LdapResult lr = this.beanFactory.newLdapResult();
                lr.addEntries(results);
                dsml = this.createDsml(lr);
            }
            catch (NamingException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error((Object)"Error creating Element from SearchResult", (Throwable)e);
            }
        }
        return dsml;
    }

    @Override
    public Document createDsml(LdapResult result) {
        Namespace ns = new Namespace("dsml", "http://www.dsml.org/DSML");
        Document doc = DocumentHelper.createDocument();
        Element dsmlElement = doc.addElement(new QName("dsml", ns));
        Element entriesElement = dsmlElement.addElement(new QName("directory-entries", ns));
        if (result != null) {
            for (LdapEntry le : result.getEntries()) {
                Element entryElement = this.createDsmlEntry(new QName("entry", ns), le, ns);
                entriesElement.add(entryElement);
            }
        }
        return doc;
    }

    @Override
    protected List<Element> createDsmlAttributes(LdapAttributes ldapAttributes, Namespace ns) {
        ArrayList<Element> attrElements = new ArrayList<Element>();
        for (LdapAttribute attr : ldapAttributes.getAttributes()) {
            String attrName = attr.getName();
            Set<Object> attrValues = attr.getValues();
            Element attrElement = null;
            if (attrName.equalsIgnoreCase("objectclass")) {
                attrElement = this.createDsmlAttribute(attrName, attrValues, ns, "objectclass", null, "oc-value");
                if (!attrElement.hasContent()) continue;
                attrElements.add(0, attrElement);
                continue;
            }
            attrElement = this.createDsmlAttribute(attrName, attrValues, ns, "attr", "name", "value");
            if (!attrElement.hasContent()) continue;
            attrElements.add(attrElement);
        }
        return attrElements;
    }

    public Iterator<SearchResult> createSearchResults(Document doc) {
        return this.createLdapResult(doc).toSearchResults().iterator();
    }

    @Override
    public LdapResult createLdapResult(Document doc) {
        LdapResult result = this.beanFactory.newLdapResult();
        if (doc != null && doc.hasContent()) {
            Iterator entryIterator = doc.selectNodes("/dsml:dsml/dsml:directory-entries/dsml:entry").iterator();
            while (entryIterator.hasNext()) {
                LdapEntry le = this.createLdapEntry((Element)entryIterator.next());
                if (result == null) continue;
                result.addEntry(le);
            }
        }
        return result;
    }

    @Override
    protected LdapEntry createLdapEntry(Element entryElement) {
        LdapEntry ldapEntry = this.beanFactory.newLdapEntry();
        ldapEntry.setDn("");
        if (entryElement != null) {
            String name = entryElement.attributeValue("dn");
            if (name != null) {
                ldapEntry.setDn(name);
            }
            if (entryElement.hasContent()) {
                Iterator ocIterator = entryElement.elementIterator("objectclass");
                while (ocIterator.hasNext()) {
                    Element ocElement = (Element)ocIterator.next();
                    if (ocElement == null || !ocElement.hasContent()) continue;
                    String ocName = "objectClass";
                    LdapAttribute ldapAttribute = this.beanFactory.newLdapAttribute();
                    ldapAttribute.setName("objectClass");
                    Iterator valueIterator = ocElement.elementIterator("oc-value");
                    while (valueIterator.hasNext()) {
                        String value;
                        Element valueElement = (Element)valueIterator.next();
                        if (valueElement == null || (value = valueElement.getText()) == null) continue;
                        String encoding = valueElement.attributeValue("encoding");
                        if (encoding != null && "base64".equals(encoding)) {
                            ldapAttribute.getValues().add(LdapUtil.base64Decode(value));
                            continue;
                        }
                        ldapAttribute.getValues().add(value);
                    }
                    ldapEntry.getLdapAttributes().addAttribute(ldapAttribute);
                }
                ldapEntry.getLdapAttributes().addAttributes(super.createLdapEntry(entryElement).getLdapAttributes().getAttributes());
            }
        }
        return ldapEntry;
    }
}

