/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.pool;

import edu.vt.middleware.ldap.BaseLdap;
import edu.vt.middleware.ldap.pool.LdapActivator;
import edu.vt.middleware.ldap.pool.LdapFactory;
import edu.vt.middleware.ldap.pool.LdapPassivator;
import edu.vt.middleware.ldap.pool.LdapValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLdapFactory<T extends BaseLdap>
implements LdapFactory<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected LdapActivator<T> activator;
    protected LdapPassivator<T> passivator;
    protected LdapValidator<T> validator;

    public void setLdapActivator(LdapActivator<T> la) {
        this.activator = la;
    }

    public LdapActivator<T> getLdapActivator() {
        return this.activator;
    }

    public void setLdapPassivator(LdapPassivator<T> lp) {
        this.passivator = lp;
    }

    public LdapPassivator<T> getLdapPassivator() {
        return this.passivator;
    }

    public void setLdapValidator(LdapValidator<T> lv) {
        this.validator = lv;
    }

    public LdapValidator<T> getLdapValidator() {
        return this.validator;
    }

    @Override
    public abstract T create();

    @Override
    public abstract void destroy(T var1);

    @Override
    public boolean activate(T t) {
        boolean success = false;
        if (this.activator == null) {
            success = true;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"no activator configured");
            }
        } else {
            success = this.activator.activate(t);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("activation for " + t + " = " + success));
            }
        }
        return success;
    }

    @Override
    public boolean passivate(T t) {
        boolean success = false;
        if (this.passivator == null) {
            success = true;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"no passivator configured");
            }
        } else {
            success = this.passivator.passivate(t);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("passivation for " + t + " = " + success));
            }
        }
        return success;
    }

    @Override
    public boolean validate(T t) {
        boolean success = false;
        if (this.validator == null) {
            success = true;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"validate called, but no validator configured");
            }
        } else {
            success = this.validator.validate(t);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("validation for " + t + " = " + success));
            }
        }
        return success;
    }
}

