/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ldif;

import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import edu.vt.middleware.ldap.bean.LdapBeanProvider;
import edu.vt.middleware.ldap.bean.LdapResult;
import edu.vt.middleware.ldap.ldif.Ldif;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdifResultConverter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected LdapBeanFactory beanFactory = LdapBeanProvider.getLdapBeanFactory();
    private Ldif ldif = new Ldif();

    public LdapBeanFactory getLdapBeanFactory() {
        return this.beanFactory;
    }

    public void setLdapBeanFactory(LdapBeanFactory lbf) {
        if (lbf != null) {
            this.beanFactory = lbf;
            this.ldif.setLdapBeanFactory(lbf);
        }
    }

    public String toLdif(LdapResult result) {
        StringWriter writer;
        block2: {
            writer = new StringWriter();
            try {
                this.ldif.outputLdif(result.toSearchResults().iterator(), (Writer)writer);
            }
            catch (IOException e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn((Object)"Could not write ldif to StringWriter", (Throwable)e);
            }
        }
        return writer.toString();
    }

    public LdapResult fromLdif(String ldif) {
        LdapResult result;
        block4: {
            result = this.beanFactory.newLdapResult();
            try {
                result.addEntries(this.ldif.importLdif(new StringReader(ldif)));
            }
            catch (IOException e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"Could not read ldif from StringReader", (Throwable)e);
                }
            }
            catch (NamingException e) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error((Object)"Unexpected naming exception occurred", (Throwable)e);
            }
        }
        return result;
    }
}

