/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.dsml;

import edu.vt.middleware.ldap.LdapUtil;
import edu.vt.middleware.ldap.bean.LdapAttribute;
import edu.vt.middleware.ldap.bean.LdapAttributes;
import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import edu.vt.middleware.ldap.bean.LdapBeanProvider;
import edu.vt.middleware.ldap.bean.LdapEntry;
import edu.vt.middleware.ldap.bean.LdapResult;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDsml
implements Serializable {
    private static final long serialVersionUID = -5626050181955100494L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected LdapBeanFactory beanFactory = LdapBeanProvider.getLdapBeanFactory();

    public LdapBeanFactory getLdapBeanFactory() {
        return this.beanFactory;
    }

    public void setLdapBeanFactory(LdapBeanFactory lbf) {
        if (lbf != null) {
            this.beanFactory = lbf;
        }
    }

    public abstract Document createDsml(Iterator<SearchResult> var1);

    public abstract Document createDsml(LdapResult var1);

    protected Element createDsmlEntry(QName entryName, LdapEntry ldapEntry, Namespace ns) {
        Element entryElement = DocumentHelper.createElement((QName)entryName);
        if (ldapEntry != null) {
            String dn = ldapEntry.getDn();
            if (dn != null) {
                entryElement.addAttribute("dn", dn);
            }
            for (Element e : this.createDsmlAttributes(ldapEntry.getLdapAttributes(), ns)) {
                entryElement.add(e);
            }
        }
        return entryElement;
    }

    protected List<Element> createDsmlAttributes(LdapAttributes ldapAttributes, Namespace ns) {
        ArrayList<Element> attrElements = new ArrayList<Element>();
        for (LdapAttribute attr : ldapAttributes.getAttributes()) {
            Set<Object> attrValues;
            String attrName = attr.getName();
            Element attrElement = this.createDsmlAttribute(attrName, attrValues = attr.getValues(), ns, "attr", "name", "value");
            if (!attrElement.hasContent()) continue;
            attrElements.add(attrElement);
        }
        return attrElements;
    }

    protected Element createDsmlAttribute(String attrName, Set<?> attrValues, Namespace ns, String elementName, String elementAttrName, String elementValueName) {
        Element attrElement = DocumentHelper.createElement((String)"");
        if (attrName != null) {
            attrElement.setQName(new QName(elementName, ns));
            if (elementAttrName != null) {
                attrElement.addAttribute(elementAttrName, attrName);
            }
            if (attrValues != null) {
                for (Object rawValue : attrValues) {
                    String value = null;
                    boolean isBase64 = false;
                    if (rawValue instanceof String) {
                        value = (String)rawValue;
                    } else if (rawValue instanceof byte[]) {
                        value = LdapUtil.base64Encode((byte[])rawValue);
                        isBase64 = true;
                    } else if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)"Could not cast attribute value as a byte[] or a String");
                    }
                    if (value == null) continue;
                    Element valueElement = attrElement.addElement(new QName(elementValueName, ns));
                    valueElement.addText(value);
                    if (!isBase64) continue;
                    valueElement.addAttribute("encoding", "base64");
                }
            }
        }
        return attrElement;
    }

    public void outputDsml(Iterator<SearchResult> results, Writer writer) throws IOException {
        XMLWriter xmlWriter = new XMLWriter(writer, OutputFormat.createPrettyPrint());
        xmlWriter.write(this.createDsml(results));
        writer.flush();
    }

    public void outputDsml(LdapResult result, Writer writer) throws IOException {
        XMLWriter xmlWriter = new XMLWriter(writer, OutputFormat.createPrettyPrint());
        xmlWriter.write(this.createDsml(result));
        writer.flush();
    }

    public Iterator<SearchResult> importDsml(Reader reader) throws DocumentException, IOException {
        Document dsml = new SAXReader().read(reader);
        return this.createLdapResult(dsml).toSearchResults().iterator();
    }

    public LdapResult importDsmlToLdapResult(Reader reader) throws DocumentException, IOException {
        Document dsml = new SAXReader().read(reader);
        return this.createLdapResult(dsml);
    }

    protected abstract LdapResult createLdapResult(Document var1);

    protected LdapEntry createLdapEntry(Element entryElement) {
        LdapEntry ldapEntry = this.beanFactory.newLdapEntry();
        ldapEntry.setDn("");
        if (entryElement != null) {
            String name = entryElement.attributeValue("dn");
            if (name != null) {
                ldapEntry.setDn(name);
            }
            if (entryElement.hasContent()) {
                Iterator attrIterator = entryElement.elementIterator("attr");
                while (attrIterator.hasNext()) {
                    Element attrElement = (Element)attrIterator.next();
                    String attrName = attrElement.attributeValue("name");
                    if (attrName == null || !attrElement.hasContent()) continue;
                    LdapAttribute ldapAttribute = this.beanFactory.newLdapAttribute();
                    ldapAttribute.setName(attrName);
                    Iterator valueIterator = attrElement.elementIterator("value");
                    while (valueIterator.hasNext()) {
                        Element valueElement = (Element)valueIterator.next();
                        String value = valueElement.getText();
                        if (value == null) continue;
                        String encoding = valueElement.attributeValue("encoding");
                        if (encoding != null && "base64".equals(encoding)) {
                            ldapAttribute.getValues().add(LdapUtil.base64Decode(value));
                            continue;
                        }
                        ldapAttribute.getValues().add(value);
                    }
                    ldapEntry.getLdapAttributes().addAttribute(ldapAttribute);
                }
            }
        }
        return ldapEntry;
    }
}

