/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.log4j2.producer;

import de.huxhorn.lilith.data.converter.Converter;
import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4j2LoggingConverter
implements Converter<LoggingEvent> {
    public static final String LOG4J_LEVEL_KEY = "log4j.level";
    public static final String LOG4J_LEVEL_VALUE_FATAL = "FATAL";
    private static final String APPLICATION_MDC_KEY = "application";

    public LoggingEvent convert(Object o) {
        StackTraceElement location;
        List list;
        ThreadContext.ContextStack ndc;
        Map props;
        String threadName;
        if (o == null) {
            return null;
        }
        if (!(o instanceof LogEvent)) {
            throw new IllegalArgumentException("" + o + " is not a " + this.getSourceClass() + "!");
        }
        LogEvent log4jEvent = (LogEvent)o;
        LoggingEvent result = new LoggingEvent();
        HashMap<String, String> mdc = new HashMap<String, String>();
        result.setLogger(log4jEvent.getLoggerName());
        Level log4jLevel = log4jEvent.getLevel();
        if (log4jLevel == Level.TRACE) {
            result.setLevel(LoggingEvent.Level.TRACE);
        } else if (log4jLevel == Level.DEBUG) {
            result.setLevel(LoggingEvent.Level.DEBUG);
        } else if (log4jLevel == Level.INFO) {
            result.setLevel(LoggingEvent.Level.INFO);
        } else if (log4jLevel == Level.WARN) {
            result.setLevel(LoggingEvent.Level.WARN);
        } else if (log4jLevel == Level.ERROR) {
            result.setLevel(LoggingEvent.Level.ERROR);
        } else if (log4jLevel == Level.FATAL) {
            mdc.put(LOG4J_LEVEL_KEY, LOG4J_LEVEL_VALUE_FATAL);
            result.setLevel(LoggingEvent.Level.ERROR);
        }
        result.setTimeStamp(Long.valueOf(log4jEvent.getMillis()));
        Message msg = log4jEvent.getMessage();
        if (msg != null) {
            result.setMessage(new de.huxhorn.lilith.data.logging.Message(msg.getFormattedMessage()));
        }
        if ((threadName = log4jEvent.getThreadName()) != null) {
            ThreadInfo threadInfo = new ThreadInfo();
            threadInfo.setName(threadName);
            result.setThreadInfo(threadInfo);
        }
        if ((props = log4jEvent.getContextMap()) != null) {
            mdc.putAll(props);
        }
        if (mdc.size() > 0) {
            result.setMdc(mdc);
        }
        if (mdc.containsKey(APPLICATION_MDC_KEY)) {
            LoggerContext context = new LoggerContext();
            context.setName((String)mdc.get(APPLICATION_MDC_KEY));
            result.setLoggerContext(context);
        }
        if ((ndc = log4jEvent.getContextStack()) != null && (list = ndc.asList()) != null && !list.isEmpty()) {
            de.huxhorn.lilith.data.logging.Message[] ndcResult = new de.huxhorn.lilith.data.logging.Message[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                String current = (String)list.get(i);
                if (current == null) continue;
                ndcResult[i] = new de.huxhorn.lilith.data.logging.Message(current);
            }
            result.setNdc(ndcResult);
        }
        if ((location = log4jEvent.getSource()) != null) {
            ExtendedStackTraceElement ste = new ExtendedStackTraceElement();
            ste.setClassName(location.getClassName());
            ste.setMethodName(location.getMethodName());
            ste.setFileName(location.getFileName());
            int line = location.getLineNumber();
            if (line < 0) {
                ste.setLineNumber(line);
            }
            result.setCallStack(new ExtendedStackTraceElement[]{ste});
        }
        result.setThrowable(this.convert(log4jEvent.getThrown()));
        return result;
    }

    private ThrowableInfo convert(Throwable thrown) {
        if (thrown == null) {
            return null;
        }
        ThrowableInfo result = new ThrowableInfo();
        result.setCause(this.convert(thrown.getCause()));
        result.setMessage(thrown.getMessage());
        result.setName(thrown.getClass().getName());
        StackTraceElement[] st = thrown.getStackTrace();
        if (st != null && st.length > 0) {
            ExtendedStackTraceElement[] stResult = new ExtendedStackTraceElement[st.length];
            for (int i = 0; i < st.length; ++i) {
                stResult[i] = this.convert(st[i]);
            }
            result.setStackTrace(stResult);
        }
        return result;
    }

    private ExtendedStackTraceElement convert(StackTraceElement ste) {
        if (ste == null) {
            return null;
        }
        ExtendedStackTraceElement result = new ExtendedStackTraceElement();
        result.setClassName(ste.getClassName());
        result.setFileName(ste.getFileName());
        result.setLineNumber(ste.getLineNumber());
        result.setMethodName(ste.getMethodName());
        return result;
    }

    public Class getSourceClass() {
        return LogEvent.class;
    }
}

