/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.conditions;

import de.huxhorn.lilith.conditions.LilithCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class CallLocationCondition
implements LilithCondition,
SearchStringCondition {
    private static final long serialVersionUID = -3772942542557888560L;
    public static final String DESCRIPTION = "CallLocation";
    private String searchString;
    private transient StackTraceElement stackTraceElement;

    public CallLocationCondition() {
        this(null);
    }

    public CallLocationCondition(String searchString) {
        this.setSearchString(searchString);
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        try {
            ExtendedStackTraceElement ste = ExtendedStackTraceElement.parseStackTraceElement((String)searchString);
            this.stackTraceElement = ste != null ? ste.getStackTraceElement() : null;
        }
        catch (Throwable e) {
            this.stackTraceElement = null;
        }
    }

    public String getSearchString() {
        return this.searchString;
    }

    public boolean isTrue(Object value) {
        LoggingEvent event;
        ExtendedStackTraceElement[] callStack;
        EventWrapper wrapper;
        Serializable eventObj;
        if (this.searchString == null) {
            return false;
        }
        if (this.searchString.length() == 0) {
            return true;
        }
        if (this.stackTraceElement == null) {
            return false;
        }
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof LoggingEvent && (callStack = (event = (LoggingEvent)eventObj).getCallStack()) != null && callStack.length > 0) {
            return this.stackTraceElement.equals(callStack[0].getStackTraceElement());
        }
        return false;
    }

    public CallLocationCondition clone() throws CloneNotSupportedException {
        CallLocationCondition result = (CallLocationCondition)super.clone();
        result.setSearchString(this.searchString);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallLocationCondition that = (CallLocationCondition)o;
        return !(this.stackTraceElement == null ? that.stackTraceElement != null : !this.stackTraceElement.equals(that.stackTraceElement));
    }

    public int hashCode() {
        return this.stackTraceElement != null ? this.stackTraceElement.hashCode() : 0;
    }

    private Object readResolve() throws ObjectStreamException {
        this.setSearchString(this.searchString);
        return this;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDescription());
        result.append("(");
        result.append(this.stackTraceElement);
        result.append(")");
        return result.toString();
    }
}

