/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Executable<T extends IExecutableProcessConfig, P extends IStopable>
implements IStopable {
    private static Logger logger = LoggerFactory.getLogger(Executable.class);
    private final T config;
    private final IRuntimeConfig runtimeConfig;
    private final IExtractedFileSet executable;
    private boolean stopped;
    private boolean registeredJobKiller;
    List<IStopable> stopables = new ArrayList<IStopable>();
    private final Distribution distribution;

    public Executable(Distribution distribution, T config, IRuntimeConfig runtimeConfig, IExtractedFileSet executable) {
        this.distribution = distribution;
        this.config = config;
        this.runtimeConfig = runtimeConfig;
        this.executable = executable;
        if (runtimeConfig.isDaemonProcess()) {
            ProcessControl.addShutdownHook(new JobKiller());
            this.registeredJobKiller = true;
        }
    }

    @Override
    public boolean isRegisteredJobKiller() {
        return this.registeredJobKiller;
    }

    @Deprecated
    public synchronized void cleanup() {
        this.stop();
    }

    @Override
    public synchronized void stop() {
        if (!this.stopped) {
            for (IStopable s : this.stopables) {
                s.stop();
            }
            this.stopables = new ArrayList<IStopable>();
            this.runtimeConfig.getArtifactStore().removeFileSet(this.distribution, this.executable);
            this.stopped = true;
        }
    }

    public IExtractedFileSet getFile() {
        return this.executable;
    }

    public synchronized P start() throws IOException {
        if (this.stopped) {
            throw new RuntimeException("Already stopped");
        }
        P start = this.start(this.distribution, this.config, this.runtimeConfig);
        logger.info("start {}", this.config);
        this.addStopable(start);
        return start;
    }

    private void addStopable(P start) {
        this.stopables.add((IStopable)start);
    }

    protected abstract P start(Distribution var1, T var2, IRuntimeConfig var3) throws IOException;

    class JobKiller
    implements Runnable {
        JobKiller() {
        }

        @Override
        public void run() {
            Executable.this.stop();
        }
    }
}

